/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.pde.api.tools.internal.provisional.builder.IBuildContext;

public class BuildContext
implements IBuildContext {
    private static final String[] NO_TYPES = new String[0];
    private StringSet structchanged = null;
    private StringSet dependents = null;
    private StringSet removed = null;

    public String[] getStructurallyChangedTypes() {
        if (this.structchanged == null) {
            return NO_TYPES;
        }
        return this.structchanged.values;
    }

    public String[] getRemovedTypes() {
        if (this.removed == null) {
            return NO_TYPES;
        }
        return this.removed.values;
    }

    public String[] getDependentTypes() {
        if (this.dependents == null) {
            return NO_TYPES;
        }
        return this.dependents.values;
    }

    public boolean hasChangedTypes() {
        int count = this.structchanged == null ? 0 : this.structchanged.elementSize;
        return (count += this.removed == null ? 0 : this.removed.elementSize) > 0;
    }

    public boolean hasDependentTypes() {
        return (this.dependents == null ? 0 : this.dependents.elementSize) > 0;
    }

    public boolean hasRemovedTypes() {
        return (this.removed == null ? 0 : this.removed.elementSize) > 0;
    }

    public void recordStructurallyChangedType(String typename) {
        if (typename == null) {
            return;
        }
        if (this.structchanged == null) {
            this.structchanged = new StringSet(16);
        }
        this.structchanged.add(typename);
    }

    public void recordRemovedType(String typename) {
        if (typename == null) {
            return;
        }
        if (this.removed == null) {
            this.removed = new StringSet(16);
        }
        this.removed.add(typename);
    }

    public void recordDependentType(String typename) {
        if (typename == null) {
            return;
        }
        if (this.dependents == null) {
            this.dependents = new StringSet(32);
        }
        this.dependents.add(typename);
    }

    public void dispose() {
        if (this.structchanged != null) {
            this.structchanged.clear();
            this.structchanged = null;
        }
        if (this.dependents != null) {
            this.dependents.clear();
            this.dependents = null;
        }
    }

    public boolean hasTypes() {
        return this.hasChangedTypes() || this.hasDependentTypes() || this.hasRemovedTypes();
    }

    public boolean containsChangedType(String typename) {
        if (typename == null) {
            return false;
        }
        return this.structchanged != null && this.structchanged.includes(typename);
    }

    public boolean containsDependentType(String typename) {
        if (typename == null) {
            return false;
        }
        return this.dependents != null && this.dependents.includes(typename);
    }

    public boolean containsRemovedType(String typename) {
        if (typename == null) {
            return false;
        }
        return this.removed != null && this.removed.includes(typename);
    }
}

