/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import java.util.Arrays;
import org.eclipse.equinox.p2.internal.repository.comparator.AttributeNamesConstants;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFileStruct;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPoolEntry;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantValueAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.RuntimeInvisibleAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.RuntimeVisibleAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.SignatureAttribute;

public class FieldInfo
extends ClassFileStruct {
    private int accessFlags;
    private int attributeBytes;
    private ClassFileAttribute[] attributes;
    private int attributesCount;
    private ConstantValueAttribute constantValueAttribute;
    private char[] descriptor;
    private int descriptorIndex;
    private boolean isDeprecated;
    private boolean isSynthetic;
    private char[] name;
    private int nameIndex;

    public FieldInfo(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        int flags;
        this.accessFlags = flags = this.u2At(classFileBytes, 0, offset);
        if ((flags & 0x1000) != 0) {
            this.isSynthetic = true;
        }
        this.nameIndex = this.u2At(classFileBytes, 2, offset);
        ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.nameIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.name = constantPoolEntry.getUtf8Value();
        this.descriptorIndex = this.u2At(classFileBytes, 4, offset);
        constantPoolEntry = constantPool.decodeEntry(this.descriptorIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.descriptor = constantPoolEntry.getUtf8Value();
        this.attributesCount = this.u2At(classFileBytes, 6, offset);
        this.attributes = ClassFileAttribute.NO_ATTRIBUTES;
        int readOffset = 8;
        if (this.attributesCount != 0) {
            this.attributes = new ClassFileAttribute[this.attributesCount];
        }
        int attributesIndex = 0;
        int i = 0;
        while (i < this.attributesCount) {
            constantPoolEntry = constantPool.decodeEntry(this.u2At(classFileBytes, readOffset, offset));
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            char[] attributeName = constantPoolEntry.getUtf8Value();
            if (Arrays.equals(attributeName, AttributeNamesConstants.DEPRECATED)) {
                this.isDeprecated = true;
                this.attributes[attributesIndex++] = new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset);
            } else if (Arrays.equals(attributeName, AttributeNamesConstants.SYNTHETIC)) {
                this.isSynthetic = true;
                this.attributes[attributesIndex++] = new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset);
            } else if (Arrays.equals(attributeName, AttributeNamesConstants.CONSTANT_VALUE)) {
                this.constantValueAttribute = new ConstantValueAttribute(classFileBytes, constantPool, offset + readOffset);
                this.attributes[attributesIndex++] = this.constantValueAttribute;
            } else {
                this.attributes[attributesIndex++] = Arrays.equals(attributeName, AttributeNamesConstants.SIGNATURE) ? new SignatureAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS) ? new RuntimeVisibleAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS) ? new RuntimeInvisibleAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset)));
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(classFileBytes, readOffset + 2, offset)));
            ++i;
        }
        this.attributeBytes = readOffset;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }

    public ClassFileAttribute[] getAttributes() {
        return this.attributes;
    }

    public ConstantValueAttribute getConstantValueAttribute() {
        return this.constantValueAttribute;
    }

    public char[] getDescriptor() {
        return this.descriptor;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public char[] getName() {
        return this.name;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public boolean hasConstantValueAttribute() {
        return this.constantValueAttribute != null;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    int sizeInBytes() {
        return this.attributeBytes;
    }
}

