/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import org.eclipse.equinox.p2.internal.repository.comparator.AnnotationComponent;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFileStruct;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPoolEntry;

public class Annotation
extends ClassFileStruct {
    private static final AnnotationComponent[] NO_ENTRIES = new AnnotationComponent[0];
    private int typeIndex;
    private char[] typeName;
    private int componentsNumber;
    private AnnotationComponent[] components;
    private int readOffset;

    public Annotation(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        int length;
        ConstantPoolEntry constantPoolEntry;
        int index;
        this.typeIndex = index = this.u2At(classFileBytes, 0, offset);
        if (index != 0) {
            constantPoolEntry = constantPool.decodeEntry(index);
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
        } else {
            throw new ClassFormatException(3);
        }
        this.typeName = constantPoolEntry.getUtf8Value();
        this.componentsNumber = length = this.u2At(classFileBytes, 2, offset);
        this.readOffset = 4;
        if (length != 0) {
            this.components = new AnnotationComponent[length];
            int i = 0;
            while (i < length) {
                AnnotationComponent component;
                this.components[i] = component = new AnnotationComponent(classFileBytes, constantPool, offset + this.readOffset);
                this.readOffset += component.sizeInBytes();
                ++i;
            }
        } else {
            this.components = NO_ENTRIES;
        }
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public int getComponentsNumber() {
        return this.componentsNumber;
    }

    public AnnotationComponent[] getComponents() {
        return this.components;
    }

    int sizeInBytes() {
        return this.readOffset;
    }

    public char[] getTypeName() {
        return this.typeName;
    }
}

