/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.resource.java.binary;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.resource.java.TransformerAnnotation;

abstract class BinaryTransformerAnnotation
extends BinaryAnnotation
implements TransformerAnnotation {
    private String transformerClass = this.buildTransformerClass();
    private String method = this.buildMethod();

    BinaryTransformerAnnotation(JavaResourcePersistentAttribute parent, IAnnotation jdtAnnotation) {
        super((JavaResourceNode)parent, jdtAnnotation);
    }

    public void update() {
        super.update();
        this.setTransformerClass_(this.buildTransformerClass());
        this.setMethod_(this.buildMethod());
    }

    public String getTransformerClass() {
        return this.transformerClass;
    }

    public void setTransformerClass(String transformerClass) {
        throw new UnsupportedOperationException();
    }

    private void setTransformerClass_(String transformerClass) {
        String old = this.transformerClass;
        this.transformerClass = transformerClass;
        this.firePropertyChanged("transformerClass", old, transformerClass);
    }

    private String buildTransformerClass() {
        return (String)this.getJdtMemberValue(this.getTransformerClassElementName());
    }

    public TextRange getTransformerClassTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    abstract String getTransformerClassElementName();

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        throw new UnsupportedOperationException();
    }

    private void setMethod_(String method) {
        String old = this.method;
        this.method = method;
        this.firePropertyChanged("method", old, method);
    }

    private String buildMethod() {
        return (String)this.getJdtMemberValue(this.getMethodElementName());
    }

    public TextRange getMethodTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    abstract String getMethodElementName();
}

