/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.Point;

public class PrecisionPoint
extends Point {
    public double preciseX;
    public double preciseY;

    public PrecisionPoint() {
    }

    public PrecisionPoint(Point copy) {
        this.preciseX = copy.preciseX();
        this.preciseY = copy.preciseY();
        this.updateInts();
    }

    public PrecisionPoint(int x, int y) {
        super(x, y);
        this.preciseX = x;
        this.preciseY = y;
    }

    public PrecisionPoint(double x, double y) {
        this.preciseX = x;
        this.preciseY = y;
        this.updateInts();
    }

    public Point getCopy() {
        return new PrecisionPoint(this.preciseX, this.preciseY);
    }

    public void performScale(double factor) {
        this.preciseX *= factor;
        this.preciseY *= factor;
        this.updateInts();
    }

    public void performTranslate(int dx, int dy) {
        this.preciseX += (double)dx;
        this.preciseY += (double)dy;
        this.updateInts();
    }

    public Point setLocation(Point pt) {
        this.preciseX = pt.preciseX();
        this.preciseY = pt.preciseY();
        this.updateInts();
        return this;
    }

    public final void updateInts() {
        this.x = (int)Math.floor(this.preciseX + 1.0E-9);
        this.y = (int)Math.floor(this.preciseY + 1.0E-9);
    }

    public double preciseX() {
        return this.preciseX;
    }

    public double preciseY() {
        return this.preciseY;
    }

    public boolean equals(Object o) {
        if (o instanceof PrecisionPoint) {
            PrecisionPoint p = (PrecisionPoint)o;
            return p.preciseX == this.preciseX && p.preciseY == this.preciseY;
        }
        return super.equals(o);
    }
}

