/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.views;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMNodeLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        if (element instanceof Document) {
            return element.toString();
        }
        if (element instanceof Element) {
            StringBuffer sb = new StringBuffer(((Element)element).getTagName());
            NamedNodeMap attrs = ((Element)element).getAttributes();
            if (attrs.getLength() > 0) {
                sb.append("(");
                int i = 0;
                while (i < attrs.getLength()) {
                    Attr attr = (Attr)attrs.item(i);
                    sb.append('@').append(attr.getName()).append("=\"").append(attr.getValue()).append('\"');
                    if (i < attrs.getLength() - 1) {
                        sb.append(' ');
                    }
                    ++i;
                }
                sb.append(")");
            }
            return sb.toString();
        }
        if (element instanceof Comment) {
            return element.toString();
        }
        if (element instanceof Attr) {
            Attr attr = (Attr)element;
            return "@" + attr.getName() + "=\"" + attr.getValue() + "\"";
        }
        if (element instanceof CDATASection) {
            return element.toString();
        }
        if (element instanceof Entity) {
            return element.toString();
        }
        if (element instanceof ProcessingInstruction) {
            return element.toString();
        }
        if (element instanceof DocumentType) {
            return element.toString();
        }
        if (element instanceof Text) {
            return ((Text)element).getData();
        }
        return element.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof Document) {
            return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-generic.gif");
        }
        if (element instanceof Element) {
            return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/element_obj.gif");
        }
        if (element instanceof Comment) {
            return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/comment_obj.gif");
        }
        if (element instanceof CDATASection) {
            return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/cdatasection.gif");
        }
        if (element instanceof Entity) {
            return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/entity.gif");
        }
        if (element instanceof ProcessingInstruction) {
            return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/proinst_obj.gif");
        }
        if (element instanceof DocumentType) {
            return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/doctype.gif");
        }
        if (element instanceof Attr) {
            return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/attribute_obj.gif");
        }
        if (element instanceof Text) {
            return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/text.gif");
        }
        return super.getImage(element);
    }
}

