/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import org.eclipse.core.databinding.beans.IBeanListProperty;
import org.eclipse.core.databinding.beans.IBeanValueProperty;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.ListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;

public class PojoListPropertyDecorator
extends ListProperty
implements IBeanListProperty {
    private final IListProperty delegate;
    private final PropertyDescriptor propertyDescriptor;

    public PojoListPropertyDecorator(IListProperty delegate, PropertyDescriptor propertyDescriptor) {
        this.delegate = delegate;
        this.propertyDescriptor = propertyDescriptor;
    }

    public Object getElementType() {
        return this.delegate.getElementType();
    }

    public IBeanListProperty values(String propertyName) {
        return this.values(propertyName, null);
    }

    public IBeanListProperty values(String propertyName, Class valueType) {
        Class beanClass = (Class)this.delegate.getElementType();
        return this.values(PojoProperties.value(beanClass, propertyName, valueType));
    }

    public IBeanListProperty values(IBeanValueProperty property) {
        return new PojoListPropertyDecorator(super.values((IValueProperty)property), property.getPropertyDescriptor());
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.propertyDescriptor;
    }

    public IObservableList observe(Object source) {
        return new BeanObservableListDecorator(this.delegate.observe(source), this.propertyDescriptor);
    }

    public IObservableList observe(Realm realm, Object source) {
        return new BeanObservableListDecorator(this.delegate.observe(realm, source), this.propertyDescriptor);
    }

    public IObservableFactory listFactory() {
        return this.delegate.listFactory();
    }

    public IObservableFactory listFactory(Realm realm) {
        return this.delegate.listFactory(realm);
    }

    public IObservableList observeDetail(IObservableValue master) {
        return new BeanObservableListDecorator(this.delegate.observeDetail(master), this.propertyDescriptor);
    }

    public String toString() {
        return this.delegate.toString();
    }
}

