/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.internal.mergers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.ejb.InitMethodType;
import org.eclipse.jst.javaee.ejb.MethodParams;
import org.eclipse.jst.javaee.ejb.RemoveMethodType;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.internal.mergers.AccessibleBeanMerger;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;

public class SessionBeanMerger
extends AccessibleBeanMerger {
    public SessionBeanMerger(SessionBean _baseBean, SessionBean _toMergeBean, int _kind) {
        super(_baseBean, _toMergeBean, _kind);
    }

    public List process() throws ModelException {
        ArrayList warnings = new ArrayList();
        warnings.addAll(super.process());
        this.mergeInitMethods(warnings);
        this.mergeRemoveMethods(warnings);
        this.mergeSecurityRoleRefs(warnings);
        return warnings;
    }

    private void mergeInitMethods(List warnings) throws ModelException {
        List initXMLMappings = this.getBaseBean().getInitMethods();
        List initAnnotationMappings = this.getToMergeBean().getInitMethods();
        for (Object object : initAnnotationMappings) {
            if (this.containsInitMethod(initXMLMappings, (InitMethodType)object)) continue;
            initXMLMappings.add(EcoreUtil.copy((EObject)((EObject)object)));
        }
    }

    private boolean containsInitMethod(List initXMLMappings, InitMethodType initMethod) {
        for (Object object : initXMLMappings) {
            InitMethodType searched = (InitMethodType)object;
            if (!initMethod.getBeanMethod().getMethodName().equals(searched.getBeanMethod().getMethodName()) || !this.sameParams(initMethod.getBeanMethod().getMethodParams(), searched.getBeanMethod().getMethodParams())) continue;
            return true;
        }
        return false;
    }

    private void mergeRemoveMethods(List warnings) throws ModelException {
        List removeBaseMethods = this.getBaseBean().getRemoveMethods();
        List removeToMergeMethods = this.getToMergeBean().getRemoveMethods();
        if (removeToMergeMethods == null || removeToMergeMethods.isEmpty()) {
            return;
        }
        for (Object object : removeToMergeMethods) {
            RemoveMethodType base = this.getRemoveMethodType(removeBaseMethods, (RemoveMethodType)object);
            if (base != null) {
                if (((RemoveMethodType)object).isRetainIfException() == base.isRetainIfException()) continue;
                base.setRetainIfException(((RemoveMethodType)object).isRetainIfException());
                continue;
            }
            this.getBaseBean().getRemoveMethods().add(EcoreUtil.copy((EObject)((EObject)object)));
        }
    }

    private RemoveMethodType getRemoveMethodType(List removeBaseMethods, RemoveMethodType object) {
        for (Object base : removeBaseMethods) {
            RemoveMethodType tmpBase = (RemoveMethodType)base;
            if (!tmpBase.getBeanMethod().getMethodName().equals(object.getBeanMethod().getMethodName()) || !this.sameParams(tmpBase.getBeanMethod().getMethodParams(), object.getBeanMethod().getMethodParams())) continue;
            return (RemoveMethodType)base;
        }
        return null;
    }

    private boolean sameParams(MethodParams methodParams, MethodParams methodParams2) {
        if (methodParams == null && methodParams2 == null) {
            return true;
        }
        if (methodParams == null | methodParams2 == null) {
            return false;
        }
        if (methodParams.getMethodParams().size() != methodParams2.getMethodParams().size()) {
            return false;
        }
        int i = 0;
        while (i < methodParams.getMethodParams().size()) {
            if (!methodParams.getMethodParams().get(i).equals(methodParams2.getMethodParams().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void mergeSecurityRoleRefs(List warnings) throws ModelException {
        List toMergeList = this.getToMergeBean().getSecurityRoleRefs();
        for (Object roleRef : toMergeList) {
            if (this.existingSecRoleRef(this.getBaseBean().getSecurityRoleRefs(), (SecurityRoleRef)roleRef)) continue;
            this.getBaseBean().getSecurityRoleRefs().add(EcoreUtil.copy((EObject)((EObject)roleRef)));
        }
    }

    private boolean existingSecRoleRef(List roles, SecurityRoleRef secRole) {
        for (Object object : roles) {
            SecurityRoleRef cRole = (SecurityRoleRef)object;
            if (!cRole.getRoleName().equals(secRole.getRoleName())) continue;
            return true;
        }
        return false;
    }
}

