/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.ui.wizards;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.SortedMap;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.TextProcessorWrapper;
import org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages;
import org.eclipse.datatools.connectivity.oda.flatfile.ui.util.Utility;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FolderSelectionPageHelper {
    private WizardPage wizardPage;
    private PreferencePage propertyPage;
    private transient Text folderLocation = null;
    private transient Button typeLineCheckBox = null;
    private transient Button browseFolderButton = null;
    private transient Combo charSetSelectionCombo = null;
    private transient Button columnNameLineCheckBox = null;
    private transient Combo flatFileStyleCombo = null;
    private static final String[] flatFileStyles = new String[]{Messages.getString("label.flatfileComma"), Messages.getString("label.flatfileSemicolon"), Messages.getString("label.flatfilePipe"), Messages.getString("label.flatfileTab")};
    private SortedMap charSetMap;
    static final String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectFolder");
    private static final int CORRECT_FOLDER = 0;
    private static final int ERROR_FOLDER = 1;
    private static final int ERROR_EMPTY_PATH = 2;
    private static final String EMPTY_STRING = "";

    FolderSelectionPageHelper(WizardPage page) {
        this.wizardPage = page;
    }

    FolderSelectionPageHelper(PreferencePage page) {
        this.propertyPage = page;
    }

    void createCustomControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        content.setLayout((Layout)layout);
        this.setupFolderLocation(content);
        this.setupCharset(content);
        this.setupFlatfileStyleList(content);
        this.setupColumnNameLineCheckBox(content);
        this.setupTypeLineCheckBox(content);
        Utility.setSystemHelp(this.getControl(), "org.eclipse.datatools.oda.cshelp.Wizard_FlatfileDatasource_ID");
    }

    String getFolderLocation() {
        if (this.folderLocation == null) {
            return EMPTY_STRING;
        }
        return this.getFolderLocationString();
    }

    String getWhetherUseFirstLineAsColumnNameLine() {
        if (this.columnNameLineCheckBox == null || !this.columnNameLineCheckBox.getEnabled()) {
            return EMPTY_STRING;
        }
        return this.columnNameLineCheckBox.getSelection() ? "YES" : "NO";
    }

    String getWhetherUseSecondLineAsTypeLine() {
        if (this.typeLineCheckBox == null) {
            return EMPTY_STRING;
        }
        return this.typeLineCheckBox.getSelection() ? "YES" : "NO";
    }

    String getCharSet() {
        if (this.charSetSelectionCombo == null) {
            return EMPTY_STRING;
        }
        return this.charSetSelectionCombo.getItem(this.charSetSelectionCombo.getSelectionIndex());
    }

    Properties collectCustomProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        props.setProperty("HOME", this.getFolderLocation().trim());
        props.setProperty("DELIMTYPE", this.getFlatfileStyle());
        props.setProperty("INCLCOLUMNNAME", this.getWhetherUseFirstLineAsColumnNameLine());
        props.setProperty("INCLTYPELINE", this.getWhetherUseSecondLineAsTypeLine());
        props.setProperty("CHARSET", this.getCharSet());
        return props;
    }

    void initCustomControl(Properties profileProps) {
        if (profileProps == null || profileProps.isEmpty() || this.folderLocation == null) {
            return;
        }
        String folderPath = profileProps.getProperty("HOME");
        if (folderPath == null) {
            folderPath = EMPTY_STRING;
        }
        this.setFolderLocationString(folderPath);
        String delimiterType = profileProps.getProperty("DELIMTYPE");
        this.initFlatfileSytleSelection(delimiterType);
        String hasColumnNameLine = profileProps.getProperty("INCLCOLUMNNAME");
        if (hasColumnNameLine == null) {
            hasColumnNameLine = "YES";
        }
        if (hasColumnNameLine.equalsIgnoreCase("YES")) {
            this.columnNameLineCheckBox.setSelection(true);
            String useSecondLine = profileProps.getProperty("INCLTYPELINE");
            if (useSecondLine == null) {
                useSecondLine = EMPTY_STRING;
            }
            this.typeLineCheckBox.setEnabled(true);
            this.typeLineCheckBox.setSelection(useSecondLine.equalsIgnoreCase("YES"));
        } else {
            this.columnNameLineCheckBox.setSelection(false);
            this.typeLineCheckBox.setSelection(false);
            this.typeLineCheckBox.setEnabled(false);
        }
        String charSet = profileProps.getProperty("CHARSET");
        if (charSet == null || charSet.trim().length() == 0) {
            this.charSetSelectionCombo.select(0);
        } else {
            this.charSetSelectionCombo.select(this.charSetSelectionCombo.indexOf(charSet));
        }
        this.verifyFileLocation();
    }

    private String getFlatfileStyle() {
        String value = this.flatFileStyleCombo.getText();
        if (value.equals(flatFileStyles[0])) {
            return "COMMA";
        }
        if (value.equals(flatFileStyles[1])) {
            return "SEMICOLON";
        }
        if (value.equals(flatFileStyles[2])) {
            return "PIPE";
        }
        if (value.equals(flatFileStyles[3])) {
            return "TAB";
        }
        return "COMMA";
    }

    private void setFolderLocationString(String folderPath) {
        this.folderLocation.setText(TextProcessorWrapper.process((String)folderPath));
    }

    private String getFolderLocationString() {
        return TextProcessorWrapper.deprocess((String)this.folderLocation.getText());
    }

    private void initFlatfileSytleSelection(String delimiterType) {
        if ("COMMA".equals(delimiterType)) {
            this.flatFileStyleCombo.select(0);
        } else if ("SEMICOLON".equals(delimiterType)) {
            this.flatFileStyleCombo.select(1);
        } else if ("PIPE".equals(delimiterType)) {
            this.flatFileStyleCombo.select(2);
        } else if ("TAB".equals(delimiterType)) {
            this.flatFileStyleCombo.select(3);
        }
    }

    private void setupFolderLocation(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("label.selectFolder"));
        GridData data = new GridData(768);
        this.folderLocation = new Text(composite, 2048);
        this.folderLocation.setLayoutData((Object)data);
        this.setPageComplete(false);
        this.folderLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FolderSelectionPageHelper.this.verifyFileLocation();
            }
        });
        this.browseFolderButton = new Button(composite, 0);
        this.browseFolderButton.setText(Messages.getString("button.selectFolder.browse"));
        this.browseFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(FolderSelectionPageHelper.this.folderLocation.getShell());
                String folderLocationValue = FolderSelectionPageHelper.this.getFolderLocationString();
                if (folderLocationValue != null && folderLocationValue.trim().length() > 0) {
                    dialog.setFilterPath(folderLocationValue);
                }
                dialog.setMessage(DEFAULT_MESSAGE);
                String selectedLocation = dialog.open();
                if (selectedLocation != null) {
                    FolderSelectionPageHelper.this.setFolderLocationString(selectedLocation);
                }
            }
        });
    }

    private int verifyFileLocation() {
        int result = 0;
        String folderLocationValue = this.getFolderLocationString();
        if (folderLocationValue.trim().length() > 0) {
            File f = new File(folderLocationValue.trim());
            if (f.exists()) {
                this.setMessage(DEFAULT_MESSAGE, 0);
                this.setPageComplete(true);
            } else {
                this.setMessage(Messages.getString("error.selectFolder"), 3);
                this.setPageComplete(false);
                result = 1;
            }
        } else {
            this.setMessage(Messages.getString("error.emptyPath"), 3);
            this.setPageComplete(false);
            result = 2;
        }
        if (result == 0) {
            return result;
        }
        if (this.wizardPage == null) {
            this.setPageComplete(true);
            this.setMessage(Messages.getString("error.invalidFlatFilePath"), 3);
        }
        return result;
    }

    private void setupCharset(Composite composite) {
        Label labelCharSet = new Label(composite, 0);
        labelCharSet.setText(Messages.getString("label.selectCharset"));
        this.charSetSelectionCombo = new Combo(composite, 8);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.charSetSelectionCombo.setLayoutData((Object)data);
        this.charSetMap = Charset.availableCharsets();
        Object[] charSetsArray = this.charSetMap.keySet().toArray();
        int i = 0;
        while (i < charSetsArray.length) {
            String charSetName = ((Charset)this.charSetMap.get(charSetsArray[i])).name();
            this.charSetSelectionCombo.add(charSetName);
            if ("UTF-8".equalsIgnoreCase(charSetName)) {
                this.charSetSelectionCombo.select(i);
            }
            ++i;
        }
    }

    private void setupFlatfileStyleList(Composite composite) {
        Label labelCSVType = new Label(composite, 0);
        labelCSVType.setText(Messages.getString("label.selectFlatfileStyle"));
        this.flatFileStyleCombo = new Combo(composite, 8);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.flatFileStyleCombo.setLayoutData((Object)data);
        int i = 0;
        while (i < flatFileStyles.length) {
            this.flatFileStyleCombo.add(flatFileStyles[i]);
            ++i;
        }
        this.flatFileStyleCombo.select(0);
    }

    private void setupColumnNameLineCheckBox(Composite composite) {
        Label labelFill = new Label(composite, 0);
        labelFill.setText(EMPTY_STRING);
        this.columnNameLineCheckBox = new Button(composite, 32);
        this.columnNameLineCheckBox.setToolTipText(Messages.getString("tooltip.columnnameline"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.columnNameLineCheckBox.setLayoutData((Object)gd);
        this.columnNameLineCheckBox.setText(Messages.getString("label.includeColumnNameLine"));
        this.columnNameLineCheckBox.setSelection(true);
        this.columnNameLineCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FolderSelectionPageHelper.this.columnNameLineCheckBox.getSelection()) {
                    FolderSelectionPageHelper.this.typeLineCheckBox.setEnabled(true);
                } else {
                    FolderSelectionPageHelper.this.typeLineCheckBox.setSelection(false);
                    FolderSelectionPageHelper.this.typeLineCheckBox.setEnabled(false);
                }
            }
        });
    }

    private void setupTypeLineCheckBox(Composite composite) {
        this.typeLineCheckBox = new Button(composite, 32);
        this.typeLineCheckBox.setToolTipText(Messages.getString("tooltip.typeline"));
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.typeLineCheckBox.setLayoutData((Object)data);
        this.typeLineCheckBox.setText(Messages.getString("label.includeTypeLine"));
        if (this.columnNameLineCheckBox.getSelection()) {
            this.typeLineCheckBox.setEnabled(true);
        } else {
            this.typeLineCheckBox.setSelection(false);
            this.typeLineCheckBox.setEnabled(false);
        }
    }

    private void setPageComplete(boolean complete) {
        if (this.wizardPage != null) {
            this.wizardPage.setPageComplete(complete);
        } else if (this.propertyPage != null) {
            this.propertyPage.setValid(complete);
        }
    }

    private void setMessage(String newMessage, int newType) {
        if (this.wizardPage != null) {
            this.wizardPage.setMessage(newMessage, newType);
        } else if (this.propertyPage != null) {
            this.propertyPage.setMessage(newMessage, newType);
        }
    }

    private Control getControl() {
        if (this.wizardPage != null) {
            return this.wizardPage.getControl();
        }
        if (this.propertyPage != null) {
            return this.propertyPage.getControl();
        }
        return null;
    }
}

