/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchQuery;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;

public class SearchServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String PARAMETER_PHRASE = "phrase";
    private Collection results = new ArrayList();
    private ISearchHitCollector collector = new ISearchHitCollector(){

        public void addHits(List hits, String wordsSearched) {
            if (SearchServlet.this.results != null) {
                SearchServlet.this.results.addAll(hits);
            }
        }
    };

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("application/xml; charset=UTF-8");
        String phrase = req.getParameter(PARAMETER_PHRASE);
        if (phrase != null) {
            phrase = URLCoder.decode((String)phrase);
            SearchQuery query = new SearchQuery(phrase, false, (Collection)Collections.EMPTY_LIST, locale);
            this.results.clear();
            BaseHelpSystem.getSearchManager().search((ISearchQuery)query, this.collector, (IProgressMonitor)new NullProgressMonitor());
            String response = SearchServlet.serialize(this.results);
            resp.getWriter().write(response);
        } else {
            resp.sendError(400);
        }
    }

    public static String serialize(Collection results) {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<searchHits>\n");
        Iterator iter = results.iterator();
        while (iter.hasNext()) {
            SearchHit hit = (SearchHit)iter.next();
            SearchServlet.serialize(hit, buf, "   ");
        }
        buf.append("</searchHits>\n");
        return buf.toString();
    }

    private static void serialize(SearchHit hit, StringBuffer buf, String indent) {
        buf.append(String.valueOf(indent) + "<hit");
        if (hit.getHref() != null) {
            buf.append(String.valueOf('\n') + indent + "      href=\"" + XMLGenerator.xmlEscape(hit.getHref()) + '\"');
        }
        if (hit.getLabel() != null) {
            buf.append(String.valueOf('\n') + indent + "      label=\"" + XMLGenerator.xmlEscape(hit.getLabel()) + '\"');
        }
        if (hit.isPotentialHit()) {
            buf.append(String.valueOf('\n') + indent + "      isPotentialHit=\"true\"");
        }
        buf.append(String.valueOf('\n') + indent + "      score=\"" + hit.getScore() + '\"');
        buf.append(">\n");
        String summary = hit.getSummary();
        if (summary != null) {
            SearchServlet.serialize(summary, buf, String.valueOf(indent) + "   ");
        }
        buf.append(String.valueOf(indent) + "</hit>\n");
    }

    private static void serialize(String summary, StringBuffer buf, String indent) {
        buf.append(String.valueOf(indent) + "<summary>");
        buf.append(XMLGenerator.xmlEscape(summary));
        buf.append("</summary>\n");
    }
}

