/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.parsers.sql.query.postparse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableFunction;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.WithTableReference;
import org.eclipse.datatools.modelbase.sql.query.helper.DatabaseHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceInfo;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParseErrorInfo;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserLogger;
import org.eclipse.datatools.sqltools.parsers.sql.postparse.PostParseProcessor;
import org.eclipse.datatools.sqltools.parsers.sql.postparse.PostParseProcessorConfiguration;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserMessages;
import org.eclipse.emf.common.util.EList;

public class TableReferenceResolver
implements PostParseProcessor {
    protected static Class[] CANDIDATE_TYPES = new Class[]{QueryStatement.class, TableExpression.class, QuerySelect.class, TableInDatabase.class, TableJoined.class, WithTableReference.class, ValueExpressionColumn.class};
    public static final String ERROR_CODE_DATABASE_SCHEMAS_NOTLOADED = "DatabaseSchemasNotLoaded";
    public static final String ERROR_CODE_COLUMN_UNRESOLVED = "SQL_?ColumnRefUnresolved";
    public static final String ERROR_CODE_TABLE_UNRESOLVED = "SQL_?TableRefUnresolved";
    public static final String ERROR_CODE_NONEXISTENT_COLUMN = "SQL_?NoSuchColumn";
    public static final String ERROR_CODE_COLUMN_AMBIGUOUS = "SQL_?AmbiguousColumn";
    protected static final String ERROR_MESSAGE_KEY_DATABASE_SCHEMAS_NOTLOADED = "TableReferenceResolver.SCHEMAS_NOT_LOADED";
    protected static final String ERROR_MESSAGE_KEY_UNRESOLVED_COLUMN = "TableReferenceResolver.UNRESOLVED_COLUMN";
    protected static final String ERROR_MESSAGE_KEY_UNRESOLVED_TABLE_NAME = "TableReferenceResolver.UNRESOLVED_TABLE";
    protected static final String ERROR_MESSAGE_KEY_NONEXISTENT_COLUMN = "TableReferenceResolver.TABLE_HAS_NO_SUCH_COLUMN";
    protected static final String ERROR_MESSAGE_KEY_AMBIGUOUS_COLUMN = "TableReferenceResolver.AMBIGUOUS_COLUMN";
    protected List stmtsColumnList = new ArrayList();
    protected IdentityHashMap parsedObjectsReplacementMap = new IdentityHashMap();
    protected Database database = null;
    protected String defaultSchemaName = null;
    protected boolean logDebug = false;
    protected boolean logError = true;

    private void logError(String methodName, String errorMsg) {
        if (this.logError) {
            SQLParserLogger.getLogger().writeLog(String.valueOf(this.getClass().getName()) + "#" + methodName + ": " + errorMsg);
        }
    }

    private void logInfo(String methodName, String errorMsg) {
        SQLParserLogger.getLogger().writeInfo(String.valueOf(this.getClass().getName()) + "#" + methodName + ": " + errorMsg);
    }

    public TableReferenceResolver() {
    }

    public TableReferenceResolver(boolean logError) {
        this();
        this.logError = logError;
    }

    public TableReferenceResolver(Database aDB, String aDefaultSchemaName) {
        this.database = aDB;
        this.defaultSchemaName = aDefaultSchemaName;
    }

    public TableReferenceResolver(Database aDB, String aDefaultSchemaName, boolean logError) {
        this(aDB, aDefaultSchemaName);
        this.logError = logError;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public void setDefaultSchemaName(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    public Class[] getProcessCandidateTypes() {
        return CANDIDATE_TYPES;
    }

    public void config(PostParseProcessorConfiguration config) {
        if (config != null) {
            this.database = config.getDatabase();
            this.defaultSchemaName = config.getDefaultSchemaName();
        }
    }

    public List process(SQLQueryObject sqlQuery) throws SQLParserException {
        ArrayList errorList = new ArrayList();
        if (sqlQuery == null) {
            return errorList;
        }
        if (sqlQuery instanceof ValueExpressionColumn) {
            ValueExpressionColumn columnExpr = (ValueExpressionColumn)sqlQuery;
            this.stmtsColumnList.add(columnExpr);
        } else if (sqlQuery instanceof TableInDatabase) {
            TableInDatabase tableInDB = (TableInDatabase)sqlQuery;
            errorList.addAll(this.resolveTableReference(tableInDB));
            if (this.parsedObjectsReplacementMap.containsKey(tableInDB)) {
                sqlQuery = (SQLQueryObject)this.parsedObjectsReplacementMap.get(tableInDB);
            }
        } else if (sqlQuery instanceof TableJoined) {
            TableJoined tableJoin = (TableJoined)sqlQuery;
            errorList.addAll(this.resolveTableReference(tableJoin));
        } else if (sqlQuery instanceof QuerySelect) {
            QuerySelect select = (QuerySelect)sqlQuery;
            errorList.addAll(this.resolveTableReferences(select));
        } else if (sqlQuery instanceof QuerySelectStatement) {
            QuerySelectStatement selectStmt = (QuerySelectStatement)sqlQuery;
            errorList.addAll(this.resolveTableReferences(selectStmt));
        } else if (sqlQuery instanceof QueryInsertStatement) {
            QueryInsertStatement insertStmt = (QueryInsertStatement)sqlQuery;
            errorList.addAll(this.resolveTableReferences(insertStmt));
        } else if (sqlQuery instanceof QueryUpdateStatement) {
            QueryUpdateStatement updateStmt = (QueryUpdateStatement)sqlQuery;
            errorList.addAll(this.resolveTableReferences(updateStmt));
        } else if (sqlQuery instanceof QueryDeleteStatement) {
            QueryDeleteStatement deleteStmt = (QueryDeleteStatement)sqlQuery;
            errorList.addAll(this.resolveTableReferences(deleteStmt));
        }
        if (sqlQuery instanceof TableExpression) {
            TableExpression tableExpr = (TableExpression)sqlQuery;
            if (tableExpr.getColumnList() == null || tableExpr.getColumnList().isEmpty()) {
                TableHelper.exposeEffectiveResultColumns((TableExpression)tableExpr);
            }
            errorList.addAll(this.checkForUnresolvedTable(tableExpr));
        } else if (sqlQuery instanceof QueryStatement) {
            this.checkForAmbiguousDefaultSchemas(sqlQuery);
            errorList.addAll(this.checkForUnloadedDatabaseSchemas());
            errorList.addAll(this.checkForUnresolvedColumns());
        }
        return errorList;
    }

    protected List checkForUnloadedDatabaseSchemas() {
        ArrayList<SQLParseErrorInfo> errorList = new ArrayList<SQLParseErrorInfo>();
        boolean foundSchemas = false;
        if (this.database != null) {
            EList schemaList = this.database.getSchemas();
            if (schemaList != null && schemaList.size() > 0) {
                foundSchemas = true;
            }
            EList catalogList = this.database.getCatalogs();
            if (!foundSchemas && catalogList != null) {
                Iterator catalogListIter = catalogList.iterator();
                while (catalogListIter.hasNext() && !foundSchemas) {
                    Catalog catalog = (Catalog)catalogListIter.next();
                    schemaList = catalog.getSchemas();
                    if (schemaList == null || schemaList.size() <= 0) continue;
                    foundSchemas = true;
                }
            }
            if (!foundSchemas) {
                errorList.add(0, new SQLParseErrorInfo(0, 0, 0, 0, null, null, SQLQueryParserMessages.getString(ERROR_MESSAGE_KEY_DATABASE_SCHEMAS_NOTLOADED, new String[]{this.database.getName()}), ERROR_CODE_DATABASE_SCHEMAS_NOTLOADED));
            }
        }
        return errorList;
    }

    protected void checkForAmbiguousDefaultSchemas(SQLQueryObject sqlQuery) {
        SQLQuerySourceFormat sourceFormat;
        String omitSchemaName;
        SQLQuerySourceInfo sourceInfo = sqlQuery.getSourceInfo();
        if (sourceInfo != null && sourceInfo.getSqlFormat() != null && this.defaultSchemaName != null && (omitSchemaName = (sourceFormat = sourceInfo.getSqlFormat()).getOmitSchema()) != null && omitSchemaName.length() > 0 && !omitSchemaName.equals(this.defaultSchemaName)) {
            this.logInfo("checkForAmbiguousDefaultSchemas(SQLQueryObject)", " default schema name given doesn't match default schema name given to parser: " + this.defaultSchemaName + " != " + omitSchemaName);
        }
    }

    public Map getParsedObjectsReplacementMap() {
        return this.parsedObjectsReplacementMap;
    }

    public void resetState() {
        this.parsedObjectsReplacementMap = new IdentityHashMap();
        this.stmtsColumnList.clear();
    }

    protected List resolveTableReference(TableInDatabase tableInDB) {
        ArrayList errorList = new ArrayList();
        WithTableReference withTable = this.resolveWithTableSpecificationForTableRef(tableInDB);
        if (withTable != null) {
            if (withTable.getColumnList() == null || withTable.getColumnList().isEmpty()) {
                TableHelper.exposeEffectiveResultColumns((WithTableReference)withTable);
            }
            this.parsedObjectsReplacementMap.put(tableInDB, withTable);
            SQLQuerySourceInfo sourceInfo = tableInDB.getSourceInfo();
            tableInDB.setSourceInfo(null);
            withTable.setSourceInfo(sourceInfo);
        } else if (this.database != null) {
            String aDefaultSchemaName = null;
            SQLQuerySourceInfo tdbsi = tableInDB.getSourceInfo();
            if (tdbsi != null && tdbsi.getSqlFormat() != null) {
                aDefaultSchemaName = tdbsi.getSqlFormat().getOmitSchema();
            }
            if (aDefaultSchemaName == null || aDefaultSchemaName.trim().length() == 0) {
                aDefaultSchemaName = this.defaultSchemaName;
            }
            this.resolveTableInDatabaseWithRDBTable(tableInDB, aDefaultSchemaName);
        }
        return errorList;
    }

    protected void resolveTableInDatabaseWithRDBTable(TableInDatabase tableInDB, String aDefaultSchemaName) {
        DatabaseHelper.resolveTableReferenceRDBTable((TableInDatabase)tableInDB, (Database)this.database, (String)aDefaultSchemaName);
    }

    private WithTableReference resolveWithTableSpecificationForTableRef(TableInDatabase tableInDB) {
        WithTableReference withTableRef = null;
        Table dbTable = tableInDB.getDatabaseTable();
        Schema schema = dbTable == null ? null : dbTable.getSchema();
        String schemaName = schema == null ? null : schema.getName();
        SQLQuerySourceInfo sourceInfo = tableInDB.getSourceInfo();
        SQLQuerySourceFormat sourceFormat = sourceInfo == null ? SQLQuerySourceFormat.SQL_SOURCE_FORMAT_DEFAULT : sourceInfo.getSqlFormat();
        String omitSchema = sourceFormat.getOmitSchema();
        char identDelimQt = sourceFormat.getDelimitedIdentifierQuote();
        String identDelimQtString = String.valueOf(identDelimQt);
        if (omitSchema != null && omitSchema.startsWith(identDelimQtString) && omitSchema.endsWith(identDelimQtString)) {
            omitSchema = StatementHelper.convertSQLIdentifierToCatalogFormat((String)omitSchema, (char)identDelimQt);
        }
        if (dbTable == null || schema == null || schemaName == null || schemaName.equals(omitSchema) || schemaName.equals(this.defaultSchemaName)) {
            withTableRef = StatementHelper.resolveWithTableSpecificationReference((TableExpression)tableInDB);
        }
        return withTableRef;
    }

    protected List resolveTableReference(TableJoined tableJoin) {
        ArrayList errorList = new ArrayList();
        ArrayList<TableReference> tableRefList = new ArrayList<TableReference>();
        tableRefList.add(tableJoin.getTableRefLeft());
        tableRefList.add(tableJoin.getTableRefRight());
        Set columnExprSet = TableHelper.findColumnReferencesInSearchCondition((QuerySearchCondition)tableJoin.getJoinCondition());
        this.resolveColumnTableReferences(columnExprSet, tableRefList);
        return errorList;
    }

    protected List resolveTableReferences(QuerySelect select) {
        ArrayList errorList = new ArrayList();
        Set columnSet = TableHelper.findColumnReferencesInQueryExpressionBody((QueryExpressionBody)select);
        columnSet.addAll(this.findUnresolvedColumnReferencesInScope((SQLQueryObject)select));
        List visibleTableList = StatementHelper.getTableExpressionsVisibleInQuerySelect((QuerySelect)select);
        this.resolveColumnTableReferences(columnSet, visibleTableList);
        StatementHelper.resolveResultTableAllColumns((QuerySelect)select);
        return errorList;
    }

    protected void resolveColumnTableReferences(Collection columns, List tableRefs) {
        TableHelper.resolveColumnTableReferences((Collection)columns, (List)tableRefs);
    }

    private List findUnresolvedColumnReferencesInScope(SQLQueryObject scope) {
        ArrayList<ValueExpressionColumn> unresolvedColumnsInScope = new ArrayList<ValueExpressionColumn>();
        int scopeSpanBegin = scope.getSourceInfo().getSpanStartOffset();
        int scopeSpanEnd = scope.getSourceInfo().getSpanEndOffset();
        if (scopeSpanBegin == 0 && scopeSpanEnd == 0) {
            return unresolvedColumnsInScope;
        }
        for (ValueExpressionColumn column : this.stmtsColumnList) {
            int columnSpanBegin = column.getSourceInfo().getSpanStartOffset();
            int columnSpanEnd = column.getSourceInfo().getSpanEndOffset();
            if (this.checkForUnresolvedColumn(column).isEmpty() || columnSpanBegin < scopeSpanBegin || columnSpanEnd > scopeSpanEnd) continue;
            unresolvedColumnsInScope.add(column);
        }
        return unresolvedColumnsInScope;
    }

    protected List resolveTableReferences(QuerySelectStatement selectStmt) {
        ArrayList errorList = new ArrayList();
        Set removedColumns = null;
        removedColumns = StatementHelper.resolveOrderByColumns((QueryExpressionBody)selectStmt.getQueryExpr().getQuery(), (List)selectStmt.getOrderByClause());
        this.stmtsColumnList.removeAll(removedColumns);
        Iterator removeIt = removedColumns.iterator();
        while (removeIt.hasNext()) {
            this.parsedObjectsReplacementMap.put(removeIt.next(), null);
        }
        List tableRefList = StatementHelper.getTablesForStatement((QueryStatement)selectStmt);
        Set columnExprSet = TableHelper.findColumnReferencesInQuerySelectStatement((QuerySelectStatement)selectStmt);
        this.resolveColumnTableReferences(columnExprSet, tableRefList);
        QueryExpressionBody queryExpr = selectStmt.getQueryExpr().getQuery();
        if (queryExpr.getColumnList() == null || queryExpr.getColumnList().isEmpty()) {
            TableHelper.exposeEffectiveResultColumns((QueryExpressionBody)queryExpr);
        }
        return errorList;
    }

    protected List resolveTableReferences(QueryInsertStatement insertStmt) {
        ArrayList errorList = new ArrayList();
        ArrayList<TableInDatabase> tableRefList = new ArrayList<TableInDatabase>();
        tableRefList.add(insertStmt.getTargetTable());
        ArrayList columnList = new ArrayList(insertStmt.getTargetColumnList());
        this.resolveColumnTableReferences(columnList, tableRefList);
        return errorList;
    }

    protected List resolveTableReferences(QueryUpdateStatement updateStmt) {
        ArrayList errorList = new ArrayList();
        ArrayList<TableInDatabase> tableRefList = new ArrayList<TableInDatabase>();
        tableRefList.add(updateStmt.getTargetTable());
        Set columnSet = TableHelper.findColumnReferencesInQueryUpdateStatement((QueryUpdateStatement)updateStmt);
        this.resolveColumnTableReferences(columnSet, tableRefList);
        return errorList;
    }

    protected List resolveTableReferences(QueryDeleteStatement deleteStmt) {
        ArrayList errorList = new ArrayList();
        ArrayList<TableInDatabase> tableRefList = new ArrayList<TableInDatabase>();
        tableRefList.add(deleteStmt.getTargetTable());
        Set columnExprs = TableHelper.findColumnReferencesInSearchCondition((QuerySearchCondition)deleteStmt.getWhereClause());
        this.resolveColumnTableReferences(columnExprs, tableRefList);
        return errorList;
    }

    protected List checkForUnresolvedTable(TableExpression tableExpr) {
        ArrayList<SQLParseErrorInfo> errorList = new ArrayList<SQLParseErrorInfo>();
        boolean isQuery = tableExpr instanceof QueryExpressionBody;
        boolean isFromTable = tableExpr.getQuerySelect() != null;
        boolean hasColumns = tableExpr.getColumnList() != null && !tableExpr.getColumnList().isEmpty();
        boolean isTableFunction = tableExpr instanceof TableFunction;
        if (!(this.database == null || this.database.getSchemas().isEmpty() || isQuery && !isFromTable || hasColumns || isTableFunction)) {
            SQLQuerySourceInfo sourceInfo = tableExpr.getSourceInfo();
            String errorMsg = SQLQueryParserMessages.getString(ERROR_MESSAGE_KEY_UNRESOLVED_TABLE_NAME, new String[]{sourceInfo.getSourceSnippet()});
            errorList.add(new SQLParseErrorInfo(sourceInfo, null, errorMsg, ERROR_CODE_TABLE_UNRESOLVED));
        }
        return errorList;
    }

    protected List checkForUnresolvedColumns() {
        ArrayList errorList = new ArrayList();
        for (ValueExpressionColumn colExpr : this.stmtsColumnList) {
            errorList.addAll(this.checkForUnresolvedColumn(colExpr));
        }
        return errorList;
    }

    protected List checkForUnresolvedColumn(ValueExpressionColumn colExpr) {
        ArrayList<SQLParseErrorInfo> errorList = new ArrayList<SQLParseErrorInfo>();
        TableExpression colTable = colExpr.getTableExpr();
        if (colTable == null) {
            if (StatementHelper.isColumnNameAmbiguous((ValueExpressionColumn)colExpr)) {
                errorList.add(new SQLParseErrorInfo(colExpr.getSourceInfo(), "<table_name_or_alias>." + colExpr.getName(), SQLQueryParserMessages.getString(ERROR_MESSAGE_KEY_AMBIGUOUS_COLUMN, new String[]{colExpr.getName()}), ERROR_CODE_COLUMN_AMBIGUOUS));
            } else {
                errorList.add(new SQLParseErrorInfo(colExpr.getSourceInfo(), "<table_name_or_alias>." + colExpr.getName(), SQLQueryParserMessages.getString(ERROR_MESSAGE_KEY_UNRESOLVED_COLUMN, new String[]{colExpr.getName()}), ERROR_CODE_COLUMN_UNRESOLVED));
            }
        } else if (colTable.eContainer() == null) {
            errorList.add(new SQLParseErrorInfo(colExpr.getSourceInfo(), "<table_name_or_alias>." + colExpr.getName(), SQLQueryParserMessages.getString(ERROR_MESSAGE_KEY_UNRESOLVED_TABLE_NAME, new String[]{colTable.getName()}), ERROR_CODE_TABLE_UNRESOLVED));
        } else if (!colTable.getColumnList().isEmpty() && !this.isColumnInTable(colTable, colExpr)) {
            errorList.add(new SQLParseErrorInfo(colExpr.getSourceInfo(), "<table_name_or_alias>.<column_name>", SQLQueryParserMessages.getString(ERROR_MESSAGE_KEY_NONEXISTENT_COLUMN, new String[]{colTable.getName(), colExpr.getName()}), ERROR_CODE_NONEXISTENT_COLUMN));
        }
        return errorList;
    }

    private boolean isColumnInTable(TableExpression tableExpr, ValueExpressionColumn colExpr) {
        String colExprName;
        ValueExpressionColumn resolvedCol;
        boolean hasTableColumn = false;
        if (tableExpr != null && colExpr != null && (resolvedCol = TableHelper.getColumnExpressionForName((TableExpression)tableExpr, (String)(colExprName = colExpr.getName()))) != null) {
            hasTableColumn = true;
        }
        return hasTableColumn;
    }

    protected void printErrorList(List errorList) {
        if (errorList == null || errorList.isEmpty()) {
            return;
        }
        SQLParserLogger.getLogger().writeInfo("Errors encountered by " + this.getClass().getName() + ":");
        for (SQLParseErrorInfo errorInfo : errorList) {
            String expected = errorInfo.getExpectedText() != null ? ", expected: \"" + errorInfo.getExpectedText() + "\"" : "";
            SQLParserLogger.getLogger().writeInfo(String.valueOf(errorInfo.getParserErrorMessage()) + " at line:column " + errorInfo.getLineNumberStart() + ":" + errorInfo.getColumnNumberStart() + " to line:column " + errorInfo.getLineNumberEnd() + ":" + errorInfo.getColumnNumberEnd() + " \"" + errorInfo.getErrorSourceText() + "\"" + expected);
        }
    }
}

