/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dnd.internal;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.Alerts;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dnd.LocalDropRequest;
import org.eclipse.jst.pagedesigner.dnd.internal.LocalDropEditPolicy;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class LocalSelectionDropTargetListener
extends AbstractTransferDropTargetListener {
    public LocalSelectionDropTargetListener(EditPartViewer viewer) {
        super(viewer, (Transfer)LocalSelectionTransfer.getInstance());
    }

    protected Request createTargetRequest() {
        LocalDropRequest request = new LocalDropRequest();
        request.setLocation(this.getDropLocation());
        request.setLocalObject(this.getCurrentLocalObject());
        return request;
    }

    private Object getCurrentLocalObject() {
        ISelection sel = LocalSelectionTransfer.getInstance().getSelection();
        if (sel instanceof IStructuredSelection) {
            return ((IStructuredSelection)sel).getFirstElement();
        }
        return null;
    }

    protected void updateTargetRequest() {
        LocalDropRequest dropRequest = (LocalDropRequest)this.getTargetRequest();
        dropRequest.setLocation(this.getDropLocation());
        dropRequest.setLocalObject(this.getCurrentLocalObject());
    }

    public void setCurrentEvent(DropTargetEvent currentEvent) {
        super.setCurrentEvent(currentEvent);
        if (currentEvent != null && currentEvent.detail != 0) {
            currentEvent.detail = 1;
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if ((event.detail & 1) != 0) {
            LocalDropEditPolicy.setCheckUpdate(false);
        } else {
            LocalDropEditPolicy.setCheckUpdate(true);
        }
        super.dragOperationChanged(event);
    }

    public void drop(DropTargetEvent event) {
        Path filePath;
        String path = ((IHTMLGraphicalViewer)this.getViewer()).getModel().getBaseLocation();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        if (root.getFile((IPath)(filePath = new Path(path))).exists()) {
            this.getViewer().getControl().setFocus();
            super.drop(event);
            LocalDropEditPolicy.setCheckUpdate(true);
        } else {
            Alerts alert = PDPlugin.getAlerts();
            alert.info("LocalSelectionDropTargetListener.MessageDialog.Title", "LocalSelectionDropTargetListener.MessageDialog.Message");
        }
    }
}

