/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.core.internal.context.orm;

import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.eclipselink.core.context.Customizer;
import org.eclipse.jpt.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlCustomizer;
import org.eclipse.jpt.eclipselink.core.resource.orm.XmlCustomizerHolder;

public class EclipseLinkOrmCustomizer
extends AbstractXmlContextNode
implements Customizer {
    protected final XmlCustomizerHolder resource;
    protected String specifiedCustomizerClass;
    protected String defaultCustomizerClass;

    public EclipseLinkOrmCustomizer(OrmTypeMapping parent, XmlCustomizerHolder resource, Customizer javaCustomizer) {
        super((JpaContextNode)parent);
        this.resource = resource;
        this.defaultCustomizerClass = this.getJavaCustomizerClass(javaCustomizer);
        this.specifiedCustomizerClass = this.getResourceCustomizerClass();
    }

    public char getCustomizerClassEnclosingTypeSeparator() {
        return '$';
    }

    public String getCustomizerClass() {
        return this.specifiedCustomizerClass == null ? this.defaultCustomizerClass : this.specifiedCustomizerClass;
    }

    public String getDefaultCustomizerClass() {
        return this.defaultCustomizerClass;
    }

    protected void setDefaultCustomizerClass(String newDefaultCustomizerClass) {
        String oldDefaultCustomizerClass = this.defaultCustomizerClass;
        this.defaultCustomizerClass = newDefaultCustomizerClass;
        this.firePropertyChanged("defaultCustomizerClass", oldDefaultCustomizerClass, newDefaultCustomizerClass);
    }

    public String getSpecifiedCustomizerClass() {
        return this.specifiedCustomizerClass;
    }

    public void setSpecifiedCustomizerClass(String newCustomizerClass) {
        String oldCustomizerClass = this.specifiedCustomizerClass;
        this.specifiedCustomizerClass = newCustomizerClass;
        if (oldCustomizerClass != newCustomizerClass) {
            if (this.getResourceCustomizer() != null) {
                this.getResourceCustomizer().setCustomizerClassName(newCustomizerClass);
                if (this.getResourceCustomizer().isUnset()) {
                    this.removeResourceCustomizer();
                }
            } else if (newCustomizerClass != null) {
                this.addResourceCustomizer();
                this.getResourceCustomizer().setCustomizerClassName(newCustomizerClass);
            }
        }
        this.firePropertyChanged("specifiedCustomizerClass", oldCustomizerClass, newCustomizerClass);
    }

    protected void setSpecifiedCustomizerClass_(String newCustomizerClass) {
        String oldCustomizerClass = this.specifiedCustomizerClass;
        this.specifiedCustomizerClass = newCustomizerClass;
        this.firePropertyChanged("specifiedCustomizerClass", oldCustomizerClass, newCustomizerClass);
    }

    protected XmlCustomizer getResourceCustomizer() {
        return this.resource.getCustomizer();
    }

    protected void addResourceCustomizer() {
        this.resource.setCustomizer(EclipseLinkOrmFactory.eINSTANCE.createXmlCustomizer());
    }

    protected void removeResourceCustomizer() {
        this.resource.setCustomizer(null);
    }

    protected void update(Customizer javaCustomizer) {
        this.setDefaultCustomizerClass(this.getJavaCustomizerClass(javaCustomizer));
        this.setSpecifiedCustomizerClass_(this.getResourceCustomizerClass());
    }

    protected String getJavaCustomizerClass(Customizer javaCustomizer) {
        return javaCustomizer == null ? null : javaCustomizer.getCustomizerClass();
    }

    protected String getResourceCustomizerClass() {
        XmlCustomizer resource = this.getResourceCustomizer();
        return resource == null ? null : resource.getCustomizerClassName();
    }

    public TextRange getValidationTextRange() {
        XmlCustomizer resource = this.getResourceCustomizer();
        return resource == null ? null : resource.getCustomizerClassNameTextRange();
    }
}

