/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.UIContextDetermination;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.IEditModelHandler;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.UnresolveableURIException;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentType;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.componentcore.internal.ModuleStructuralModel;
import org.eclipse.wst.common.componentcore.internal.ProjectComponents;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.internal.util.EclipseResourceAdapter;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.internal.emf.utilities.ExtendedEcoreUtil;
import org.eclipse.wst.common.internal.emfworkbench.edit.EMFWorkbenchEditContextFactory;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;
import org.eclipse.wst.common.internal.emfworkbench.validateedit.IValidateEditContext;

public class StructureEdit
implements IEditModelHandler {
    public static final Class ADAPTER_TYPE = StructureEdit.class;
    public static String MODULE_META_FILE_NAME = ".settings/org.eclipse.wst.common.component";
    private static final ComponentcoreFactory COMPONENT_FACTORY = ComponentcoreFactory.eINSTANCE;
    private static final ComponentResource[] NO_RESOURCES = new ComponentResource[0];
    private final ModuleStructuralModel structuralModel;
    private final Map dependentCores = new HashMap();
    private IProject aProject;
    private boolean isStructuralModelSelfManaged;
    private boolean isReadOnly;
    private static final WorkbenchComponent[] NO_COMPONENTS = new WorkbenchComponent[0];

    public static StructureEdit getStructureEditForRead(IProject aProject) {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(aProject);
        return nature != null ? new StructureEdit(nature, true) : null;
    }

    public static StructureEdit getStructureEditForWrite(IProject aProject) {
        ModuleCoreNature nature = ModuleCoreNature.getModuleCoreNature(aProject);
        return nature != null ? new StructureEdit(nature, false) : null;
    }

    public static ModuleCoreNature getModuleCoreNature(URI aModuleURI) throws UnresolveableURIException {
        IProject container = StructureEdit.getContainingProject(aModuleURI);
        if (container != null) {
            return ModuleCoreNature.getModuleCoreNature(container);
        }
        return null;
    }

    public static IProject getContainingProject(WorkbenchComponent aComponent) {
        IProject project = ProjectUtilities.getProject((EObject)aComponent);
        if (project != null && project.isAccessible()) {
            return project;
        }
        return null;
    }

    public static IProject getContainingProject(URI aModuleURI) throws UnresolveableURIException {
        ModuleURIUtil.ensureValidFullyQualifiedModuleURI(aModuleURI);
        String projectName = aModuleURI.segment(1);
        if (projectName == null || projectName.length() == 0) {
            throw new UnresolveableURIException(aModuleURI);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.isAccessible()) {
            return project;
        }
        return null;
    }

    public static IResource getEclipseResource(ComponentResource aModuleResource) {
        EclipseResourceAdapter eclipseResourceAdapter = (EclipseResourceAdapter)ExtendedEcoreUtil.getAdapter((EObject)aModuleResource, (List)aModuleResource.eAdapters(), (Object)EclipseResourceAdapter.ADAPTER_TYPE);
        if (eclipseResourceAdapter != null) {
            return eclipseResourceAdapter.getEclipseResource();
        }
        eclipseResourceAdapter = new EclipseResourceAdapter();
        aModuleResource.eAdapters().add((Object)eclipseResourceAdapter);
        return eclipseResourceAdapter.getEclipseResource();
    }

    public static String getDeployedName(URI aFullyQualifiedModuleURI) throws UnresolveableURIException {
        return ModuleURIUtil.getDeployedName(aFullyQualifiedModuleURI);
    }

    public static ComponentType getComponentType(IVirtualComponent aComponent) {
        StructureEdit componentCore = null;
        ComponentType componentType = null;
        try {
            componentCore = StructureEdit.getStructureEditForRead(aComponent.getProject());
            WorkbenchComponent wbComponent = componentCore.getComponent();
            componentType = wbComponent.getComponentType();
        }
        finally {
            if (componentCore != null) {
                componentCore.dispose();
            }
        }
        return componentType;
    }

    public static IVirtualReference createVirtualReference(IVirtualComponent context, ReferencedComponent referencedComponent) {
        IVirtualComponent targetComponent = null;
        IProject targetProject = null;
        URI uri = referencedComponent.getHandle();
        if (uri == null) {
            return null;
        }
        boolean isClassPathURI = ModuleURIUtil.isClassPathURI(uri);
        if (!isClassPathURI) {
            try {
                targetProject = StructureEdit.getContainingProject(uri);
            }
            catch (UnresolveableURIException unresolveableURIException) {}
            targetComponent = ComponentCore.createComponent(targetProject);
        } else {
            String archiveType = "";
            String archiveName = "";
            try {
                archiveType = ModuleURIUtil.getArchiveType(uri);
                archiveName = ModuleURIUtil.getArchiveName(uri);
            }
            catch (UnresolveableURIException unresolveableURIException) {}
            targetComponent = ComponentCore.createArchiveComponent(context.getProject(), String.valueOf(archiveType) + '/' + archiveName);
        }
        return new VirtualReference(context, targetComponent, referencedComponent.getRuntimePath(), referencedComponent.getDependencyType().getValue());
    }

    protected StructureEdit(ModuleCoreNature aNature, boolean toAccessAsReadOnly) {
        this.structuralModel = toAccessAsReadOnly ? aNature.getModuleStructuralModelForRead(this) : aNature.getModuleStructuralModelForWrite(this);
        this.aProject = aNature.getProject();
        this.isReadOnly = toAccessAsReadOnly;
        this.isStructuralModelSelfManaged = true;
    }

    public StructureEdit(ModuleStructuralModel aStructuralModel) {
        this.structuralModel = aStructuralModel;
        this.aProject = aStructuralModel.getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(IProgressMonitor aMonitor) {
        if (this.isReadOnly) {
            this.throwAttemptedReadOnlyModification();
        } else if (this.validateEdit().isOK()) {
            ModuleStructuralModel moduleStructuralModel = this.structuralModel;
            synchronized (moduleStructuralModel) {
                if (!this.structuralModel.isDisposed()) {
                    this.structuralModel.save(aMonitor, this);
                }
            }
        }
    }

    public void saveIfNecessary(IProgressMonitor aMonitor) {
        if (this.isReadOnly) {
            this.throwAttemptedReadOnlyModification();
        } else if (this.validateEdit().isOK() && !this.structuralModel.isDisposed()) {
            this.structuralModel.saveIfNecessary(aMonitor, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object;
        if (this.isStructuralModelSelfManaged && this.structuralModel != null) {
            object = this.structuralModel;
            synchronized (object) {
                if (!this.structuralModel.isDisposed()) {
                    this.structuralModel.releaseAccess(this);
                }
            }
        }
        if (this.dependentCores != null && this.dependentCores.size() > 0) {
            object = this.dependentCores;
            synchronized (object) {
                for (StructureEdit core : this.dependentCores.values()) {
                    if (core == null) continue;
                    core.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareProjectComponentsIfNecessary() {
        ModuleStructuralModel moduleStructuralModel = this.structuralModel;
        synchronized (moduleStructuralModel) {
            if (!this.structuralModel.isDisposed()) {
                try {
                    this.structuralModel.prepareProjectModulesIfNecessary();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectComponents getComponentModelRoot() {
        IFile file = this.structuralModel.getComponentFile();
        if (!file.isSynchronized(1)) {
            try {
                File iofile = file.getFullPath().toFile();
                if (iofile.exists() || file.exists()) {
                    file.refreshLocal(1, null);
                }
            }
            catch (CoreException coreException) {}
        }
        ProjectComponents comps = null;
        ILock lock = EMFWorkbenchEditContextFactory.getProjectLockObject((IProject)this.structuralModel.getProject());
        try {
            if (lock != null) {
                lock.acquire();
            }
            ModuleStructuralModel moduleStructuralModel = this.structuralModel;
            synchronized (moduleStructuralModel) {
                if (!this.structuralModel.isDisposed()) {
                    comps = (ProjectComponents)this.structuralModel.getPrimaryRootObject();
                }
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
        return comps;
    }

    public ComponentResource[] getSourceContainers(WorkbenchComponent component) {
        return null;
    }

    public WorkbenchComponent[] getWorkbenchModules() {
        ProjectComponents pc = this.getComponentModelRoot();
        if (pc != null) {
            EList wbModules = pc.getComponents();
            return wbModules.toArray(new WorkbenchComponent[wbModules.size()]);
        }
        return NO_COMPONENTS;
    }

    public WorkbenchComponent createWorkbenchModule(String aDeployName) {
        if (this.isReadOnly) {
            this.throwAttemptedReadOnlyModification();
        }
        WorkbenchComponent module = COMPONENT_FACTORY.createWorkbenchComponent();
        module.setName(aDeployName);
        this.getComponentModelRoot().getComponents().add((Object)module);
        return module;
    }

    public ComponentResource createWorkbenchModuleResource(IResource aResource) {
        if (this.isReadOnly) {
            this.throwAttemptedReadOnlyModification();
        }
        ComponentResource moduleResource = COMPONENT_FACTORY.createComponentResource();
        moduleResource.setSourcePath(aResource.getProjectRelativePath().makeAbsolute());
        return moduleResource;
    }

    public ComponentType createModuleType(String aModuleTypeId) {
        if (this.isReadOnly) {
            this.throwAttemptedReadOnlyModification();
        }
        ComponentType moduleType = COMPONENT_FACTORY.createComponentType();
        moduleType.setComponentTypeId(aModuleTypeId);
        return moduleType;
    }

    public ComponentResource[] findResourcesByRuntimePath(URI aModuleURI, URI aDeployedResourcePath) throws UnresolveableURIException {
        WorkbenchComponent module = this.getComponent();
        return module.findResourcesByRuntimePath((IPath)new Path(aDeployedResourcePath.path()));
    }

    public ComponentResource[] findResourcesByRuntimePath(URI aModuleResourcePath) throws UnresolveableURIException {
        URI deployedURI = ModuleURIUtil.trimToDeployPathSegment(aModuleResourcePath);
        Path deployedPath = new Path(deployedURI.path());
        return this.findResourcesByRuntimePath(ModuleURIUtil.getDeployedName(aModuleResourcePath), (IPath)deployedPath);
    }

    public ComponentResource[] findResourcesByRuntimePath(String aModuleName, IPath aModuleResourcePath) {
        WorkbenchComponent module = this.getComponent();
        return module.findResourcesByRuntimePath(aModuleResourcePath);
    }

    public ComponentResource[] findResourcesBySourcePath(URI aWorkspaceRelativePath) throws UnresolveableURIException {
        return this.findResourcesBySourcePath(aWorkspaceRelativePath, 0);
    }

    public ComponentResource[] findResourcesBySourcePath(URI aWorkspaceRelativePath, int resourceFlag) throws UnresolveableURIException {
        return this.findResourcesBySourcePath((IPath)new Path(aWorkspaceRelativePath.path()), resourceFlag);
    }

    public ComponentResource[] findResourcesBySourcePath(IPath aProjectRelativePath) throws UnresolveableURIException {
        return this.findResourcesBySourcePath(aProjectRelativePath, 0);
    }

    public WorkbenchComponent findComponent(IPath aProjectRelativeResourcePath, int resourceFlag) throws UnresolveableURIException {
        ProjectComponents projectModules = this.getComponentModelRoot();
        if (projectModules == null) {
            return null;
        }
        EList modules = projectModules.getComponents();
        WorkbenchComponent module = null;
        boolean resourceExists = false;
        int i = 0;
        while (i < modules.size()) {
            module = (WorkbenchComponent)modules.get(i);
            resourceExists = module.exists(aProjectRelativeResourcePath, resourceFlag);
            if (!resourceExists && aProjectRelativeResourcePath.segments().length > 1) {
                resourceExists = module.exists(aProjectRelativeResourcePath.removeFirstSegments(1), resourceFlag);
            }
            if (resourceExists) {
                return module;
            }
            ++i;
        }
        return null;
    }

    public ComponentResource[] findResourcesBySourcePath(IPath aProjectRelativePath, int resourceFlag) throws UnresolveableURIException {
        ProjectComponents projectModules = this.getComponentModelRoot();
        if (projectModules == null) {
            return NO_RESOURCES;
        }
        EList modules = projectModules.getComponents();
        WorkbenchComponent module = null;
        ComponentResource[] resources = null;
        ArrayList<ComponentResource> foundResources = new ArrayList<ComponentResource>();
        int i = 0;
        while (i < modules.size()) {
            module = (WorkbenchComponent)modules.get(i);
            resources = module.findResourcesBySourcePath(aProjectRelativePath, resourceFlag);
            if (resources != null && resources.length != 0) {
                foundResources.addAll(Arrays.asList(resources));
            } else if (aProjectRelativePath.segments().length > 1 && (resources = module.findResourcesBySourcePath(aProjectRelativePath.removeFirstSegments(1), resourceFlag)) != null && resources.length != 0) {
                foundResources.addAll(Arrays.asList(resources));
            }
            ++i;
        }
        if (foundResources.size() > 0) {
            return foundResources.toArray(new ComponentResource[foundResources.size()]);
        }
        return NO_RESOURCES;
    }

    public WorkbenchComponent findComponentByName(String aModuleName) {
        return this.getComponentModelRoot() != null ? this.getComponentModelRoot().findWorkbenchModule(aModuleName) : null;
    }

    public WorkbenchComponent findComponentByURI(URI aModuleURI) throws UnresolveableURIException {
        if (aModuleURI == null) {
            return null;
        }
        if (aModuleURI.scheme() == null && aModuleURI.segmentCount() == 1) {
            return this.getComponent();
        }
        ModuleURIUtil.ensureValidFullyQualifiedModuleURI(aModuleURI);
        String projectName = aModuleURI.segment(1);
        if (this.getProject() != null && this.getProject().getName().equals(projectName)) {
            return this.getComponent();
        }
        StructureEdit dependentCore = this.getDependentModuleCore(aModuleURI);
        if (dependentCore != null) {
            return dependentCore.getComponent();
        }
        return null;
    }

    public ReferencedComponent findReferencedComponent(WorkbenchComponent aComponent, WorkbenchComponent aReferencedComponent) {
        if (aComponent == null || aReferencedComponent == null) {
            return null;
        }
        IProject referencedProject = StructureEdit.getContainingProject(aReferencedComponent);
        EList referencedComponents = aComponent.getReferencedComponents();
        String dependentProjectName = null;
        for (ReferencedComponent referencedComponent : referencedComponents) {
            dependentProjectName = referencedComponent.getHandle().segment(1);
            if (!referencedProject.getName().equals(dependentProjectName)) continue;
            return referencedComponent;
        }
        return null;
    }

    public boolean isLocalDependency(ReferencedComponent aDependentModule) {
        if (aDependentModule == null || aDependentModule.getHandle() == null) {
            return false;
        }
        URI dependentHandle = aDependentModule.getHandle();
        if (dependentHandle.scheme() == null && dependentHandle.segmentCount() == 1) {
            return true;
        }
        try {
            String localProjectName = this.getProject().getName();
            if (ModuleURIUtil.ensureValidFullyQualifiedModuleURI(dependentHandle, false)) {
                String dependentProjectName = aDependentModule.getHandle().segment(1);
                return localProjectName.equals(dependentProjectName);
            }
        }
        catch (UnresolveableURIException unresolveableURIException) {}
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StructureEdit getDependentModuleCore(URI aModuleURI) throws UnresolveableURIException {
        StructureEdit dependentCore = (StructureEdit)this.dependentCores.get(aModuleURI);
        if (dependentCore != null) {
            return dependentCore;
        }
        Map map = this.dependentCores;
        synchronized (map) {
            dependentCore = (StructureEdit)this.dependentCores.get(aModuleURI);
            if (dependentCore == null) {
                IProject container = StructureEdit.getContainingProject(aModuleURI);
                if (container != null) {
                    dependentCore = StructureEdit.getStructureEditForRead(container);
                    this.dependentCores.put(aModuleURI, dependentCore);
                } else {
                    throw new UnresolveableURIException(aModuleURI);
                }
            }
        }
        return dependentCore;
    }

    private void throwAttemptedReadOnlyModification() {
        throw new IllegalStateException("Attempt to modify a ModuleCore edit facade that was loaded as read-only.");
    }

    public WorkbenchComponent getFirstModule() {
        return this.getComponent();
    }

    public WorkbenchComponent getComponent() {
        WorkbenchComponent[] comps = this.getWorkbenchModules();
        if (comps.length > 0) {
            return comps[0];
        }
        return null;
    }

    public static URI createComponentURI(IProject aContainingProject, String aComponentName) {
        return URI.createURI((String)("module:/resource" + aContainingProject.getName() + '/' + aComponentName));
    }

    protected IProject getProject() {
        return this.aProject;
    }

    public ModuleStructuralModel getModuleStructuralModel() {
        return this.structuralModel;
    }

    protected IStatus validateEdit() {
        IValidateEditContext validator = (IValidateEditContext)UIContextDetermination.createInstance((String)"ValidateEditContext");
        return validator.validateState((EditModel)this.getModuleStructuralModel());
    }
}

