/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.dialogs;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.details.AttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.MappingUiProvider;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPersistentAttributeToXmlAndMapDialog
extends StatusDialog {
    private OrmPersistentAttribute unmappedPersistentAttribute;
    private Text attributeText;
    private ComboViewer mappingCombo;

    public AddPersistentAttributeToXmlAndMapDialog(Shell parentShell, OrmPersistentAttribute unmappedPersistentAttribute) {
        super(parentShell);
        this.unmappedPersistentAttribute = unmappedPersistentAttribute;
        this.setTitle(JptUiMessages.AddPersistentAttributeDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.createLabel(composite, 1, JptUiMessages.AddPersistentAttributeDialog_attributeLabel);
        this.attributeText = this.createText(composite, 1);
        this.attributeText.setText(this.unmappedPersistentAttribute.getName());
        this.attributeText.setEditable(false);
        this.createLabel(composite, 1, JptUiMessages.AddPersistentClassDialog_mappingLabel);
        this.mappingCombo = new ComboViewer(this.createCombo(composite, 1));
        this.mappingCombo.getCombo().setFocus();
        this.mappingCombo.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return CollectionTools.array((Iterator)CollectionTools.sort(((JpaPlatformUi)inputElement).attributeMappingUiProviders(AddPersistentAttributeToXmlAndMapDialog.this.unmappedPersistentAttribute.getContentType()), AddPersistentAttributeToXmlAndMapDialog.this.getProvidersComparator()));
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.mappingCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((AttributeMappingUiProvider)element).getLabel();
            }
        });
        this.mappingCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddPersistentAttributeToXmlAndMapDialog.this.validate();
            }
        });
        JpaPlatformUi jpaPlatformUi = JptUiPlugin.instance().getJpaPlatformUi(this.unmappedPersistentAttribute.getJpaProject().getJpaPlatform());
        this.mappingCombo.setInput((Object)jpaPlatformUi);
        this.mappingCombo.getCombo().select(0);
        AddPersistentAttributeToXmlAndMapDialog.applyDialogFont((Control)dialogArea);
        this.validate();
        return dialogArea;
    }

    protected Comparator<MappingUiProvider<?>> getProvidersComparator() {
        return new Comparator<MappingUiProvider<?>>(){

            @Override
            public int compare(MappingUiProvider<?> item1, MappingUiProvider<?> item2) {
                String displayString1 = item1.getLabel();
                String displayString2 = item2.getLabel();
                return Collator.getInstance().compare(displayString1, displayString2);
            }
        };
    }

    private Label createLabel(Composite container, int span, String text) {
        Label label = new Label(container, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        label.setLayoutData((Object)gd);
        return label;
    }

    private Text createText(Composite container, int span) {
        Text text = new Text(container, 2052);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = 250;
        text.setLayoutData((Object)gd);
        return text;
    }

    private Combo createCombo(Composite container, int span) {
        Combo combo = new Combo(container, 2060);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    public String getAttributeName() {
        return this.attributeText.getText();
    }

    public String getMappingKey() {
        StructuredSelection selection = (StructuredSelection)this.mappingCombo.getSelection();
        return selection.isEmpty() ? null : ((AttributeMappingUiProvider)selection.getFirstElement()).getKey();
    }

    private void validate() {
        String mappingKey = this.getMappingKey();
        if (mappingKey == null) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.jpt.ui", JptUiMessages.AddPersistentAttributeDialog_noMappingKeyError));
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    protected void okPressed() {
        this.unmappedPersistentAttribute.makeSpecified(this.getMappingKey());
        super.okPressed();
    }
}

