/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.xml.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.util.string.CharBuffer;
import org.eclipse.equinox.internal.util.xml.ExTagListener;
import org.eclipse.equinox.internal.util.xml.impl.TagImpl;

public class XMLParserImpl {
    private static final String DEBUG = "xml.debug";
    private static final String INTERN_ATTRIBUTES = "xml.intern.attributes";
    private static final String CDATA = "CDATA";
    private static final String XML = "xml";
    private static final String VERSION = "version";
    private static final String ENCODING = "encoding";
    private static final String STANDALONE = "standalone";
    private static final String ERR_EOS = "End-of-stream reached before the end of XML.";
    private static final String ERR_ENTITY_EXPECTED = "Entity reference or Character reference expected.";
    private static final String ERR_EQUAL_EXPECTED = "'=' expected.";
    private static final String ERR_QUOT_EXPECTED = "''' or '\"' expected.";
    private static final String ERR_GT_EXPECTED = "'>' expected.";
    private static final String ERR_LT_EXPECTED = "'<' expected.";
    private static final String ERR_CLOSE_TAG1_EXPECTED = "'/' or tag name expected.";
    private static final String ERR_CLOSE_TAG2_EXPECTED = "'>', '/>' or more attributes expected.";
    private static final String ERR_CLOSE_TAG3_EXPECTED = "'?>' expected.";
    private static final String ERR_CONTENT_EXPECTED = "Content data, new tag or closing tag expected.";
    private static final String ERR_QUESTIONMARK_EXPECTED = "'?' expected.";
    private static final String ERR_ILLEGAL_CHARACTER = "Illegal character.";
    private static final String ERR_TAGNAME_EXPECTED = "Tag name expected.";
    private static final String ERR_TAGNAME2_EXPECTED = "Tag name, '?' or '!' expected.";
    private static final String ERR_DASH_EXPECTED = "'-' expected.";
    private static final String ERR_COMMENT_CLOSE_EXPECTED = "'-->' expected.";
    private static final String ERR_CDATA_EXPECTED = "'CDATA' expected.";
    private static final String ERR_OPENSQBRACKET_EXPECTED = "'[' expected.";
    private static final String ERR_CLOSE_CDATA_EXPECTED = "']]>' expected.";
    private static final String ERR_SEMICOLON_EXPECTED = "';' expected.";
    private static final String ERR_XMLPROLOG_EXPECTED = "XML prolog '<?xml' is not expected at this position.";
    private static final String ERR_VERSION_EXPECTED = "'version' attribute expected.";
    private static final String ERR_ENCODING_STANDALONE_EXPECTED = "'encoding', 'standalone' or '?>' expected.";
    private static final String ERR_STANDALONE_EXPECTED = "'standalone' attribute expected.";
    protected static final boolean fDebug = Activator.getBoolean("xml.debug");
    protected static final boolean fInternAttributes = Activator.getBoolean("xml.intern.attributes");
    private String fDefaultEncoding = "UTF-8";
    private CharBuffer temp = new CharBuffer();
    private CharBuffer temp2 = null;
    protected Reader fReader = null;
    protected InputStream fStream = null;
    protected char currentChar = '\u0000';
    protected ExTagListener fExTagListener;
    protected int fLine = 1;
    protected int fPos = 0;
    protected int fLevel = -1;
    protected int fCurrentLevel = 1;
    private String fVersion = "1.0";
    private String fEncoding = "UTF-8";
    private String fStandalone = "yes";
    protected char prev_char = '\u0000';
    private char[] fBuffer = new char[4096];
    private int fBufferLen = 0;
    private int fBufferPos = 0;
    private static final char bA = '@';
    private static final char aZ = '[';
    private static final char ba = '`';
    private static final char az = '{';
    private static final char b0 = '/';
    private static final char a9 = ':';
    protected static final String[] entities = new String[]{"amp", "apos", "lt", "gt", "quot"};
    protected static final char[] ent_chars = new char[]{'&', '\'', '<', '>', '\"'};

    public XMLParserImpl() {
    }

    public XMLParserImpl(InputStream aInputStream, ExTagListener aListener) {
        this.fStream = aInputStream;
        this.fExTagListener = aListener;
    }

    public XMLParserImpl(Reader aReader, ExTagListener aListener) {
        this.fReader = aReader;
        this.fExTagListener = aListener;
    }

    public void setLevel(int aLevel) {
        this.fLevel = aLevel;
    }

    protected void setEncoding(String aEncoding) {
        if (this.fReader == null) {
            try {
                this.fReader = new InputStreamReader(this.fStream, aEncoding);
            }
            catch (Exception exception) {
                if (fDebug) {
                    System.err.println("[XMLParserImpl] Failed setting the encoding \"" + aEncoding + "\", continue parsing with the default one.");
                }
                this.fReader = new InputStreamReader(this.fStream);
            }
        }
    }

    protected CharBuffer getCharBuffer() {
        if (this.temp.length() <= 0) {
            return this.temp;
        }
        if (this.temp2 == null) {
            this.temp2 = new CharBuffer(0);
            return this.temp2;
        }
        if (this.temp2.length() <= 0) {
            return this.temp2;
        }
        return new CharBuffer(0);
    }

    protected boolean getNextChar() throws IOException {
        char ch;
        if (this.fReader == null) {
            int ach = this.fStream.read();
            if (ach < 0) {
                ach = 0;
            }
            if ((ch = (char)ach) == '\u0000' && this.prev_char == '\u0000') {
                throw new IOException(ERR_EOS);
            }
        } else {
            if (this.fBufferLen < 0) {
                throw new IOException(ERR_EOS);
            }
            if (this.fBufferPos >= this.fBufferLen) {
                this.fBufferLen = 0;
                this.fBufferPos = 0;
                int count = 0;
                while (this.fBufferLen == 0 && count < 100) {
                    this.fBufferLen = this.fReader.read(this.fBuffer);
                    ++count;
                }
                char c = ch = this.fBufferLen > 0 ? this.fBuffer[this.fBufferPos++] : (char)'\u0000';
                if (this.fBufferLen == 0) {
                    this.fBufferLen = -1;
                }
            } else {
                ch = this.fBuffer[this.fBufferPos++];
            }
        }
        this.prev_char = this.currentChar;
        this.currentChar = ch;
        ++this.fPos;
        switch (ch) {
            case '\n': {
                if (this.prev_char != '\r') {
                    ++this.fLine;
                }
                this.fPos = 0;
                break;
            }
            case '\r': {
                this.fPos = 0;
                ++this.fLine;
            }
        }
        return this.currentChar != '\u0000';
    }

    protected void parse_attr_value(CharBuffer sb, char quot) throws IOException {
        while (this.currentChar != quot && this.currentChar != '<') {
            if (this.accept_char('&')) {
                if (this.parse_CharRef(sb) || this.parse_EntityRef(sb)) continue;
                this.err(this.fPos - 1, ERR_ENTITY_EXPECTED);
                continue;
            }
            sb.append(this.currentChar);
            if (!this.getNextChar()) break;
        }
    }

    protected boolean parse_attr(TagImpl aParent) throws IOException {
        this.clearWhiteSpaces();
        String attrName = this.parse_identifier();
        if (attrName != null) {
            this.clearWhiteSpaces();
            if (!this.accept_char('=')) {
                this.err(ERR_EQUAL_EXPECTED);
            }
            this.clearWhiteSpaces();
            char quot = '\u0000';
            if (this.accept_char('\"')) {
                quot = '\"';
            } else if (this.accept_char('\'')) {
                quot = '\'';
            } else {
                this.err(ERR_QUOT_EXPECTED);
            }
            CharBuffer sb = this.getCharBuffer();
            this.parse_attr_value(sb, quot);
            if (!this.accept_char(quot)) {
                this.err("'" + quot + "' expected.");
            }
            String attrValue = sb.toString();
            if (fInternAttributes) {
                attrValue.intern();
            }
            aParent.addAttribute(attrName, attrValue);
            sb.setLength(0);
            return true;
        }
        return false;
    }

    protected boolean parse_attr_list(TagImpl aParent) throws IOException {
        boolean result = false;
        while (this.parse_attr(aParent)) {
            result = true;
        }
        return result;
    }

    protected final boolean isNameStartChar(char ch) {
        return ch > '@' && ch < '[' || ch > '`' && ch < '{' || ch == ':' || ch == '_' || ch > '\u00bf' && ch < '\u00d7' || ch > '\u00d7' && ch < '\u00f7' || ch > '\u00f7' && ch < '\u0300' || ch > '\u036f' && ch < '\u037e' || ch > '\u037e' && ch < '\u2000' || ch > '\u200b' && ch < '\u200e' || ch > '\u206f' && ch < '\u2190' || ch > '\u2bff' && ch < '\u2ff0' || ch > '\u3000' && ch < '\ud800' || ch > '\uf900' && ch < '\ufdd0' || ch > '\ufdef' && ch < '\ufffe' || ch > '\uffff' && ch < '\uf0000';
    }

    protected final boolean isNameChar(char ch) {
        return ch == '-' || ch == '.' || ch == '\u00b7' || ch > '/' && ch < ':' || this.isNameStartChar(ch) || ch > '\u02ff' && ch < '\u0370' || ch > '\u203e' && ch < '\u2041';
    }

    protected String parse_identifier() throws IOException {
        if (this.isNameStartChar(this.currentChar)) {
            CharBuffer sb = this.getCharBuffer();
            while (this.isNameChar(this.currentChar)) {
                sb.append(this.currentChar);
                if (!this.getNextChar()) break;
            }
            String result = sb.toString().intern();
            sb.setLength(0);
            return result;
        }
        return null;
    }

    protected boolean parse_tag_name(TagImpl aParent) throws IOException {
        String name = this.parse_identifier();
        if (name != null) {
            aParent.setName(name);
        }
        return name != null;
    }

    protected void notifyListeners(TagImpl aTag, boolean isStart) {
        try {
            if (isStart) {
                this.fExTagListener.startTag(aTag);
            } else {
                this.fExTagListener.endTag(aTag);
            }
        }
        catch (RuntimeException re) {
            if (fDebug) {
                System.err.println("An outside exception occurred while processing a tag on line " + aTag.getLine() + ", the tag name is: " + aTag.getName());
                re.printStackTrace(System.err);
            }
            throw re;
        }
    }

    protected boolean parse_tag_normal(TagImpl aParent) throws IOException {
        if (this.isNameStartChar(this.currentChar)) {
            TagImpl tag = new TagImpl();
            tag.setLine(this.fLine);
            this.parse_tag_name(tag);
            this.parse_attr_list(tag);
            this.clearWhiteSpaces();
            if (this.accept_char('/')) {
                if (!this.accept_char('>')) {
                    this.err(ERR_GT_EXPECTED);
                }
                aParent.addTag(tag);
                if (this.fLevel <= 0 || this.fLevel == this.fCurrentLevel) {
                    this.notifyListeners(tag, true);
                    this.notifyListeners(tag, false);
                }
                return true;
            }
            if (this.accept_char('>')) {
                this.notifyListeners(tag, true);
                while (true) {
                    this.clearWhiteSpaces();
                    int pos = this.fPos;
                    if (this.currentChar == '<') {
                        if (this.parse_tag(tag)) continue;
                        if (!this.accept_char('/')) {
                            this.err(pos + 1, ERR_CLOSE_TAG1_EXPECTED);
                        }
                        pos = this.fPos;
                        if (!this.accept_seq(tag.getName())) {
                            this.err(pos, String.valueOf('\'') + tag.getName() + "' string expected.");
                        }
                        this.clearWhiteSpaces();
                        if (!this.accept_char('>')) {
                            this.err(ERR_GT_EXPECTED);
                        }
                        aParent.addTag(tag);
                        if (this.fLevel <= 0 || this.fLevel == this.fCurrentLevel) {
                            this.notifyListeners(tag, false);
                        }
                        return true;
                    }
                    if (!this.parse_PCDATA(tag)) break;
                }
                this.err(ERR_CONTENT_EXPECTED);
            } else {
                this.err(ERR_CLOSE_TAG2_EXPECTED);
            }
        }
        return false;
    }

    protected boolean accept_attr(TagImpl aTag, String attrName) {
        return aTag.getAttribute(attrName) != null;
    }

    protected boolean parse_xml_prolog(TagImpl parent) throws IOException {
        TagImpl tag;
        if (this.accept_char('?') && this.parse_tag_name(tag = new TagImpl())) {
            if (tag.getName().equalsIgnoreCase(XML)) {
                this.clearWhiteSpaces();
                int pos = this.fPos;
                if (this.parse_attr(tag)) {
                    String s = tag.getAttribute(VERSION);
                    if (s == null) {
                        this.err(pos, ERR_VERSION_EXPECTED);
                    }
                    this.fVersion = s;
                    this.clearWhiteSpaces();
                    pos = this.fPos;
                    if (this.parse_attr(tag)) {
                        this.clearWhiteSpaces();
                        if (this.accept_attr(tag, ENCODING)) {
                            this.fEncoding = tag.getAttribute(ENCODING);
                            pos = this.fPos;
                            if (this.parse_attr(tag)) {
                                this.clearWhiteSpaces();
                                if (this.accept_attr(tag, STANDALONE)) {
                                    this.fStandalone = tag.getAttribute(STANDALONE);
                                } else {
                                    this.err(pos, ERR_STANDALONE_EXPECTED);
                                }
                            }
                        } else if (this.accept_attr(tag, STANDALONE)) {
                            this.fStandalone = tag.getAttribute(STANDALONE);
                        } else {
                            this.err(pos, ERR_ENCODING_STANDALONE_EXPECTED);
                        }
                    }
                    this.clearWhiteSpaces();
                    pos = this.fPos;
                    if (!this.accept_seq("?>")) {
                        this.err(pos, ERR_CLOSE_TAG3_EXPECTED);
                    }
                } else {
                    this.err(pos, ERR_VERSION_EXPECTED);
                }
                this.clearWhiteSpaces();
                return true;
            }
            int prevCh = 0;
            while (true) {
                if (this.currentChar == '>') {
                    if (prevCh == 63) {
                        this.accept_char('>');
                        this.clearWhiteSpaces();
                        return true;
                    }
                    this.err(ERR_QUESTIONMARK_EXPECTED);
                } else if (this.currentChar == '<') {
                    this.err("Illegal character. ('<')");
                }
                prevCh = this.currentChar;
                this.getNextChar();
            }
        }
        return false;
    }

    protected boolean parse_tag_special(TagImpl aParent) throws IOException {
        if (this.accept_char('!')) {
            TagImpl tag = new TagImpl();
            if (this.parse_tag_name(tag)) {
                this.clearWhiteSpaces();
                while (true) {
                    if (this.accept_char('>')) {
                        this.clearWhiteSpaces();
                        return true;
                    }
                    this.getNextChar();
                }
            }
            if (this.parse_tag_CDATA(aParent)) {
                return true;
            }
            if (this.parse_comment(tag)) {
                return true;
            }
        } else if (this.accept_char('?')) {
            TagImpl tag = new TagImpl();
            int pos = this.fPos;
            if (this.parse_tag_name(tag)) {
                if (tag.getName().equals(XML)) {
                    this.err(pos - 2, ERR_XMLPROLOG_EXPECTED);
                }
                int prevCh = 0;
                while (true) {
                    if (this.currentChar == '>' && prevCh == 63) {
                        this.accept_char('>');
                        this.clearWhiteSpaces();
                        return true;
                    }
                    prevCh = this.currentChar;
                    this.getNextChar();
                }
            }
            this.err(pos, ERR_TAGNAME_EXPECTED);
        }
        return false;
    }

    protected boolean parse_comment(TagImpl aParent) throws IOException {
        if (this.accept_char('-')) {
            if (!this.accept_char('-')) {
                this.err(ERR_DASH_EXPECTED);
            }
            while (true) {
                if (this.accept_char('-') && this.accept_char('-')) {
                    if (this.accept_char('>')) break;
                    this.err(ERR_GT_EXPECTED);
                }
                if (this.getNextChar()) continue;
                this.err(ERR_COMMENT_CLOSE_EXPECTED);
            }
            return true;
        }
        return false;
    }

    protected boolean parse_tag(TagImpl aParent) throws IOException {
        this.clearWhiteSpaces();
        try {
            ++this.fCurrentLevel;
            return this.accept_char('<') && (this.parse_tag_normal(aParent) || this.parse_tag_special(aParent));
            {
            }
        }
        finally {
            --this.fCurrentLevel;
        }
    }

    protected boolean parse_content(TagImpl aParent) throws IOException {
        return this.parse_PCDATA(aParent) || this.parse_tag(aParent);
    }

    protected boolean parse_tag_CDATA(TagImpl aParent) throws IOException {
        if (this.accept_char('[')) {
            int pos = this.fPos;
            if (!this.accept_seq(CDATA)) {
                this.err(pos, ERR_CDATA_EXPECTED);
            }
            if (!this.accept_char('[')) {
                this.err(ERR_OPENSQBRACKET_EXPECTED);
            }
            do {
                if (this.currentChar != '>') {
                    aParent.getContentBuffer().append(this.currentChar);
                    continue;
                }
                CharBuffer sb = aParent.getContentBuffer();
                int l = sb.length();
                if (l >= 2 && sb.charAt(l - 1) == ']' && sb.charAt(l - 2) == ']') {
                    sb.setLength(l - 2);
                    this.getNextChar();
                    return true;
                }
                sb.append(this.currentChar);
            } while (this.getNextChar());
            this.err(this.fPos - 1, ERR_CLOSE_CDATA_EXPECTED);
        }
        return false;
    }

    protected boolean parse_PCDATA(TagImpl aParent) throws IOException {
        boolean result = false;
        while (this.currentChar != '<') {
            result = true;
            CharBuffer sbContent = aParent.getContentBuffer();
            if (this.accept_char('&')) {
                int pos = this.fPos;
                if (this.parse_CharRef(sbContent) || this.parse_EntityRef(sbContent)) continue;
                this.err(pos - 1, ERR_ENTITY_EXPECTED);
                continue;
            }
            sbContent.append(this.currentChar);
            if (!this.getNextChar()) break;
        }
        return result;
    }

    protected boolean accept_char(char ch) throws IOException {
        if (this.currentChar == ch) {
            this.getNextChar();
            return true;
        }
        return false;
    }

    protected boolean accept_seq(String seq) throws IOException {
        int i = 0;
        while (i < seq.length()) {
            if (!this.accept_char(seq.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean parse_EntityRef(CharBuffer sb) throws IOException {
        String ent = this.parse_identifier();
        if (!this.accept_char(';')) {
            this.err(ERR_SEMICOLON_EXPECTED);
        }
        int length = entities.length;
        int i = 0;
        while (i < length) {
            if (entities[i] == ent) {
                sb.append(ent_chars[i]);
                return true;
            }
            ++i;
        }
        sb.append('&');
        if (ent != null && ent.length() > 0) {
            sb.append(ent);
        }
        sb.append(';');
        return true;
    }

    protected boolean parse_CharRef(CharBuffer sb) throws IOException {
        if (this.accept_char('#')) {
            while (this.currentChar != ';') {
                this.getNextChar();
            }
            if (!this.accept_char(';')) {
                this.err(this.fPos - 1, ERR_SEMICOLON_EXPECTED);
            }
            return true;
        }
        return false;
    }

    protected void clearWhiteSpaces() throws IOException {
        while (Character.isWhitespace(this.currentChar)) {
            if (!this.getNextChar()) break;
        }
    }

    protected void err(String message) throws IOException {
        this.err(this.fPos, message);
    }

    protected void err(int pos, String message) throws IOException {
        throw new IOException("[Line: " + this.fLine + ", Pos: " + pos + "]  " + message);
    }

    public void parseXML() throws IOException {
        TagImpl rootTag = new TagImpl();
        try {
            this.getNextChar();
            this.clearWhiteSpaces();
            boolean start = false;
            while (this.accept_char('<')) {
                start = true;
                int pos = this.fPos;
                if (this.fPos == 2 && this.fLine == 1) {
                    if (this.parse_xml_prolog(rootTag)) {
                        this.setEncoding(this.fEncoding);
                        this.clearWhiteSpaces();
                        continue;
                    }
                } else {
                    this.setEncoding(this.fDefaultEncoding);
                }
                if (!this.parse_tag_special(rootTag)) {
                    if (this.parse_tag_normal(rootTag)) {
                        return;
                    }
                    this.err(pos, ERR_TAGNAME2_EXPECTED);
                }
                this.clearWhiteSpaces();
            }
            if (!start) {
                this.err(ERR_LT_EXPECTED);
            }
        }
        catch (IOException ioe) {
            if (fDebug) {
                ioe.printStackTrace(System.err);
            }
            throw ioe;
        }
    }

    public static void parseXML(InputStream aInputStream, ExTagListener aListener, int aLevel) throws IOException {
        XMLParserImpl xml = new XMLParserImpl(aInputStream, aListener);
        xml.setLevel(aLevel);
        xml.parseXML();
    }

    public static void parseXML(Reader aReader, ExTagListener aListener, int aLevel) throws IOException {
        XMLParserImpl xml = new XMLParserImpl(aReader, aListener);
        xml.setLevel(aLevel);
        xml.parseXML();
    }

    public String getVersion() {
        return this.fVersion;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public String getStandalone() {
        return this.fStandalone;
    }
}

