/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.util;

import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.jsf.facesconfig.FacesConfigPlugin;
import org.eclipse.jst.jsf.facesconfig.internal.Logger;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigChangeEvent;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigRestartServerResourceDeltaVisitor;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigUtil;
import org.eclipse.jst.jsf.facesconfig.util.IFacesConfigChangeEvent;
import org.eclipse.jst.jsf.facesconfig.util.IFacesConfigChangeListener;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

final class FacesResourceChangeListener
implements IResourceChangeListener,
IResourceDeltaVisitor,
ISaveParticipant,
IResourceVisitor {
    private static FacesResourceChangeListener listener;
    private static boolean restartInProgress;
    private LinkedList facesConfigChangeListeners = new LinkedList();
    private static IPreferenceStore preferenceStore;
    private static final QualifiedName EDITOR_KEY;

    static {
        restartInProgress = false;
        preferenceStore = null;
        EDITOR_KEY = new QualifiedName("org.eclipse.ui.internal.registry.ResourceEditorRegistry", "EditorProperty");
    }

    public static void startup() {
        if (listener != null) {
            return;
        }
        listener = new FacesResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 24);
    }

    public static void shutdown() {
        if (listener == null) {
            return;
        }
        ResourcesPlugin.getWorkspace().removeSaveParticipant((Plugin)FacesConfigPlugin.getPlugin());
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
        listener = null;
    }

    private FacesResourceChangeListener() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            FacesConfigChangeEvent facesConfigChangeEvent = new FacesConfigChangeEvent();
            this.fireFacesConfigChangeEvent(facesConfigChangeEvent);
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException ignored) {
                Logger.log((Object)this, ignored);
            }
        }
        if (delta != null && event.getType() == 16) {
            FacesConfigRestartServerResourceDeltaVisitor visitor = new FacesConfigRestartServerResourceDeltaVisitor();
            try {
                delta.accept((IResourceDeltaVisitor)visitor);
            }
            catch (CoreException ignored) {
                Logger.log((Object)this, ignored);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        this.checkForFacesConfigFile(delta);
        return true;
    }

    private void checkForFacesConfigFile(IResourceDelta delta) {
        boolean isAdded;
        boolean bl = isAdded = delta.getKind() == 1;
        if (isAdded || delta.getKind() == 4 && (delta.getFlags() & 0x58100) != 0) {
            this.checkForFacesConfigFile(delta.getResource(), !isAdded);
        }
    }

    private void checkForFacesConfigFile(IResource resource, boolean ignoreNonFacesProjects) {
        if (resource.getType() == 1) {
            IFile file = (IFile)resource;
            if (FacesConfigUtil.isFacesConfigFile(file, ignoreNonFacesProjects)) {
                IVirtualComponent component = ComponentUtilities.findComponent((IResource)file);
                if (component != null) {
                    this.restartServerIfNecessary(component);
                    this.setRegistration(file);
                }
            } else {
                this.unsetRegistration(file);
            }
        }
    }

    private void setRegistration(IFile file) {
        String editorID = null;
        try {
            editorID = file.getPersistentProperty(EDITOR_KEY);
        }
        catch (CoreException coreException) {}
        if (editorID == null) {
            try {
                file.setPersistentProperty(EDITOR_KEY, "org.eclipse.jst.jsf.facesconfig.internal.presentation.FacesConfigEditor");
            }
            catch (CoreException e) {
                Logger.log(file, "Failed to set the vcurrent editor to SCFE", (Throwable)e);
            }
        }
    }

    private void unsetRegistration(IFile file) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor userEditor = registry.getDefaultEditor(file.getFullPath().toString());
        if (userEditor == null || !"org.eclipse.jst.jsf.facesconfig.internal.presentation.FacesConfigEditor".equals(userEditor.getId())) {
            this.traceFiner(file, "Not unsetting: Default already not Faces config. editor");
            return;
        }
        this.traceFiner(file, "Unsetting.");
        IEditorDescriptor[] editors = registry.getEditors(file.getFullPath().toString());
        if (editors.length > 1) {
            registry.setDefaultEditor(file.getFullPath().toString(), editors[1].getId());
        }
    }

    private void traceFiner(IFile file, String message) {
        String fileName = file.getProjectRelativePath().toString();
        Logger.trace("FacesconfigPlugin", this, String.valueOf(fileName) + ": " + message);
    }

    public void doneSaving(ISaveContext context) {
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
        context.needDelta();
    }

    public boolean visit(IResource resource) {
        this.checkForFacesConfigFile(resource, true);
        return true;
    }

    private void restartServerIfNecessary(IVirtualComponent component) {
        if (!restartInProgress) {
            boolean restart = false;
            if (preferenceStore != null) {
                restart = preferenceStore.getBoolean("jsf.project.restart");
            }
            if (restart) {
                restartInProgress = true;
                restartInProgress = false;
            }
        }
    }

    public static FacesResourceChangeListener getFacesResourceChangeListener() {
        if (listener == null) {
            listener = new FacesResourceChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 8);
        }
        return listener;
    }

    public void addFacesConfigChangeListener(IFacesConfigChangeListener facesConfigChangeListener) {
        this.facesConfigChangeListeners.add(facesConfigChangeListener);
    }

    public void removeFacesConfigChangeListener(IFacesConfigChangeListener facesConfigChangeListener) {
        this.facesConfigChangeListeners.remove(facesConfigChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireFacesConfigChangeEvent(IFacesConfigChangeEvent event) {
        LinkedList localCopy;
        FacesResourceChangeListener facesResourceChangeListener = this;
        synchronized (facesResourceChangeListener) {
            localCopy = (LinkedList)this.facesConfigChangeListeners.clone();
        }
        ListIterator iter = localCopy.listIterator();
        while (iter.hasNext()) {
            IFacesConfigChangeListener facesConfigChangeListener = (IFacesConfigChangeListener)iter.next();
            facesConfigChangeListener.resourceChanged(event);
        }
    }

    public static void setPreferenceStore(IPreferenceStore preferenceStore) {
        FacesResourceChangeListener.preferenceStore = preferenceStore;
    }
}

