/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.operations;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.UIRepositoryEvent;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IEngine;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvisioningOperationRunner;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.DownloadPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.SizingPhaseSet;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ProvisioningUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static void addMetadataRepository(URI location, boolean notify) throws ProvisionException {
        IProvisioningEventBus bus;
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        manager.addRepository(location);
        if (notify && (bus = ProvUIActivator.getDefault().getProvisioningEventBus()) != null) {
            bus.publishEvent((EventObject)((Object)new UIRepositoryEvent(location, 0, 0)));
        }
    }

    public static String getMetadataRepositoryProperty(URI location, String key) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        return manager.getRepositoryProperty(location, key);
    }

    public static void setMetadataRepositoryProperty(URI location, String key, String value) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        manager.setRepositoryProperty(location, key, value);
    }

    public static boolean getMetadataRepositoryEnablement(URI location) {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return false;
        }
        return manager.isEnabled(location);
    }

    public static boolean getArtifactRepositoryEnablement(URI location) {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return false;
        }
        return manager.isEnabled(location);
    }

    public static IMetadataRepository loadMetadataRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        IMetadataRepository repo = manager.loadRepository(location, monitor);
        String name = ProvisioningUtil.getMetadataRepositoryProperty(location, "p2.nickname");
        if ((name == null || name.length() == 0) && (name = repo.getName()) != null && name.length() > 0) {
            ProvisioningUtil.setMetadataRepositoryProperty(location, "p2.nickname", name);
        }
        return repo;
    }

    public static IStatus validateMetadataRepositoryLocation(URI location, IProgressMonitor monitor) {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            return new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        return manager.validateRepositoryLocation(location, monitor);
    }

    public static void removeMetadataRepository(URI location) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        manager.removeRepository(location);
        IProvisioningEventBus bus = ProvUIActivator.getDefault().getProvisioningEventBus();
        if (bus != null) {
            bus.publishEvent((EventObject)((Object)new UIRepositoryEvent(location, 0, 1)));
        }
    }

    public static void addArtifactRepository(URI location, boolean notify) throws ProvisionException {
        IProvisioningEventBus bus;
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        manager.addRepository(location);
        if (notify && (bus = ProvUIActivator.getDefault().getProvisioningEventBus()) != null) {
            bus.publishEvent((EventObject)((Object)new UIRepositoryEvent(location, 1, 0)));
        }
    }

    public static String getArtifactRepositoryProperty(URI location, String key) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        return manager.getRepositoryProperty(location, key);
    }

    public static void setArtifactRepositoryProperty(URI location, String key, String value) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        manager.setRepositoryProperty(location, key, value);
    }

    public static IArtifactRepository loadArtifactRepository(URI location, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        IArtifactRepository repo = manager.loadRepository(location, monitor);
        if (repo == null) {
            throw new ProvisionException(NLS.bind((String)ProvUIMessages.ProvisioningUtil_LoadRepositoryFailure, (Object)location));
        }
        String name = ProvisioningUtil.getArtifactRepositoryProperty(location, "p2.nickname");
        if (name == null && (name = ProvisioningUtil.getArtifactRepositoryProperty(location, "name")) != null) {
            ProvisioningUtil.setArtifactRepositoryProperty(location, "p2.nickname", name);
        }
        return repo;
    }

    public static void removeArtifactRepository(URI location) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        manager.removeRepository(location);
        IProvisioningEventBus bus = ProvUIActivator.getDefault().getProvisioningEventBus();
        if (bus != null) {
            bus.publishEvent((EventObject)((Object)new UIRepositoryEvent(location, 1, 1)));
        }
    }

    public static IProfile addProfile(String profileId, Map properties, IProgressMonitor monitor) throws ProvisionException {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoProfileRegistryFound);
        }
        return profileRegistry.addProfile(profileId, properties);
    }

    public static void removeProfile(String profileId, IProgressMonitor monitor) throws ProvisionException {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoProfileRegistryFound);
        }
        profileRegistry.removeProfile(profileId);
    }

    public static IProfile[] getProfiles() throws ProvisionException {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoProfileRegistryFound);
        }
        return profileRegistry.getProfiles();
    }

    public static long[] getProfileTimestamps(String id) throws ProvisionException {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoProfileRegistryFound);
        }
        return profileRegistry.listProfileTimestamps(id);
    }

    public static IProfile getProfile(String id) throws ProvisionException {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoProfileRegistryFound);
        }
        return profileRegistry.getProfile(id);
    }

    public static IProfile getProfile(String id, long timestamp) throws ProvisionException {
        IProfileRegistry profileRegistry;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoProfileRegistryFound);
        }
        return profileRegistry.getProfile(id, timestamp);
    }

    public static URI[] getMetadataRepositories(int flags) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        return manager.getKnownRepositories(flags);
    }

    public static void refreshMetadataRepositories(URI[] urls, IProgressMonitor monitor) throws ProvisionException {
        IMetadataRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(urls.length * 100));
        int i = 0;
        while (i < urls.length) {
            try {
                manager.refreshRepository(urls[i], (IProgressMonitor)mon.newChild(100));
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
    }

    public static URI[] getArtifactRepositories(int flags) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        return manager.getKnownRepositories(flags);
    }

    public static void refreshArtifactRepositories(URI[] urls, IProgressMonitor monitor) throws ProvisionException {
        IArtifactRepositoryManager manager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoRepositoryManager);
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(urls.length * 100));
        int i = 0;
        while (i < urls.length) {
            manager.refreshRepository(urls[i], (IProgressMonitor)mon.newChild(100));
            ++i;
        }
    }

    public static ProvisioningPlan getProvisioningPlan(ProfileChangeRequest request, ProvisioningContext context, IProgressMonitor monitor) throws ProvisionException {
        try {
            return ProvisioningUtil.getPlanner().getProvisioningPlan(request, context, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
    }

    public static ProvisioningPlan getRevertPlan(IProfile currentProfile, IProfile snapshot, IProgressMonitor monitor) throws ProvisionException {
        Assert.isNotNull((Object)currentProfile);
        Assert.isNotNull((Object)snapshot);
        return ProvisioningUtil.getPlanner().getDiffPlan(currentProfile, snapshot, monitor);
    }

    public static long getSize(ProvisioningPlan plan, String profileId, ProvisioningContext context, IProgressMonitor monitor) throws ProvisionException {
        IStatus status;
        SizingPhaseSet set;
        if (plan == null) {
            return -3L;
        }
        if (plan.getOperands().length == 0) {
            return 0L;
        }
        long installPlanSize = 0L;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
        if (plan.getInstallerPlan() != null) {
            set = new SizingPhaseSet();
            status = ProvisioningUtil.getEngine().perform(ProvisioningUtil.getProfile(profileId), (PhaseSet)set, plan.getInstallerPlan().getOperands(), context, (IProgressMonitor)mon.newChild(100));
            if (status.isOK()) {
                installPlanSize = set.getSizing().getDiskSize();
            }
        } else {
            mon.worked(100);
        }
        set = new SizingPhaseSet();
        status = ProvisioningUtil.getEngine().perform(ProvisioningUtil.getProfile(profileId), (PhaseSet)set, plan.getOperands(), context, (IProgressMonitor)mon.newChild(200));
        if (status.isOK()) {
            return installPlanSize + set.getSizing().getDiskSize();
        }
        return -2L;
    }

    public static IStatus performProvisioningPlan(ProvisioningPlan plan, PhaseSet phaseSet, IProfile profile, ProvisioningContext context, IProgressMonitor monitor) throws ProvisionException {
        return ProvisioningUtil.performProvisioningPlan(plan, phaseSet, context, monitor);
    }

    public static IStatus performProvisioningPlan(ProvisioningPlan plan, PhaseSet phaseSet, ProvisioningContext context, IProgressMonitor monitor) throws ProvisionException {
        Object set = phaseSet == null ? new DefaultPhaseSet() : phaseSet;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)500);
        int ticksUsed = 0;
        IProfile profile = plan.getProfileChangeRequest().getProfile();
        if (plan.getInstallerPlan() != null) {
            IStatus installerPlanStatus;
            if (set instanceof DefaultPhaseSet) {
                ArrayList<Operand> allOperands = new ArrayList<Operand>();
                allOperands.addAll(Arrays.asList(plan.getOperands()));
                allOperands.addAll(Arrays.asList(plan.getInstallerPlan().getOperands()));
                DownloadPhaseSet download = new DownloadPhaseSet();
                IStatus downloadStatus = ProvisioningUtil.getEngine().perform(profile, (PhaseSet)download, allOperands.toArray(new Operand[allOperands.size()]), context, (IProgressMonitor)mon.newChild(300));
                if (!downloadStatus.isOK()) {
                    mon.done();
                    return downloadStatus;
                }
                ticksUsed = 300;
            }
            if (!(installerPlanStatus = ProvisioningUtil.getEngine().perform(profile, set, plan.getInstallerPlan().getOperands(), context, (IProgressMonitor)mon.newChild(100))).isOK()) {
                mon.done();
                return installerPlanStatus;
            }
            ticksUsed += 100;
            BundleContext bundleContext = ProvUIActivator.getContext();
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.equinox.internal.provisional.configurator.Configurator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Configurator configChanger = (Configurator)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
            try {
                try {
                    ProvisioningOperationRunner.suppressRestart(true);
                    configChanger.applyConfiguration();
                    ProvisioningOperationRunner.clearRestartRequests();
                }
                catch (IOException e) {
                    mon.done();
                    Status status = new Status(4, "org.eclipse.equinox.p2.ui", ProvUIMessages.ProvisioningUtil_InstallPlanConfigurationError, (Throwable)e);
                    ProvisioningOperationRunner.suppressRestart(false);
                    return status;
                }
            }
            finally {
                ProvisioningOperationRunner.suppressRestart(false);
            }
        }
        return ProvisioningUtil.getEngine().perform(profile, set, plan.getOperands(), context, (IProgressMonitor)mon.newChild(500 - ticksUsed));
    }

    private static IEngine getEngine() throws ProvisionException {
        IEngine engine = (IEngine)ServiceHelper.getService((BundleContext)ProvUIActivator.getContext(), (String)IEngine.SERVICE_NAME);
        if (engine == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoEngineFound);
        }
        return engine;
    }

    public static IPlanner getPlanner() throws ProvisionException {
        IPlanner planner;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IPlanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((planner = (IPlanner)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoPlannerFound);
        }
        return planner;
    }

    public static IDirector getDirector() throws ProvisionException {
        IDirector director;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.equinox.internal.provisional.p2.director.IDirector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((director = (IDirector)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) == null) {
            throw new ProvisionException(ProvUIMessages.ProvisioningUtil_NoDirectorFound);
        }
        return director;
    }

    public static void setColocatedRepositoryEnablement(URI location, boolean enabled) {
        IArtifactRepositoryManager artifactManager;
        IMetadataRepositoryManager metaManager;
        BundleContext bundleContext = ProvUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((metaManager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())) != null) {
            metaManager.setEnabled(location, enabled);
        }
        BundleContext bundleContext2 = ProvUIActivator.getContext();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((artifactManager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName())) != null) {
            artifactManager.setEnabled(location, enabled);
        }
    }

    public static boolean isCategory(IInstallableUnit iu) {
        String isCategory = iu.getProperty("org.eclipse.equinox.p2.type.category");
        return isCategory != null && Boolean.valueOf(isCategory) != false;
    }

    public static IStatus performProvisioningPlan(ProvisioningPlan plan, PhaseSet phaseSet, IProfile profile, IProgressMonitor monitor) throws ProvisionException {
        Object set = phaseSet == null ? new DefaultPhaseSet() : phaseSet;
        return ProvisioningUtil.getEngine().perform(profile, set, plan.getOperands(), new ProvisioningContext(), monitor);
    }
}

