/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.ui.PlanAnalyzer;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.ProfileModificationAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.PreselectedIUInstallWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.provisional.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.PlannerResolutionOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.Policy;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class InstallAction
extends ProfileModificationAction {
    static /* synthetic */ Class class$0;

    public static ProfileChangeRequest computeProfileChangeRequest(IInstallableUnit[] ius, String targetProfileId, MultiStatus status, IProgressMonitor monitor) {
        IProfile profile;
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)targetProfileId);
        try {
            profile = ProvisioningUtil.getProfile(targetProfileId);
        }
        catch (ProvisionException e) {
            status.add((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", e.getLocalizedMessage(), (Throwable)e));
            return null;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)ProvUIMessages.ProfileChangeRequestBuildingRequest, (int)ius.length);
        int i = 0;
        while (i < ius.length) {
            Collector alreadyInstalled;
            if (Boolean.toString(true).equals(ius[i].getProperty("org.eclipse.equinox.p2.type.patch"))) {
                request.setInstallableUnitInclusionRules(ius[i], PlannerHelper.createOptionalInclusionRule((IInstallableUnit)ius[i]));
            }
            if ((alreadyInstalled = profile.query((Query)new InstallableUnitQuery(ius[i].getId()), new Collector(), null)).size() > 0) {
                IInstallableUnit installedIU = (IInstallableUnit)alreadyInstalled.iterator().next();
                int compareTo = ius[i].getVersion().compareTo((Object)installedIU.getVersion());
                if (compareTo > 0) {
                    boolean lockedForUpdate = false;
                    String value = profile.getInstallableUnitProperty(installedIU, "org.eclipse.equinox.p2.type.lock");
                    if (value != null) {
                        boolean bl = lockedForUpdate = (Integer.parseInt(value) & 2) == 2;
                    }
                    if (lockedForUpdate) {
                        status.merge(PlanAnalyzer.getStatus(10013, ius[i]));
                    } else {
                        request.addInstallableUnits(new IInstallableUnit[]{ius[i]});
                        request.removeInstallableUnits(new IInstallableUnit[]{installedIU});
                        status.merge(PlanAnalyzer.getStatus(10003, ius[i]));
                        if (!Boolean.toString(true).equals(profile.getInstallableUnitProperty(installedIU, "org.eclipse.equinox.p2.type.root"))) {
                            request.setInstallableUnitProfileProperty(ius[i], "org.eclipse.equinox.p2.type.root", (Object)Boolean.toString(true));
                        }
                    }
                } else if (compareTo < 0) {
                    status.merge(PlanAnalyzer.getStatus(10004, ius[i]));
                } else if (Boolean.toString(true).equals(profile.getInstallableUnitProperty(installedIU, "org.eclipse.equinox.p2.type.root"))) {
                    status.merge(PlanAnalyzer.getStatus(10005, ius[i]));
                } else {
                    status.merge(PlanAnalyzer.getStatus(10006, ius[i]));
                    request.setInstallableUnitProfileProperty(ius[i], Policy.getDefault().getQueryContext().getVisibleInstalledIUProperty(), (Object)Boolean.toString(true));
                }
            } else {
                request.addInstallableUnits(new IInstallableUnit[]{ius[i]});
                request.setInstallableUnitProfileProperty(ius[i], Policy.getDefault().getQueryContext().getVisibleInstalledIUProperty(), (Object)Boolean.toString(true));
            }
            sub.worked(1);
            ++i;
        }
        sub.done();
        return request;
    }

    public InstallAction(Policy policy, ISelectionProvider selectionProvider, String profileId) {
        super(policy, ProvUI.INSTALL_COMMAND_LABEL, selectionProvider, profileId);
        this.setToolTipText(ProvUI.INSTALL_COMMAND_TOOLTIP);
    }

    protected boolean isEnabledFor(Object[] selectionArray) {
        if (selectionArray.length == 0) {
            return false;
        }
        int i = 0;
        while (i < selectionArray.length) {
            IInstallableUnit iu;
            if (selectionArray[i] instanceof InstalledIUElement && this.isSelectable((IIUElement)selectionArray[i])) {
                return true;
            }
            Object object = selectionArray[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iu = (IInstallableUnit)ProvUI.getAdapter(object, clazz)) != null && this.isSelectable(iu)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSelectable(IIUElement element) {
        return super.isSelectable(element) && !(element.getParent(element) instanceof AvailableIUElement);
    }

    protected String getTaskName() {
        return ProvUIMessages.InstallIUProgress;
    }

    protected int performAction(IInstallableUnit[] ius, String targetProfileId, PlannerResolutionOperation resolution) {
        PreselectedIUInstallWizard wizard = new PreselectedIUInstallWizard(this.getPolicy(), targetProfileId, ius, resolution, new QueryableMetadataRepositoryManager(this.getPolicy().getQueryContext(), false));
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(this.getShell(), wizard);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
        return dialog.open();
    }

    protected ProfileChangeRequest getProfileChangeRequest(IInstallableUnit[] ius, String targetProfileId, MultiStatus status, IProgressMonitor monitor) {
        return InstallAction.computeProfileChangeRequest(ius, targetProfileId, status, monitor);
    }
}

