/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.html.core.internal.HTMLCoreMessages;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.Logger;
import org.eclipse.wst.html.core.internal.validate.ErrorState;
import org.eclipse.wst.sse.core.internal.validate.ErrorInfo;
import org.eclipse.wst.sse.core.internal.validate.ValidationMessage;

public class MessageFactory
implements ErrorState {
    private IProject fProject;
    private IScopeContext[] fLookupOrder;
    private IPreferencesService fPreferenceService;
    private static final String MSG_NO_ERROR = HTMLCoreMessages.No_error__UI_;
    private static final String MSG_UNDEFINED_ATTR_ERROR = HTMLCoreMessages.Undefined_attribute_name___ERROR_;
    private static final String MSG_UNDEFINED_VALUE_ERROR = HTMLCoreMessages.Undefined_attribute_value__ERROR_;
    private static final String MSG_DUPLICATE_ATTR_ERROR = HTMLCoreMessages.Multiple_values_specified__ERROR_;
    private static final String MSG_MISMATCHED_ATTR_ERROR = HTMLCoreMessages.Attribute_name___0___uses__ERROR_;
    private static final String MSG_INVALID_ATTR_ERROR = HTMLCoreMessages.Invalid_attribute_name___0_ERROR_;
    private static final String MSG_ATTR_NO_VALUE_ERROR = HTMLCoreMessages.Invalid_attribute___0____ERROR_;
    private static final String MSG_INVALID_CONTENT_ERROR = HTMLCoreMessages.Invalid_location_of_tag____ERROR_;
    private static final String MSG_DUPLICATE_TAG_ERROR = HTMLCoreMessages.Duplicate_tag___0____ERROR_;
    private static final String MSG_MISSING_START_TAG_ERROR = HTMLCoreMessages.No_start_tag____0_____ERROR_;
    private static final String MSG_MISSING_END_TAG_ERROR = HTMLCoreMessages.No_end_tag_____0_____ERROR_;
    private static final String MSG_UNNECESSARY_END_TAG_ERROR = HTMLCoreMessages.End_tag_____0____not_neede_ERROR_;
    private static final String MSG_UNDEFINED_TAG_ERROR = HTMLCoreMessages.Unknown_tag___0____ERROR_;
    private static final String MSG_MISMATCHED_TAG_ERROR = HTMLCoreMessages.Tag_name___0___uses_wrong__ERROR_;
    private static final String MSG_INVALID_TAG_ERROR = HTMLCoreMessages.Invalid_tag_name___0____ERROR_;
    private static final String MSG_INVALID_DIRECTIVE_ERROR = HTMLCoreMessages.Invalid_JSP_directive___0__ERROR_;
    private static final String MSG_INVALID_TEXT_ERROR = HTMLCoreMessages.Invalid_text_string___0____ERROR_;
    private static final String MSG_INVALID_CHAR_ERROR = HTMLCoreMessages.Invalid_character_used_in__ERROR_;
    private static final String MSG_UNKNOWN_ERROR = HTMLCoreMessages.Unknown_error__ERROR_;
    private static final String MSG_UNCLOSED_START_TAG_ERROR = HTMLCoreMessages.Start_tag____0____not_clos_ERROR_;
    private static final String MSG_UNCLOSED_END_TAG_ERROR = HTMLCoreMessages.End_tag_____0____not_close_ERROR_;
    private static final String MSG_MISMATCHED_ATTR_VALUE_ERROR = HTMLCoreMessages.Attribute_value___0___uses_ERROR_;
    private static final String MSG_UNCLOSED_COMMENT_ERROR = HTMLCoreMessages.Comment_not_closed__ERROR_;
    private static final String MSG_UNCLOSED_DOCTYPE_ERROR = HTMLCoreMessages.DOCTYPE_declaration_not_cl_ERROR_;
    private static final String MSG_UNCLOSED_PI_ERROR = HTMLCoreMessages.Processing_instruction_not_ERROR_;
    private static final String MSG_UNCLOSED_CDATA_SECTION_ERROR = HTMLCoreMessages.CDATA_section_not_closed__ERROR_;
    private static final String MSG_INVALID_EMPTY_ELEMENT_TAG = HTMLCoreMessages._ERROR_Tag___0___should_be_an_empty_element_tag_1;
    private static final String MSG_UNCLOSED_ATTR_VALUE_ERROR = HTMLCoreMessages._ERROR_Attribute_value___0___not_closed__1;
    private static final String MSG_RESOURCE_NOT_FOUND = HTMLCoreMessages._ERROR_Resource_not_found_0;
    private ErrorTable[] errTables = new ErrorTable[8];

    public MessageFactory() {
        this.init();
    }

    public MessageFactory(IProject project) {
        this.fProject = project;
        this.init();
    }

    protected Preferences getModelPreferences() {
        return HTMLCorePlugin.getDefault().getPluginPreferences();
    }

    private void mapToKey(String key, ErrorTable errorTable, int state, String msg) {
        int severity = 2;
        severity = this.fPreferenceService.getInt(HTMLCorePlugin.getDefault().getBundle().getSymbolicName(), key, 2, this.fLookupOrder);
        errorTable.put(state, msg, severity);
    }

    private void init() {
        ProjectScope projectScope;
        this.fPreferenceService = Platform.getPreferencesService();
        this.fLookupOrder = new IScopeContext[]{new InstanceScope(), new DefaultScope()};
        if (this.fProject != null && (projectScope = new ProjectScope(this.fProject)).getNode(HTMLCorePlugin.getDefault().getBundle().getSymbolicName()).getBoolean("use-project-settings", false)) {
            this.fLookupOrder = new IScopeContext[]{projectScope, new InstanceScope(), new DefaultScope()};
        }
        int i = 0;
        while (i < 8) {
            this.errTables[i] = new ErrorTable();
            ++i;
        }
        ErrorTable attrTable = this.errTables[0];
        attrTable.put(0, MSG_NO_ERROR, 0);
        this.mapToKey("attrUndefName", attrTable, 11, MSG_UNDEFINED_ATTR_ERROR);
        this.mapToKey("attrUndefValue", attrTable, 12, MSG_UNDEFINED_VALUE_ERROR);
        this.mapToKey("attrNameMismatch", attrTable, 103, MSG_MISMATCHED_ATTR_ERROR);
        this.mapToKey("attrInvalidName", attrTable, 101, MSG_INVALID_ATTR_ERROR);
        this.mapToKey("attrInvalidValue", attrTable, 108, MSG_ATTR_NO_VALUE_ERROR);
        this.mapToKey("attrDuplicate", attrTable, 1002, MSG_DUPLICATE_ATTR_ERROR);
        this.mapToKey("attrValueMismatch", attrTable, 13, MSG_MISMATCHED_ATTR_VALUE_ERROR);
        this.mapToKey("attrValueUnclosed", attrTable, 113, MSG_UNCLOSED_ATTR_VALUE_ERROR);
        this.mapToKey("resourceNotFound", attrTable, 114, MSG_RESOURCE_NOT_FOUND);
        ErrorTable elemTable = this.errTables[1];
        elemTable.put(0, MSG_NO_ERROR, 0);
        this.mapToKey("elemUnknownName", elemTable, 11, MSG_UNDEFINED_TAG_ERROR);
        this.mapToKey("elemInvalidName", elemTable, 101, MSG_INVALID_TAG_ERROR);
        this.mapToKey("elemStartInvalidCase", elemTable, 103, MSG_MISMATCHED_TAG_ERROR);
        this.mapToKey("elemEndInvalidCase", elemTable, 104, MSG_MISMATCHED_TAG_ERROR);
        this.mapToKey("elemMissingStart", elemTable, 105, MSG_MISSING_START_TAG_ERROR);
        this.mapToKey("elemMissingEnd", elemTable, 106, MSG_MISSING_END_TAG_ERROR);
        this.mapToKey("elemUnnecessaryEnd", elemTable, 107, MSG_UNNECESSARY_END_TAG_ERROR);
        this.mapToKey("elemInvalidDirective", elemTable, 109, MSG_INVALID_DIRECTIVE_ERROR);
        this.mapToKey("elemInvalidContent", elemTable, 1001, MSG_INVALID_CONTENT_ERROR);
        this.mapToKey("elemDuplicate", elemTable, 1002, MSG_DUPLICATE_TAG_ERROR);
        this.mapToKey("elemCoexistence", elemTable, 1003, MSG_INVALID_CONTENT_ERROR);
        this.mapToKey("elemUnclosedStartTag", elemTable, 110, MSG_UNCLOSED_START_TAG_ERROR);
        this.mapToKey("elemUnclosedEndTag", elemTable, 111, MSG_UNCLOSED_END_TAG_ERROR);
        this.mapToKey("elemInvalidEmptyTag", elemTable, 112, MSG_INVALID_EMPTY_ELEMENT_TAG);
        ErrorTable docTable = this.errTables[2];
        docTable.put(0, MSG_NO_ERROR, 0);
        this.mapToKey("docDuplicateTag", docTable, 1002, MSG_DUPLICATE_TAG_ERROR);
        this.mapToKey("docInvalidContent", docTable, 1001, MSG_INVALID_CONTENT_ERROR);
        this.mapToKey("docDoctypeUnclosed", docTable, 110, MSG_UNCLOSED_DOCTYPE_ERROR);
        ErrorTable textTable = this.errTables[3];
        textTable.put(0, MSG_NO_ERROR, 0);
        this.mapToKey("docInvalidContent", textTable, 1001, MSG_INVALID_TEXT_ERROR);
        this.mapToKey("docInvalidChar", textTable, 102, MSG_INVALID_CHAR_ERROR);
        ErrorTable commTable = this.errTables[4];
        commTable.put(0, MSG_NO_ERROR, 0);
        this.mapToKey("commentInvalidContent", commTable, 1001, MSG_INVALID_CONTENT_ERROR);
        this.mapToKey("commentUnclosed", commTable, 110, MSG_UNCLOSED_COMMENT_ERROR);
        ErrorTable cdatTable = this.errTables[5];
        cdatTable.put(0, MSG_NO_ERROR, 0);
        this.mapToKey("cdataInvalidContent", cdatTable, 1001, MSG_INVALID_CONTENT_ERROR);
        this.mapToKey("cdataUnclosed", cdatTable, 110, MSG_UNCLOSED_CDATA_SECTION_ERROR);
        ErrorTable piTable = this.errTables[6];
        piTable.put(0, MSG_NO_ERROR, 0);
        this.mapToKey("piInvalidContent", piTable, 1001, MSG_INVALID_CONTENT_ERROR);
        this.mapToKey("piUnclosed", piTable, 110, MSG_UNCLOSED_PI_ERROR);
        ErrorTable erTable = this.errTables[7];
        erTable.put(0, MSG_NO_ERROR, 0);
        this.mapToKey("piUndefined", erTable, 11, MSG_UNDEFINED_TAG_ERROR);
        this.mapToKey("refInvalidContent", erTable, 1001, MSG_INVALID_CONTENT_ERROR);
    }

    public ValidationMessage createMessage(ErrorInfo info) {
        String errorMsg = this.getErrorMessage(info);
        int errorSeverity = this.getErrorSeverity(info);
        return new ValidationMessage(errorMsg, info.getOffset(), info.getLength(), errorSeverity);
    }

    private String getErrorMessage(ErrorInfo info) {
        ErrorTable tab = this.getErrorTable(info.getTargetType());
        if (tab == null) {
            return MSG_UNKNOWN_ERROR;
        }
        String template = tab.getMessage(info.getState());
        Object[] arguments = new Object[]{info.getHint()};
        String s = null;
        try {
            s = NLS.bind((String)template, (Object[])arguments);
        }
        catch (IllegalArgumentException e) {
            Logger.logException(e);
            s = String.valueOf(template) + ":" + arguments.toString();
        }
        return s;
    }

    private int getErrorSeverity(ErrorInfo info) {
        ErrorTable tab = this.getErrorTable(info.getTargetType());
        if (tab == null) {
            return 0;
        }
        return tab.getSeverity(info.getState());
    }

    private ErrorTable getErrorTable(short nodetype) {
        ErrorTable tab = null;
        switch (nodetype) {
            case 2: {
                tab = this.errTables[0];
                break;
            }
            case 1: {
                tab = this.errTables[1];
                break;
            }
            case 10: {
                tab = this.errTables[2];
                break;
            }
            case 3: {
                tab = this.errTables[3];
                break;
            }
            case 8: {
                tab = this.errTables[4];
                break;
            }
            case 4: {
                tab = this.errTables[5];
                break;
            }
            case 7: {
                tab = this.errTables[6];
                break;
            }
            case 5: {
                tab = this.errTables[7];
                break;
            }
            default: {
                return null;
            }
        }
        return tab;
    }

    private static class ErrorTable {
        private Hashtable map = new Hashtable();

        public Packet put(int state, String msg, int severity) {
            Packet packet = new Packet(msg, severity);
            this.map.put(new Integer(state), packet);
            return packet;
        }

        public String getMessage(int state) {
            return this.getPacket(state).getMessage();
        }

        public int getSeverity(int state) {
            return this.getPacket(state).getSeverity();
        }

        private Packet getPacket(int state) {
            return (Packet)this.map.get(new Integer(state));
        }

        private class Packet {
            private String msg = null;
            private int severity = -1;

            public Packet(String msg, int severity) {
                this.msg = msg;
                this.severity = severity;
            }

            public String getMessage() {
                return this.msg;
            }

            public int getSeverity() {
                return this.severity;
            }
        }
    }

    private static interface NodeType {
        public static final int ATTRIBUTE = 0;
        public static final int ELEMENT = 1;
        public static final int DOCUMENT_TYPE = 2;
        public static final int TEXT = 3;
        public static final int COMMENT = 4;
        public static final int CDATA_SECTION = 5;
        public static final int PROCESSING_INSTRUCTION = 6;
        public static final int ENTITY_REFERENCE = 7;
        public static final int MAX_TYPE = 8;
    }
}

