/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.contentmodel;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.wst.html.core.internal.contentmodel.CMNamespaceImpl;
import org.eclipse.wst.html.core.internal.contentmodel.HCMDocImpl;
import org.eclipse.wst.html.core.internal.contentmodel.JCM20DocImpl;
import org.eclipse.wst.html.core.internal.contentmodel.JCMDocImpl;
import org.eclipse.wst.html.core.internal.contentmodel.TagCMDocImpl;
import org.eclipse.wst.html.core.internal.contentmodel.chtml.CHCMDocImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;

public final class HTMLCMDocumentFactory {
    private static Hashtable cmdocs = new Hashtable();
    private static List supportedCMtypes = Arrays.asList("HTML", "CHTML", "JSP11", "JSP12", "JSP20", "JSP20.TAG");
    private static JCMDocImpl jsp11doc = null;

    private HTMLCMDocumentFactory() {
    }

    public static CMDocument getCMDocument(String cmtype) {
        Object obj = cmdocs.get(cmtype);
        if (obj == null && cmtype != null && supportedCMtypes.contains(cmtype)) {
            obj = HTMLCMDocumentFactory.doCreateCMDocument(cmtype);
            cmdocs.put(cmtype, obj);
        }
        return (CMDocument)obj;
    }

    private static Object doCreateCMDocument(String cmtype) {
        if ("HTML".equals(cmtype)) {
            CMNamespaceImpl h40ns = new CMNamespaceImpl("http://www.w3.org/TR/REC-html40/frameset.dtd", "");
            HCMDocImpl html40doc = new HCMDocImpl("HTML", h40ns);
            return html40doc;
        }
        if ("JSP20".equals(cmtype)) {
            CMNamespaceImpl j20ns = new CMNamespaceImpl("", "jsp");
            JCM20DocImpl jsp20doc = new JCM20DocImpl("JSP20", j20ns);
            return jsp20doc;
        }
        if ("JSP20.TAG".equals(cmtype)) {
            CMNamespaceImpl j20ns = new CMNamespaceImpl("", "jsp");
            TagCMDocImpl tag20doc = new TagCMDocImpl("JSP20.TAG", j20ns);
            return tag20doc;
        }
        if ("JSP11".equals(cmtype) || "JSP12".equals(cmtype)) {
            if (jsp11doc == null) {
                CMNamespaceImpl j11ns = new CMNamespaceImpl("", "jsp");
                jsp11doc = new JCMDocImpl("JSP11", j11ns);
            }
            return jsp11doc;
        }
        if ("CHTML".equals(cmtype)) {
            CMNamespaceImpl cH40ns = new CMNamespaceImpl("http://www.w3.org/TR/REC-html40/frameset.dtd", "");
            CHCMDocImpl chtmldoc = new CHCMDocImpl("CHTML", cH40ns);
            return chtmldoc;
        }
        return null;
    }
}

