/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateEngine;
import org.eclipse.jdt.internal.ui.text.template.contentassist.TemplateProposal;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;

public abstract class AbstractTemplateCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private TemplateEngine fEngine;

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!(context instanceof JavaContentAssistInvocationContext)) {
            return Collections.EMPTY_LIST;
        }
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        ICompilationUnit unit = javaContext.getCompilationUnit();
        if (unit == null) {
            return Collections.EMPTY_LIST;
        }
        this.fEngine = this.computeCompletionEngine(javaContext);
        if (this.fEngine == null) {
            return Collections.EMPTY_LIST;
        }
        this.fEngine.reset();
        this.fEngine.complete(javaContext.getViewer(), javaContext.getInvocationOffset(), unit);
        TemplateProposal[] templateProposals = this.fEngine.getResults();
        ArrayList<TemplateProposal> result = new ArrayList<TemplateProposal>(Arrays.asList(templateProposals));
        IJavaCompletionProposal[] keyWordResults = javaContext.getKeywordProposals();
        if (keyWordResults.length == 0) {
            return result;
        }
        int k = 0;
        while (k < templateProposals.length) {
            TemplateProposal curr = templateProposals[k];
            String name = curr.getTemplate().getPattern();
            int i = 0;
            while (i < keyWordResults.length) {
                String content;
                String keyword = keyWordResults[i].getDisplayString();
                if (name.startsWith(keyword) && (content = curr.getTemplate().getPattern()).startsWith(keyword)) {
                    curr.setRelevance(keyWordResults[i].getRelevance() + 1);
                    break;
                }
                ++i;
            }
            ++k;
        }
        return result;
    }

    protected abstract TemplateEngine computeCompletionEngine(JavaContentAssistInvocationContext var1);

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.EMPTY_LIST;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionStarted() {
    }

    public void sessionEnded() {
        if (this.fEngine != null) {
            this.fEngine.reset();
            this.fEngine = null;
        }
    }
}

