/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.Java50Fix;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class Java50CleanUp
extends AbstractMultiFix {
    public Java50CleanUp(Map options) {
        super(options);
    }

    public Java50CleanUp() {
    }

    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.requireAST();
        Map requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    private boolean requireAST() {
        boolean addAnotations = this.isEnabled("cleanup.add_missing_annotations");
        return addAnotations && this.isEnabled("cleanup.add_missing_override_annotations") || addAnotations && this.isEnabled("cleanup.add_missing_deprecated_annotations") || this.isEnabled("cleanup.use_arguments_for_raw_type_references");
    }

    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        boolean addAnotations = this.isEnabled("cleanup.add_missing_annotations");
        return Java50Fix.createCleanUp(compilationUnit, addAnotations && this.isEnabled("cleanup.add_missing_override_annotations"), addAnotations && this.isEnabled("cleanup.add_missing_deprecated_annotations"), this.isEnabled("cleanup.use_arguments_for_raw_type_references"));
    }

    protected ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return Java50Fix.createCleanUp(compilationUnit, problems, this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations"), this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations"), this.isEnabled("cleanup.use_arguments_for_raw_type_references"));
    }

    private Map getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            result.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", "warning");
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            result.put("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", "warning");
        }
        if (this.isEnabled("cleanup.use_arguments_for_raw_type_references")) {
            result.put("org.eclipse.jdt.core.compiler.problem.rawTypeReference", "warning");
        }
        return result;
    }

    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            result.add(MultiFixMessages.Java50MultiFix_AddMissingOverride_description);
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            result.add(MultiFixMessages.Java50MultiFix_AddMissingDeprecated_description);
        }
        if (this.isEnabled("cleanup.use_arguments_for_raw_type_references")) {
            result.add(MultiFixMessages.Java50CleanUp_AddTypeParameters_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        buf.append("class E {\n");
        buf.append("    /**\n");
        buf.append("     * @deprecated\n");
        buf.append("     */\n");
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            buf.append("    @Deprecated\n");
        }
        buf.append("    public void foo() {}\n");
        buf.append("}\n");
        buf.append("class ESub extends E {\n");
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            buf.append("    @Override\n");
        }
        buf.append("    public void foo() {}\n");
        buf.append("}\n");
        return buf.toString();
    }

    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        if (problem.getProblemId() == 67109491) {
            return this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations");
        }
        if (Java50Fix.isMissingDeprecationProblem(problem)) {
            return this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations");
        }
        if (Java50Fix.isRawTypeReference(problem)) {
            return this.isEnabled("cleanup.use_arguments_for_raw_type_references");
        }
        return false;
    }

    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        int id;
        int i;
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_override_annotations")) {
            result += Java50CleanUp.getNumberOfProblems(problems, 67109491);
        }
        if (this.isEnabled("cleanup.add_missing_annotations") && this.isEnabled("cleanup.add_missing_deprecated_annotations")) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 536871540 || id == 536871541 || id == 536871542) {
                    ++result;
                }
                ++i;
            }
        }
        if (this.isEnabled("cleanup.use_arguments_for_raw_type_references")) {
            i = 0;
            while (i < problems.length) {
                id = problems[i].getID();
                if (id == 16777748 || id == 16777788 || id == 16777747) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }
}

