/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

class ExpandWithConstructorsDialog
extends StatusDialog {
    private static final String LINE_DELIMITER_REGEX = "\\r\\n?|\\n";
    private Button fAnonymousButton;
    private StyledText fDefaultTypesText;

    protected ExpandWithConstructorsDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CallHierarchyMessages.ExpandWithConstructorsDialog_title);
        this.setHelpAvailable(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.jdt.ui.call_hierarchy_expand_with_constructors_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridData)composite.getLayoutData()).widthHint = this.convertWidthInCharsToPixels(60);
        Label descriptionLabel = new Label(composite, 64);
        descriptionLabel.setText(CallHierarchyMessages.ExpandWithConstructorsDialog_explanation_label);
        descriptionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Label typesLabel = new Label(composite, 64);
        typesLabel.setText(CallHierarchyMessages.ExpandWithConstructorsDialog_typeNames_label);
        typesLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.fDefaultTypesText = new StyledText(composite, 2880);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        this.fDefaultTypesText.setLayoutData((Object)gd);
        String defaultTypesPref = PreferenceConstants.getPreferenceStore().getString("CallHierarchy.defaultExpandWithConstructors");
        String defaultTypesText = defaultTypesPref.replace(';', '\n');
        this.fDefaultTypesText.setText(defaultTypesText);
        this.fDefaultTypesText.setSelection(this.fDefaultTypesText.getCharCount());
        this.fDefaultTypesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExpandWithConstructorsDialog.this.validateInput();
            }
        });
        this.fAnonymousButton = new Button(composite, 32);
        this.fAnonymousButton.setText(CallHierarchyMessages.ExpandWithConstructorsDialog_anonymousTypes_label);
        boolean anonymousPref = PreferenceConstants.getPreferenceStore().getBoolean("CallHierarchy.anonymousExpandWithConstructors");
        this.fAnonymousButton.setSelection(anonymousPref);
        this.fAnonymousButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        return composite;
    }

    protected void okPressed() {
        PreferenceConstants.getPreferenceStore().setValue("CallHierarchy.anonymousExpandWithConstructors", this.fAnonymousButton.getSelection());
        String defaultTypes = this.fDefaultTypesText.getText().trim();
        String defaultTypesPref = defaultTypes.replaceAll(LINE_DELIMITER_REGEX, ";");
        PreferenceConstants.getPreferenceStore().setValue("CallHierarchy.defaultExpandWithConstructors", defaultTypesPref);
        super.okPressed();
    }

    private void validateInput() {
        StatusInfo status = new StatusInfo();
        String[] defaultTypes = this.fDefaultTypesText.getText().split(LINE_DELIMITER_REGEX);
        int i = 0;
        while (i < defaultTypes.length) {
            IStatus typeNameStatus;
            String type = defaultTypes[i];
            if (type.length() != 0 && (typeNameStatus = JavaConventions.validateJavaTypeName((String)type, (String)"1.3", (String)"1.3")).getSeverity() == 4) {
                status.setError(Messages.format(CallHierarchyMessages.ExpandWithConstructorsDialog_not_a_valid_type_name, type));
                break;
            }
            ++i;
        }
        this.updateStatus(status);
    }
}

