/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.result.AggregateExpression;
import org.eclipse.datatools.connectivity.oda.spec.result.ColumnIdentifier;
import org.eclipse.datatools.connectivity.oda.spec.util.ValidatorUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultProjection {
    private Map<ColumnIdentifier, AggregateExpression> m_aggregateSpecByColumn;
    private Map<ColumnIdentifier, ExpressionVariable> m_addedColumns;
    private List<ColumnIdentifier> m_hiddenColumns;
    private static final int MAP_INITIAL_CAPACITY = 5;

    public void setProjection(ColumnIdentifier resultColumn, AggregateExpression aggregate) throws OdaException {
        this.validateColumnIdentifier(resultColumn);
        if (this.getHiddenResultColumns().contains(resultColumn)) {
            throw ValidatorUtil.newAggregateException(Messages.bind((String)Messages.querySpec_INVALID_AGGR_HIDE_COLUMN, (Object)resultColumn), aggregate);
        }
        this.getAggregatedColumns().put(resultColumn, aggregate);
    }

    public AggregateExpression getAggregateProjection(ColumnIdentifier resultColumn) {
        return this.getAggregatedColumns().get(resultColumn);
    }

    public Map<ColumnIdentifier, AggregateExpression> getAggregatedColumns() {
        if (this.m_aggregateSpecByColumn == null) {
            this.m_aggregateSpecByColumn = new LinkedHashMap<ColumnIdentifier, AggregateExpression>(5);
        }
        return this.m_aggregateSpecByColumn;
    }

    public void addResultColumn(ExpressionVariable columnExprVariable) throws OdaException {
        this.getAddedResultColumns().put(new ColumnIdentifier(columnExprVariable.getAlias()), columnExprVariable);
    }

    public Map<ColumnIdentifier, ExpressionVariable> getAddedResultColumns() {
        if (this.m_addedColumns == null) {
            this.m_addedColumns = new LinkedHashMap<ColumnIdentifier, ExpressionVariable>(5);
        }
        return this.m_addedColumns;
    }

    public void hideResultColumn(ColumnIdentifier resultColumn) throws OdaException {
        this.validateColumnIdentifier(resultColumn);
        this.getAggregatedColumns().remove(resultColumn);
        if (this.getAddedResultColumns().containsKey(resultColumn)) {
            this.getAddedResultColumns().remove(resultColumn);
        } else if (!this.getHiddenResultColumns().contains(resultColumn)) {
            this.getHiddenResultColumns().add(resultColumn);
        }
    }

    public List<ColumnIdentifier> getHiddenResultColumns() {
        if (this.m_hiddenColumns == null) {
            this.m_hiddenColumns = new ArrayList<ColumnIdentifier>(5);
        }
        return this.m_hiddenColumns;
    }

    private void validateColumnIdentifier(ColumnIdentifier resultColumn) throws OdaException {
        if (resultColumn == null || !resultColumn.isValid()) {
            throw new OdaException(new IllegalArgumentException(resultColumn.toString()));
        }
    }
}

