/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionArguments;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.IValidator;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ExtensionContributor;
import org.eclipse.datatools.connectivity.oda.spec.manifest.VariableRestrictions;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.CustomExpression;

public class FilterExpressionDefinition {
    public static final String ELEMENT_NAME = "filterType";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "displayName";
    public static final String ATTR_DESC = "description";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_MIN_ARGS = "minArguments";
    public static final String ATTR_MAX_ARGS = "maxArguments";
    public static final String ATTR_NEGATABLE = "isNegatable";
    public static final String ATTR_OPTIONABLE = "isOptionable";
    static final Integer ATTR_MIN_VARS_DEFAULT_VALUE = 1;
    static final String ATTR_UNBOUNDED_MAX_ARGS = "*";
    private IConfigurationElement m_exprElement;
    private ExtensionContributor m_contributorInfo;
    private String m_id;
    private String m_name;
    private String m_desc;
    private Integer m_minArgs;
    private Integer m_maxArgs;
    private boolean m_isNegatable;
    private boolean m_isOptionable;
    private VariableRestrictions m_varRestrictions;

    FilterExpressionDefinition(IConfigurationElement exprElement, ExtensionContributor providerInfo) throws OdaException {
        this.init(exprElement, providerInfo);
    }

    private void init(IConfigurationElement exprElement, ExtensionContributor contributorInfo) throws OdaException {
        if (!exprElement.isValid()) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_INVALID_EXT_POINT_ELEMENT, (Object)"org.eclipse.datatools.connectivity.oda.dynamicResultSet", (Object)exprElement.getContributor().getName()));
        }
        this.m_exprElement = exprElement;
        this.m_contributorInfo = contributorInfo;
        this.m_id = FilterExpressionDefinition.getIdAttributeValue(exprElement);
        this.m_name = exprElement.getAttribute(ATTR_NAME);
        if (this.m_name == null) {
            this.m_name = this.m_id;
        }
        this.m_desc = exprElement.getAttribute(ATTR_DESC);
        String attrValue = exprElement.getAttribute(ATTR_MIN_ARGS);
        if (attrValue == null) {
            this.m_minArgs = ATTR_MIN_VARS_DEFAULT_VALUE;
        } else {
            try {
                this.m_minArgs = Integer.valueOf(attrValue);
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.m_minArgs == null || this.m_minArgs < 0) {
                throw new OdaException(Messages.bind((String)Messages.querySpec_INVALID_EXT_POINT_ATTR_VALUE, (Object[])new Object[]{"org.eclipse.datatools.connectivity.oda.dynamicResultSet", exprElement.getContributor().getName(), attrValue, ATTR_MIN_ARGS}));
            }
        }
        attrValue = exprElement.getAttribute(ATTR_MAX_ARGS);
        if (attrValue != null && !attrValue.equals(ATTR_UNBOUNDED_MAX_ARGS)) {
            try {
                this.m_maxArgs = Integer.valueOf(attrValue);
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.m_maxArgs == null || this.m_maxArgs < this.m_minArgs) {
                throw new OdaException(Messages.bind((String)Messages.querySpec_INVALID_EXT_POINT_ATTR_VALUE, (Object[])new Object[]{"org.eclipse.datatools.connectivity.oda.dynamicResultSet", exprElement.getContributor().getName(), attrValue, ATTR_MAX_ARGS}));
            }
        }
        this.m_isNegatable = false;
        attrValue = exprElement.getAttribute(ATTR_NEGATABLE);
        if (attrValue != null) {
            this.m_isNegatable = Boolean.parseBoolean(attrValue);
        }
        this.m_isOptionable = false;
        attrValue = exprElement.getAttribute(ATTR_OPTIONABLE);
        if (attrValue != null) {
            this.m_isOptionable = Boolean.parseBoolean(attrValue);
        }
        this.m_varRestrictions = new VariableRestrictions(exprElement);
    }

    public static String getIdAttributeValue(IConfigurationElement exprElement) throws OdaException {
        String id = exprElement.getAttribute(ATTR_ID);
        if (id == null || id.length() == 0) {
            throw new OdaException(Messages.bind((String)Messages.querySpec_MISSING_EXT_POINT_ATTR_VALUE, (Object[])new Object[]{"org.eclipse.datatools.connectivity.oda.dynamicResultSet", exprElement.getContributor().getName(), ATTR_ID, ELEMENT_NAME}));
        }
        return id;
    }

    public CustomExpression createExpression() throws OdaException {
        return this.createExpression(null, null);
    }

    public CustomExpression createExpression(ExpressionVariable variable, ExpressionArguments args) throws OdaException {
        String className = this.m_exprElement.getAttribute(ATTR_CLASS);
        if (className != null && className.length() > 0) {
            try {
                Object clazz = this.m_exprElement.createExecutableExtension(ATTR_CLASS);
                if (clazz instanceof CustomExpression) {
                    CustomExpression newExpr = (CustomExpression)clazz;
                    newExpr.setVariable(variable);
                    newExpr.setArguments(args);
                    return newExpr;
                }
                throw new OdaException(Messages.bind((String)Messages.querySpec_INVALID_CLASS_TYPE_ATTRIBUTE, (Object[])new Object[]{className, ATTR_CLASS, CustomExpression.class.getName()}));
            }
            catch (CoreException ex) {
                throw new OdaException(ex);
            }
        }
        return new CustomExpression(this.getDeclaringExtensionId(), this.getId(), variable, args);
    }

    public boolean supportsDataSetType(String odaDataSourceId, String odaDataSetId) {
        return this.m_contributorInfo.supportsDataSetType(odaDataSourceId, odaDataSetId);
    }

    public String getDeclaringExtensionId() {
        return this.m_contributorInfo.getDeclaringExtensionId();
    }

    public String getId() {
        return this.m_id;
    }

    public String getDisplayName() {
        if (this.m_name != null && this.m_name.trim().length() > 0) {
            return this.m_name;
        }
        return this.m_id;
    }

    public String getDescription() {
        return this.m_desc;
    }

    public ExtensionContributor getContributor() {
        return this.m_contributorInfo;
    }

    public IValidator getValidator() throws OdaException {
        return this.m_contributorInfo.getValidator();
    }

    public Integer getMinArguments() {
        return this.m_minArgs;
    }

    public boolean supportsUnboundedMaxArguments() {
        return this.getMaxArguments() == null;
    }

    public Integer getMaxArguments() {
        return this.m_maxArgs;
    }

    public boolean isNegatable() {
        return this.m_isNegatable;
    }

    public boolean isOptionable() {
        return this.m_isOptionable;
    }

    public VariableRestrictions getVariableRestrictions() {
        return this.m_varRestrictions;
    }
}

