/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.ddl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinitionRegistry;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.enablement.ase.ISybaseASEDdlConstants;
import org.eclipse.datatools.enablement.ase.SybaseASESQLUtil;
import org.eclipse.datatools.enablement.ase.ddl.ASEDdlUtils;
import org.eclipse.datatools.enablement.ase.ddl.QueryObjectsSQL;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.AccessRuleType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.CacheStrategyType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.DeviceItem;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.LockingSchemaType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEBaseTable;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECatalog;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECatalogType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECheckConstraint;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEColumn;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEColumnCheckConstraint;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDatabase;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDefault;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEIndex;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEPrimaryKey;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEProcedure;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEProxyTable;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASERule;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASESegment;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASETable;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEUniqueConstraint;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEUser;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEUserDefinedType;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEViewTable;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEWebServiceTable;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.PartitionNumInSegments;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.PartitionSegmentPair;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.SybaseASEHashPartition;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.SybaseASEListPartition;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.SybaseASEPartition;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.SybaseASERangePartition;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.partition.SybaseASERoundrobinPartition;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlBuilder;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasePrivilege;
import org.eclipse.datatools.enablement.sybase.parser.QuickSQLParser;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Group;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.User;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.IncrementType;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.MatchType;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.ReferenceConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.routines.Parameter;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.Source;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.IdentitySpecifier;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.PersistentTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.TemporaryTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;

public class SybaseASEDdlBuilder
extends SybaseDdlBuilder
implements ISybaseASEDdlConstants {
    public static final String ASE_PROCEDURE_WITH_TEMP_TABLE_ANNOTATION = "Warning: This annotation was generated by temporary table wizard\\. Do not edit it\\.";
    public static final String ASE_PROCEDURE_WITH_TEMP_TABLE_NAME = "@TemporaryTableName";
    public static final String PATTERN = ".*Warning: This annotation was generated by temporary table wizard\\. Do not edit it\\.[\\r|\\n|\\s]+@TemporaryTableName (#[^\\r\\n]+)(([^-/])*(?=(\\*\\/|--)))";
    private static SybaseDdlBuilder builder;

    protected SybaseASEDdlBuilder() {
    }

    public String dropIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer stmt = new StringBuffer();
        String name = quoteIdentifiers ? String.valueOf(SQLUtil.quote((String)index.getTable().getName(), (String)"\"")) + "." + index.getName() : String.valueOf(index.getTable().getName()) + "." + index.getName();
        String useSetUserStr = SybaseASESQLUtil.getSetNewUserStatement(index.getTable().getSchema());
        stmt.append(useSetUserStr).append(NEWLINE);
        stmt.append("DROP").append(" ").append("INDEX").append(" ").append(name).append(NEWLINE);
        stmt.append(SybaseASESQLUtil.getSetUserDBOStatement(index.getTable().getSchema()));
        String dropStatement = stmt.toString();
        Table table = index.getTable();
        String tableName = this.getName(table, quoteIdentifiers, true);
        String indexName = index.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_INDEX, indexName, tableName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public static SybaseDdlBuilder getInstance() {
        if (builder == null) {
            builder = new SybaseASEDdlBuilder();
        }
        return builder;
    }

    public String[] createCatalogs(Catalog catalog, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        DeviceItem item;
        int i;
        EList devices;
        SybaseASECatalog aseCatalog = (SybaseASECatalog)catalog;
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE ");
        if (aseCatalog.getCatalogType().equals(SybaseASECatalogType.TEMPCATALOG_LITERAL)) {
            statement.append("TEMPORARY ");
        }
        statement.append("DATABASE ");
        String name = this.getName((ENamedElement)aseCatalog, quoteIdentifiers, qualifyNames);
        statement.append(name);
        if (aseCatalog.getDataDevices().size() > 0) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "ON" + " ");
            devices = aseCatalog.getDataDevices();
            i = 0;
            while (i < devices.size()) {
                if (i > 0) {
                    statement.append(String.valueOf(NEWLINE) + "\t" + "," + " ");
                }
                item = (DeviceItem)devices.get(i);
                statement.append(item.getDeviceName());
                statement.append(" = ");
                statement.append(this.getSingleQuotedString(String.valueOf(item.getSize())));
                ++i;
            }
        }
        if (aseCatalog.getLogDevices().size() > 0) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "LOG" + " " + "ON" + " ");
            devices = aseCatalog.getLogDevices();
            i = 0;
            while (i < devices.size()) {
                if (i > 0) {
                    statement.append(String.valueOf(NEWLINE) + "\t" + "," + " ");
                }
                item = (DeviceItem)devices.get(i);
                statement.append(item.getDeviceName());
                statement.append(" = ");
                statement.append(this.getSingleQuotedString(String.valueOf(item.getSize())));
                ++i;
            }
        }
        if (aseCatalog.isOverride()) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "WITH" + " " + "OVERRIDE");
        }
        if (aseCatalog.getDefaultLocation() != null) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "WITH" + " " + "default_location" + " " + "=" + " ");
            statement.append(this.getSingleQuotedString(aseCatalog.getDefaultLocation()));
        }
        if (aseCatalog.isForLoad()) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "FOR" + " " + "LOAD");
        }
        if (aseCatalog.isForLoad()) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "FOR" + " " + "proxy_update");
        }
        String useMaseter = new StringBuffer().append("USE").append(" ").append("master").toString();
        String useDatabase = new StringBuffer().append("USE").append(" ").append(name).toString();
        return new String[]{useMaseter, statement.toString(), useDatabase};
    }

    public String[] createDatabase(Database database, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        return new String[]{""};
    }

    public String[] createUserDefinedType(UserDefinedType udt, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        SybaseASERule aseRule;
        SybaseASEUserDefinedType aseUDT = (SybaseASEUserDefinedType)udt;
        String udtName = "";
        StringBuffer sb_schema = new StringBuffer(128);
        StringBuffer sb_setuser = new StringBuffer(128);
        StringBuffer sb_type = new StringBuffer(128);
        StringBuffer sb_default = new StringBuffer(128);
        StringBuffer sb_rule = new StringBuffer(128);
        sb_schema.append(SybaseASESQLUtil.getSetNewUserStatement(aseUDT.getSchema()));
        sb_setuser.append(SybaseASESQLUtil.getSetUserDBOStatement(aseUDT.getSchema()));
        sb_type.append("EXEC").append(" ").append("sp_addtype").append(" ");
        if (!quoteIdentifiers) {
            udtName = SQLUtil.quote((String)aseUDT.getName(), (String)"'");
        } else {
            udtName = SQLDevToolsUtil.quoteWhenNecessary((String)aseUDT.getName(), (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)aseUDT));
            if (udtName.equals(aseUDT.getName()) && !aseUDT.getName().startsWith("\"") && !aseUDT.getName().endsWith("\"")) {
                udtName = SQLUtil.quote((String)aseUDT.getName(), (String)"'");
            }
        }
        sb_type.append(udtName).append(",");
        DatabaseDefinitionRegistry dbRegistry = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry();
        DatabaseDefinition definition = dbRegistry.getDefinition((Database)ContainmentServiceImpl.INSTANCE.getRootElement((EObject)aseUDT));
        PredefinedDataType pdt = aseUDT.getPredefinedRepresentation();
        sb_type.append(this.getSingleQuotedString(definition.getPredefinedDataTypeFormattedName(pdt)));
        sb_type.append(",");
        if (aseUDT.isIdentity()) {
            sb_type.append(this.getSingleQuotedString("IDENTITY"));
        } else if (aseUDT.isAllowNulls()) {
            sb_type.append("NULL");
        } else {
            sb_type.append("NO").append("NULL");
        }
        SybaseASEDefault aseDefault = aseUDT.getBoundDefault();
        if (aseDefault != null) {
            sb_default.append("EXEC").append(" ").append("sp_bindefault").append(" ").append(SQLUtil.quote((String)this.getName(aseDefault, quoteIdentifiers, true), (String)"'")).append(",").append(udtName);
            if (aseUDT.isBindDefaultInFutureOnly()) {
                sb_default.append(",").append("futureonly");
            }
        }
        if ((aseRule = aseUDT.getBoundRule()) != null) {
            sb_rule.append("EXEC").append(" ").append("sp_bindrule").append(" ").append(SQLUtil.quote((String)this.getName(aseRule, quoteIdentifiers, true), (String)"'")).append(",").append(udtName);
            if (aseUDT.isBindRuleInFutureOnly()) {
                sb_rule.append(",").append("futureonly");
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!sb_schema.toString().equals("")) {
            result.add(sb_schema.toString());
        }
        result.add(sb_type.toString());
        if (aseDefault != null) {
            result.add(sb_default.toString());
        }
        if (aseRule != null) {
            result.add(sb_rule.toString());
        }
        if (!sb_setuser.toString().trim().equals("")) {
            result.add(sb_setuser.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] createDefault(SybaseASEDefault aseDefault, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(" ").append("DEFAULT").append(" ").append(this.getName(aseDefault, quoteIdentifiers, qualifyNames)).append(" ").append("AS").append(" ");
        String statement = aseDefault.getStatement();
        if (statement != null && !statement.trim().equals("")) {
            sb.append(statement);
        }
        return new String[]{sb.toString()};
    }

    public String[] createRule(SybaseASERule aseRule, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(" ");
        if (aseRule.isAccessRule()) {
            AccessRuleType accessRuleType = aseRule.getAccessType();
            if (accessRuleType.getValue() == 1) {
                sb.append("AND").append(" ");
            } else if (accessRuleType.getValue() == 2) {
                sb.append("OR").append(" ");
            }
            sb.append("ACCESS").append(" ");
        }
        sb.append("RULE").append(" ").append(this.getName(aseRule, quoteIdentifiers, qualifyNames)).append(" ").append("AS").append(" ");
        String statement = aseRule.getStatement();
        if (statement != null && !statement.trim().equals("")) {
            sb.append(NEWLINE).append(statement);
        }
        return new String[]{sb.toString()};
    }

    public String[] createProcedureBody(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        SybaseASEProcedure proc = (SybaseASEProcedure)procedure;
        Source source = procedure.getSource();
        String body = "";
        if (source != null && source.getBody() != null) {
            body = source.getBody();
        }
        if (QuickSQLParser.getInstance().match(body, 1)) {
            return new String[]{body};
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(" ").append("PROCEDURE").append(" ").append(this.getName(procedure, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        String param = this.getTSQLParameters((Routine)procedure);
        if (param != null && param.length() > 0) {
            sb.append("(").append(param).append(")").append(NEWLINE);
        }
        if (proc.isWithRecompile()) {
            sb.append("WITH RECOMPILE").append(NEWLINE);
        }
        if (proc.getExternalName() != null && proc.getExternalName().trim().length() > 0) {
            if (proc.getSqlDataAccess().getValue() == 3) {
                sb.append(this.getSQLAccess((Routine)proc));
            }
            if (proc.getMaxResultSets() > 0) {
                sb.append("\t").append("DYNAMIC RESULT SETS").append(" ").append(proc.getMaxResultSets()).append(NEWLINE);
            }
            sb.append("\t").append(this.getDeterministic((Routine)proc));
            sb.append(this.getLanguage((Routine)proc));
            sb.append(this.getParameterStyleOption((Routine)proc));
            sb.append(this.getExternalName((Routine)proc));
        } else {
            sb.append("AS").append(NEWLINE).append(body);
        }
        return new String[]{sb.toString()};
    }

    public String[] createProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String body = this.createProcedureBody(procedure, quoteIdentifiers, qualifyNames, fullSyntax)[0];
        return this.createProcedureObject(body, quoteIdentifiers, qualifyNames, fullSyntax);
    }

    public String[] createProcedureObject(String body, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        Pattern pattern = Pattern.compile(PATTERN);
        Matcher matcher = pattern.matcher(body);
        ArrayList<String> tempTableNames = new ArrayList<String>();
        ArrayList<String> createTempTable = new ArrayList<String>();
        while (matcher.find()) {
            tempTableNames.add(matcher.group(1).trim());
            createTempTable.add(matcher.group(2).trim());
        }
        String[] createTempTableStatements = new String[tempTableNames.size()];
        int i = 0;
        while (i < tempTableNames.size()) {
            createTempTableStatements[i] = (String)createTempTable.get(i);
            ++i;
        }
        String[] dropTempTableStatements = new String[tempTableNames.size()];
        int i2 = 0;
        while (i2 < tempTableNames.size()) {
            String tempTableName = (String)tempTableNames.get(i2);
            dropTempTableStatements[i2] = "DROP TABLE " + tempTableName;
            ++i2;
        }
        String[] results = new String[createTempTableStatements.length * 2 + 1];
        System.arraycopy(createTempTableStatements, 0, results, 0, createTempTableStatements.length);
        results[createTempTableStatements.length] = body;
        System.arraycopy(dropTempTableStatements, 0, results, createTempTableStatements.length + 1, dropTempTableStatements.length);
        return results;
    }

    public String[] createUserDefinedFunction(UserDefinedFunction function, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        Source source = function.getSource();
        String body = "";
        if (source != null && source.getBody() != null) {
            body = source.getBody();
        }
        if (QuickSQLParser.getInstance().match(body, 2)) {
            return new String[]{body};
        }
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(" ").append("FUNCTION").append(" ").append(this.getName(function, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        String param = this.getTSQLParameters((Routine)function);
        if (param != null && param.length() > 0) {
            sb.append("(").append(param).append(")").append(NEWLINE);
        }
        sb.append(this.getFunctionReturnsClause(function));
        if (fullSyntax) {
            sb.append(this.getSQLAccess((Routine)function));
        }
        if (function.isNullCall()) {
            sb.append("RETURNS NULL ON NULL INPUT");
        } else {
            sb.append("CALLED ON NULL INPUT");
        }
        sb.append("\t").append(this.getDeterministic((Routine)function));
        sb.append(this.getLanguage((Routine)function));
        sb.append(this.getParameterStyleOption((Routine)function));
        sb.append(this.getExternalName((Routine)function));
        return new String[]{sb.toString()};
    }

    public String[] createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String body = this.createTSQLTrigger(trigger, quoteIdentifiers, qualifyNames);
        return this.createProcedureObject(body, quoteIdentifiers, qualifyNames, fullSyntax);
    }

    public String[] createEvent(Event event, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        return new String[0];
    }

    protected String[] createPersistentTable(PersistentTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (table instanceof SybaseASEProxyTable) {
            return this.createProxyTable((SybaseASEProxyTable)table, quoteIdentifiers, qualifyNames, fullSyntax);
        }
        if (table instanceof SybaseASETable) {
            return this.createBaseTable((BaseTable)table, quoteIdentifiers, qualifyNames, fullSyntax);
        }
        throw new UnsupportedOperationException();
    }

    protected String[] createTempoeryTable(TemporaryTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        return this.createBaseTable((BaseTable)table, quoteIdentifiers, qualifyNames, fullSyntax);
    }

    protected String[] createBaseTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        ArrayList<CharSequence> stmts = new ArrayList<CharSequence>();
        String setUserStr = "";
        Schema creator = table.getSchema();
        if (creator != null) {
            setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
        }
        if (!setUserStr.equals("")) {
            stmts.add(setUserStr);
        }
        StringBuffer ddl = new StringBuffer();
        ddl.append("CREATE").append(" ").append("TABLE").append(" ").append(this.getName((Table)table, quoteIdentifiers, qualifyNames)).append(" ").append("(").append(NEWLINE);
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            ddl.append("\t").append("\t").append(this.getColumnString(column, quoteIdentifiers));
            if (it.hasNext()) {
                ddl.append(",");
            }
            ddl.append(NEWLINE);
        }
        ddl.append("\t").append(")").append(NEWLINE);
        String lockSchema = this.getLockSchemaStatement(table);
        String withClause = this.getWithClause(table);
        String segmentStmt = this.getSegmentStatement(table, quoteIdentifiers);
        String partitionStmt = this.getPartitionStatement(table, quoteIdentifiers);
        if (lockSchema != null) {
            ddl.append(lockSchema).append(" ").append(NEWLINE);
        }
        if (withClause != null) {
            ddl.append(withClause).append(" ").append(NEWLINE);
        }
        if (segmentStmt != null) {
            ddl.append(segmentStmt).append(" ").append(NEWLINE);
        }
        if (partitionStmt != null) {
            ddl.append(partitionStmt).append(" ").append(NEWLINE);
        }
        stmts.add(ddl);
        List cacheInfoStmt = this.getCacheInfoStmt(table, quoteIdentifiers, qualifyNames, true);
        stmts.addAll(cacheInfoStmt);
        List ruleBindingStmt = this.getRuleBindingStmt(table, quoteIdentifiers, qualifyNames, false);
        stmts.addAll(ruleBindingStmt);
        List defaultBindingStmt = this.getDefaultBindingStmt(table, quoteIdentifiers, qualifyNames, false);
        stmts.addAll(defaultBindingStmt);
        String setUserDbo = SybaseASESQLUtil.getSetUserDBOStatement(creator);
        if (!setUserDbo.equals("")) {
            stmts.add(setUserDbo);
        }
        String[] result = new String[stmts.size()];
        int i = 0;
        while (i < stmts.size()) {
            result[i] = stmts.get(i).toString();
            ++i;
        }
        return result;
    }

    private List getDefaultBindingStmt(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        SybaseASETable sybTable = (SybaseASETable)table;
        EList columns = sybTable.getColumns();
        ArrayList<StringBuffer> stmts = new ArrayList<StringBuffer>();
        int i = 0;
        while (i < columns.size()) {
            SybaseASEColumn col = (SybaseASEColumn)columns.get(i);
            if (col.getBoundDefault() != null) {
                StringBuffer stmt = new StringBuffer();
                stmt.append("EXEC").append(" ").append("sp_bindefault").append(" ").append(SQLUtil.quote((String)this.getName(col.getBoundDefault(), false, true), (String)"'")).append(",").append(SQLUtil.quote((String)(String.valueOf(col.getTable().getName()) + "." + col.getName()), (String)"'"));
                stmts.add(stmt);
            }
            ++i;
        }
        return stmts;
    }

    public List getRuleBindingStmt(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        SybaseASETable sybTable = (SybaseASETable)table;
        EList columns = sybTable.getColumns();
        ArrayList<StringBuffer> stmts = new ArrayList<StringBuffer>();
        int i = 0;
        while (i < columns.size()) {
            SybaseASEColumn col = (SybaseASEColumn)columns.get(i);
            if (col.getBoundRule() != null) {
                StringBuffer stmt = new StringBuffer();
                stmt.append("EXEC").append(" ").append("sp_bindrule").append(" ").append(SQLUtil.quote((String)this.getName(col.getBoundRule(), false, true), (String)"'")).append(",").append(SQLUtil.quote((String)(String.valueOf(col.getTable().getName()) + "." + col.getName()), (String)"'"));
                stmts.add(stmt);
            }
            ++i;
        }
        return stmts;
    }

    private List getCacheInfoStmt(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        ArrayList<StringBuffer> stmts = new ArrayList<StringBuffer>();
        SybaseASECatalog catalog = (SybaseASECatalog)table.getSchema().getCatalog();
        SybaseASETable aseTable = (SybaseASETable)table;
        if (aseTable.getTableOnlyCacheInfo() == null) {
            return stmts;
        }
        int strategy = aseTable.getTableOnlyCacheInfo().getCacheStrategy();
        StringBuffer prefetchOnStmt = null;
        prefetchOnStmt = new StringBuffer();
        prefetchOnStmt.append("EXEC").append(" ").append("sp_cachestrategy").append(" ").append(SQLUtil.quote((String)catalog.getName(), (String)"'")).append(",").append(SQLUtil.quote((String)(String.valueOf(table.getSchema().getName()) + "." + table.getName()), (String)"'")).append(",").append(SQLUtil.quote((String)"table only", (String)"'")).append(",").append(CacheStrategyType.PREFETCH_LITERAL).append(",").append(SQLUtil.quote((String)"ON", (String)"'"));
        StringBuffer mruOffStmt = new StringBuffer();
        mruOffStmt.append("EXEC").append(" ").append("sp_cachestrategy").append(" ").append(SQLUtil.quote((String)catalog.getName(), (String)"'")).append(",").append(SQLUtil.quote((String)(String.valueOf(table.getSchema().getName()) + "." + table.getName()), (String)"'")).append(",").append(SQLUtil.quote((String)"table only", (String)"'")).append(",").append(CacheStrategyType.MRU_LITERAL).append(",").append(SQLUtil.quote((String)"off", (String)"'"));
        StringBuffer prefetchOffStmt = new StringBuffer();
        prefetchOffStmt.append("EXEC").append(" ").append("sp_cachestrategy").append(" ").append(SQLUtil.quote((String)catalog.getName(), (String)"'")).append(",").append(SQLUtil.quote((String)(String.valueOf(table.getSchema().getName()) + "." + table.getName()), (String)"'")).append(",").append(SQLUtil.quote((String)"table only", (String)"'")).append(",").append(CacheStrategyType.PREFETCH_LITERAL).append(",").append(SQLUtil.quote((String)"off", (String)"'"));
        StringBuffer mruOnStmt = null;
        mruOnStmt = new StringBuffer();
        mruOnStmt.append("EXEC").append(" ").append("sp_cachestrategy").append(" ").append(SQLUtil.quote((String)catalog.getName(), (String)"'")).append(",").append(SQLUtil.quote((String)(String.valueOf(table.getSchema().getName()) + "." + table.getName()), (String)"'")).append(",").append(SQLUtil.quote((String)"table only", (String)"'")).append(",").append(CacheStrategyType.MRU_LITERAL).append(",").append(SQLUtil.quote((String)"ON", (String)"'"));
        if ((strategy & 2) != 0) {
            stmts.add(mruOnStmt);
        } else if ((strategy & 4) == 0) {
            stmts.add(mruOffStmt);
        }
        if ((strategy & 1) != 0) {
            stmts.add(prefetchOnStmt);
        } else if ((strategy & 8) == 0) {
            stmts.add(prefetchOffStmt);
        }
        return stmts;
    }

    public String[] grantPrivilege(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String[] stat = super.grantPrivilege(privilege, quoteIdentifiers, qualifyNames, fullSyntax);
        if (stat == null || stat.length == 0) {
            return new String[]{""};
        }
        StringBuffer sb = new StringBuffer(stat[0]);
        if (privilege.isGrantable()) {
            sb.append(" ").append("WITH GRANT OPTION");
        }
        if (privilege instanceof SybasePrivilege && ((SybasePrivilege)privilege).isRevoked()) {
            String stmt = super.revokePrivilege(privilege, quoteIdentifiers, qualifyNames);
            sb = new StringBuffer(stmt);
        }
        return new String[]{sb.toString()};
    }

    public String revokePrivilege(Privilege privilege, boolean quoteIdentifiers, boolean qualifyNames) {
        if (privilege instanceof SybasePrivilege && ((SybasePrivilege)privilege).isRevoked()) {
            ((SybasePrivilege)privilege).setRevoked(false);
            return this.grantPrivilege(privilege, quoteIdentifiers, qualifyNames, true)[0];
        }
        return super.revokePrivilege(privilege, quoteIdentifiers, qualifyNames);
    }

    public String[] addUniqueConstraint(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        SybaseASEIndex index;
        if (constraint == null) {
            return null;
        }
        SybaseASEUniqueConstraint uniqueConstraint = null;
        if (constraint instanceof PrimaryKey) {
            uniqueConstraint = ((SybaseASEPrimaryKey)constraint).getAseUniqueConstraint();
            if (uniqueConstraint == null) {
                return null;
            }
        } else {
            uniqueConstraint = (SybaseASEUniqueConstraint)constraint;
        }
        if ((index = uniqueConstraint.getSystemGenedIndex()) == null) {
            return null;
        }
        StringBuffer statement = new StringBuffer(128);
        statement.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames)).append(" ");
        statement.append(NEWLINE).append("\t").append("ADD").append(" ");
        statement.append(this.getAddUniqueConstraintClause(constraint, index, quoteIdentifiers));
        String sql1 = statement.toString();
        statement = new StringBuffer(128);
        if (index.getFillFactor() > 0) {
            String objectName = String.valueOf(constraint.getBaseTable().getName()) + "." + constraint.getName();
            statement.append("EXEC").append(" ").append("sp_chgattribute").append(" ").append(this.getSingleQuotedString(objectName)).append(",").append(this.getSingleQuotedString("fillfactor")).append(",").append(index.getFillFactor());
            String sql2 = statement.toString();
            Schema creator = constraint.getBaseTable().getSchema();
            String setUserStr = "";
            if (creator != null) {
                setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
            }
            String setUserDbo = SybaseASESQLUtil.getSetUserDBOStatement(creator);
            if (!setUserStr.equals("")) {
                return new String[]{sql1, setUserStr, sql2, setUserDbo};
            }
            return new String[]{sql1, sql2};
        }
        return new String[]{sql1};
    }

    public String[] addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        boolean catalogNameQuoted;
        if (foreignKey == null) {
            return null;
        }
        UniqueConstraint uniqueConstraint = foreignKey.getUniqueConstraint();
        SybaseASEPrimaryKey primKey = null;
        Index index = foreignKey.getUniqueIndex();
        if (index == null) {
            if (uniqueConstraint instanceof PrimaryKey) {
                primKey = (SybaseASEPrimaryKey)uniqueConstraint;
                uniqueConstraint = ((SybaseASEPrimaryKey)uniqueConstraint).getAseUniqueConstraint();
            } else {
                uniqueConstraint = (SybaseASEUniqueConstraint)uniqueConstraint;
            }
            if (uniqueConstraint == null) {
                return null;
            }
            index = ((SybaseASEUniqueConstraint)uniqueConstraint).getSystemGenedIndex();
        }
        BaseTable parentTable = null;
        String parentKey = null;
        if (primKey != null) {
            parentTable = primKey.getBaseTable();
            parentKey = super.getKeyColumns((ReferenceConstraint)primKey, quoteIdentifiers);
        } else if (uniqueConstraint != null) {
            parentTable = uniqueConstraint.getBaseTable();
            parentKey = super.getKeyColumns((ReferenceConstraint)uniqueConstraint, quoteIdentifiers);
        } else if (index != null) {
            parentKey = super.getParentKeyColumns(index, quoteIdentifiers);
        }
        if (parentTable == null) {
            return null;
        }
        Catalog catalog = foreignKey.getBaseTable().getSchema().getCatalog();
        String catalogName = this.getName((ENamedElement)catalog, quoteIdentifiers, qualifyNames);
        Catalog parentCatalog = parentTable.getSchema().getCatalog();
        String parentCatalogName = this.getName((ENamedElement)parentCatalog, quoteIdentifiers, qualifyNames);
        String tableName = null;
        String parentTableName = null;
        boolean bl = catalogNameQuoted = !catalogName.equals(catalog.getName());
        if (quoteIdentifiers) {
            if (catalogNameQuoted) {
                tableName = String.valueOf(SQLDevToolsUtil.quoteWhenNecessary((String)foreignKey.getBaseTable().getSchema().getName(), (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)foreignKey.getBaseTable()))) + "." + SQLUtil.quote((String)foreignKey.getBaseTable().getName(), (String)"\"");
                parentTableName = String.valueOf(SQLDevToolsUtil.quoteWhenNecessary((String)parentTable.getSchema().getName(), (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)parentTable))) + "." + SQLUtil.quote((String)parentTable.getName(), (String)"\"");
            } else {
                tableName = this.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames);
                parentTableName = this.getName((Table)parentTable, quoteIdentifiers, qualifyNames);
            }
        } else {
            tableName = this.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames);
            parentTableName = this.getName((Table)parentTable, quoteIdentifiers, qualifyNames);
        }
        if (catalog != parentCatalog) {
            parentTableName = qualifyNames ? String.valueOf(parentCatalogName) + "." + parentTableName : String.valueOf(parentCatalogName) + "." + "." + parentTableName;
        }
        StringBuffer statement = new StringBuffer(128);
        statement.append("ALTER").append(" ").append("TABLE").append(" ").append(tableName).append(" ").append("ADD").append(" ");
        String name = foreignKey.getName();
        if (name != null && name.trim().length() != 0) {
            if (quoteIdentifiers) {
                name = super.getDoubleQuotedString(name);
            }
            statement.append("CONSTRAINT").append(" ").append(name).append(" ");
        }
        statement.append("FOREIGN KEY").append(" ").append("(").append(this.getKeyColumns((ReferenceConstraint)foreignKey, quoteIdentifiers)).append(")").append(NEWLINE);
        statement.append("\t").append("REFERENCES").append(" ").append(parentTableName).append(" ").append("(").append(parentKey).append(")");
        statement.append(this.getFKMatchType(foreignKey));
        return new String[]{statement.toString()};
    }

    public String[] createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String setUserDbo;
        String setNewUserStr;
        SybaseASEIndex aseIndex = (SybaseASEIndex)index;
        ArrayList<String> statements = new ArrayList<String>();
        StringBuffer statement = new StringBuffer();
        statement.append("CREATE ");
        EClass clazz = index.eClass();
        if (index.eIsSet(clazz.getEStructuralFeature(10)) && index.isUnique()) {
            statement.append("UNIQUE ");
        }
        if (index.eIsSet(clazz.getEStructuralFeature(8))) {
            if (index.isClustered()) {
                statement.append("CLUSTERED ");
            } else {
                statement.append("NONCLUSTERED ");
            }
        }
        statement.append("INDEX " + this.getName(index, quoteIdentifiers, qualifyNames) + " " + "ON" + " " + this.getName(index.getTable(), quoteIdentifiers, qualifyNames) + " " + "(" + this.getIndexKeyColumns(index, quoteIdentifiers) + ")");
        boolean needComma = false;
        if (aseIndex.getFillFactor() > 0) {
            this.addComma(needComma, statement);
            statement.append(String.valueOf(this.getIndexWithClause(needComma)) + "fillfactor" + " " + "=" + " " + aseIndex.getFillFactor());
            needComma = true;
        }
        if (aseIndex.getMaxRowPerPage() >= 0) {
            this.addComma(needComma, statement);
            statement.append(String.valueOf(this.getIndexWithClause(needComma)) + "max_rows_per_page" + " " + "=" + " " + aseIndex.getMaxRowPerPage());
            needComma = true;
        }
        if (aseIndex.getReversePageGap() >= 0) {
            this.addComma(needComma, statement);
            statement.append(String.valueOf(this.getIndexWithClause(needComma)) + "reservepagegap" + " " + "=" + " " + aseIndex.getReversePageGap());
            needComma = true;
        }
        if (aseIndex.getConsumerNum() >= 0) {
            this.addComma(needComma, statement);
            statement.append(String.valueOf(this.getIndexWithClause(needComma)) + "consumers" + " " + "=" + " " + aseIndex.getConsumerNum());
            needComma = true;
        }
        if (aseIndex.eIsSet(clazz.getEStructuralFeature(18)) && aseIndex.isIgnoreDuplicateKey() && aseIndex.isUnique()) {
            this.addComma(needComma, statement);
            statement.append(String.valueOf(this.getIndexWithClause(needComma)) + "ignore_dup_key");
            needComma = true;
        }
        if (aseIndex.eIsSet(clazz.getEStructuralFeature(19)) && aseIndex.isSortedData()) {
            this.addComma(needComma, statement);
            statement.append(String.valueOf(this.getIndexWithClause(needComma)) + "sorted_data");
            needComma = true;
        }
        if (aseIndex.eIsSet(clazz.getEStructuralFeature(20)) && aseIndex.isIgnoreDuplicateRow() && aseIndex.isClustered()) {
            this.addComma(needComma, statement);
            statement.append(String.valueOf(this.getIndexWithClause(needComma)) + "ignore_dup_row");
            needComma = true;
        }
        if (aseIndex.eIsSet(clazz.getEStructuralFeature(26)) && aseIndex.isAllowDuplicateRow() && aseIndex.isClustered()) {
            this.addComma(needComma, statement);
            statement.append(String.valueOf(this.getIndexWithClause(needComma)) + "allow_dup_row");
            needComma = true;
        }
        if (aseIndex.getStatisticsStep() >= 0) {
            this.addComma(needComma, statement);
            statement.append(String.valueOf(this.getIndexWithClause(needComma)) + "statistics using" + " " + aseIndex.getStatisticsStep() + " " + "VALUES".toLowerCase());
            needComma = true;
        }
        if (aseIndex.eIsSet(clazz.getEStructuralFeature(21)) && aseIndex.getSegment() != null) {
            statement.append(String.valueOf(NEWLINE) + "\t" + "ON" + " " + this.getSingleQuotedString(aseIndex.getSegment().getName()));
        }
        if (aseIndex.eIsSet(clazz.getEStructuralFeature(23)) && aseIndex.getPartitions().size() > 0) {
            statement.append(String.valueOf(NEWLINE) + "\t");
            if (aseIndex.isLocalIndex()) {
                statement.append("LOCAL INDEX ");
            }
            statement.append(ASEDdlUtils.getPartitionName(aseIndex, quoteIdentifiers, qualifyNames));
        }
        statements.add(statement.toString());
        String[] cacheStatments = ASEDdlUtils.getAllCacheStatement(aseIndex, qualifyNames, fullSyntax, this.getDatabaseIdentifier((EObject)aseIndex));
        if (!(cacheStatments.length <= 0 && aseIndex.getFillFactor() <= 0 || (setNewUserStr = SybaseASESQLUtil.getSetNewUserStatement(index.getTable().getSchema())).equals(""))) {
            statements.add(setNewUserStr);
        }
        int j = 0;
        while (j < cacheStatments.length) {
            statements.add(cacheStatments[j]);
            ++j;
        }
        String indexNameWithTableName = String.valueOf(index.getTable().getName()) + "." + index.getName();
        if (quoteIdentifiers) {
            indexNameWithTableName = String.valueOf(index.getTable().getName()) + "." + SQLDevToolsUtil.quoteWhenNecessary((String)index.getName(), (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)index));
        }
        if (aseIndex.getFillFactor() > 0) {
            statements.add(ASEDdlUtils.getChangeAttributeStatement(this.getSingleQuotedString(indexNameWithTableName), this.getSingleQuotedString("fillfactor"), String.valueOf(aseIndex.getFillFactor())));
        }
        if (!(cacheStatments.length <= 0 && aseIndex.getFillFactor() <= 0 || (setUserDbo = SybaseASESQLUtil.getSetUserDBOStatement(index.getTable().getSchema())).equals(""))) {
            statements.add(setUserDbo);
        }
        return statements.toArray(new String[statements.size()]);
    }

    public String[] createView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (!(view instanceof SybaseASEViewTable)) {
            return null;
        }
        StringBuffer viewDefinition = new StringBuffer("");
        viewDefinition.append("CREATE").append(" ").append("VIEW").append(" ").append(this.getName((Table)view, quoteIdentifiers, qualifyNames)).append(" ");
        String columns = this.getViewColumnList(view, quoteIdentifiers);
        if (columns != null) {
            viewDefinition.append("(").append(columns).append(")").append(" ");
        }
        viewDefinition.append("AS").append(NEWLINE);
        viewDefinition.append(view.getQueryExpression().getSQL());
        if (((SybaseASEViewTable)view).isWithCheckOption()) {
            viewDefinition.append(NEWLINE).append("WITH CHECK OPTION");
        }
        return new String[]{viewDefinition.toString()};
    }

    protected String[] createProxyTable(SybaseASEProxyTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (table.isExisting()) {
            return this.createExistingProxyTable(table, quoteIdentifiers, qualifyNames, fullSyntax);
        }
        return this.createNonExistingTable(table, quoteIdentifiers, qualifyNames, fullSyntax);
    }

    public String[] createWebServiceTable(SybaseASEWebServiceTable ws, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer methodClause = new StringBuffer("");
        if (ws.getName() != null && ws.getMethod() != null) {
            methodClause.append("'").append(ws.getMethod()).append("=").append(this.getName((Table)ws, quoteIdentifiers, qualifyNames)).append("'");
        }
        StringBuffer stmt = new StringBuffer();
        stmt.append("sp_webservices").append(" ").append("'").append("ADD").append("'").append(",").append("'").append(ws.getExternalPath()).append("'").append(",").append(NEWLINE).append(methodClause);
        return new String[]{stmt.toString()};
    }

    public String dropWebServiceTable(SybaseASEWebServiceTable ws, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer result = new StringBuffer();
        result.append("sp_webservices").append(" ").append("'").append("REMOVE").append("'").append(",").append("'").append(ws.getExternalPath()).append("'");
        return result.toString();
    }

    public String dropCatalog(Catalog db, boolean quoteIdentifiers, boolean qualifyNames) {
        String useMaseter = new StringBuffer().append("USE").append(" ").append("master").toString();
        String dropStatement = String.valueOf(useMaseter) + NEWLINE + "\t" + super.dropCatalog(db, quoteIdentifiers, qualifyNames);
        String dbName = db.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_CATALOG, dbName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropProcedure(Procedure procedure, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = super.dropProcedure(procedure, quoteIdentifiers, qualifyNames);
        String ownerName = procedure.getSchema().getName();
        String procName = procedure.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_PROCEDURE, ownerName, procName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropUserDefinedType(UserDefinedType udt, boolean quoteIdentifiers, boolean qualifyNames) {
        SybaseASEUserDefinedType aseUDT = (SybaseASEUserDefinedType)udt;
        StringBuffer sb = new StringBuffer(128);
        sb.append("EXEC").append(" ").append("sp_droptype").append(" ").append(SQLUtil.quote((String)aseUDT.getName(), (String)"'"));
        String dropStatement = sb.toString();
        String udtName = udt.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_UDT, udtName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropDefault(SybaseASEDefault aseDefault, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("DROP").append(" ").append("DEFAULT").append(" ").append(this.getName(aseDefault, quoteIdentifiers, qualifyNames)).toString();
        String dropStatement = sb.toString();
        String ownerName = aseDefault.getSchema().getName();
        String defaultName = aseDefault.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_DEFAULT, ownerName, defaultName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropRule(SybaseASERule aseRule, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(128);
        sb.append("DROP").append(" ").append("RULE").append(" ").append(this.getName(aseRule, quoteIdentifiers, qualifyNames)).toString();
        String dropStatement = sb.toString();
        String ownerName = aseRule.getSchema().getName();
        String ruleName = aseRule.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_RULE, ownerName, ruleName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = super.dropTrigger(trigger, quoteIdentifiers, qualifyNames);
        String creatorName = trigger.getSchema().getName();
        String triggerName = trigger.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_TRIGGER, creatorName, triggerName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = super.dropTable(table, quoteIdentifiers, qualifyNames);
        if (table instanceof SybaseASEProxyTable) {
            StringBuffer sb = new StringBuffer();
            sb.append(dropStatement).append(NEWLINE).append(this.dropObjectdef((SybaseASEProxyTable)table, quoteIdentifiers));
            dropStatement = sb.toString();
        }
        String ownerName = table.getSchema().getName();
        String tableName = table.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_TABLE, ownerName, tableName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    private String dropObjectdef(SybaseASEProxyTable table, boolean quoteIdentifiers) {
        StringBuffer sb = new StringBuffer();
        String setUserStr = "";
        Schema creator = table.getSchema();
        if (creator != null) {
            setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
        }
        if (!setUserStr.equals("")) {
            sb.append(setUserStr).append(NEWLINE);
        }
        sb.append("\t").append("EXEC").append(" ").append("sp_dropobjectdef").append(" ").append(this.getName((Table)table, quoteIdentifiers, false));
        String setUserDbo = SybaseASESQLUtil.getSetUserDBOStatement(creator);
        if (!setUserDbo.equals("")) {
            sb.append(NEWLINE).append("\t").append(setUserDbo);
        }
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_OBJECT_DEF, table.getName());
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, sb.toString());
    }

    public String dropView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = super.dropView(view, quoteIdentifiers, qualifyNames);
        String ownerName = view.getSchema().getName();
        String viewName = view.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_VIEW, ownerName, viewName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers) {
        SybaseASEColumnCheckConstraint checkConstraint;
        StringBuffer columnDefinition = new StringBuffer();
        SybaseASEColumn aseColumn = (SybaseASEColumn)column;
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        columnDefinition.append(columnName).append(" ");
        ValueExpression v = column.getGenerateExpression();
        if (aseColumn.isComputedColumn() && v != null) {
            columnDefinition.append(" ").append("AS").append(" ").append(v.getSQL()).append(" ");
            if (aseColumn.isMaterialized()) {
                columnDefinition.append("MATERIALIZED").append(" ");
            } else {
                columnDefinition.append("NOT").append(" ").append("MATERIALIZED").append(" ");
            }
        }
        if (!aseColumn.isComputedColumn()) {
            IdentitySpecifier spec;
            columnDefinition.append(this.getDataTypeString((TypedElement)column, column.getTable().getSchema())).append(" ");
            String defaultValue = column.getDefaultValue();
            if (defaultValue != null && aseColumn.getBoundDefault() == null) {
                columnDefinition.append("DEFAULT").append(" ").append(defaultValue);
            }
            if ((spec = column.getIdentitySpecifier()) != null) {
                columnDefinition.append(" ").append("IDENTITY").append(" ");
            } else if (!column.isNullable()) {
                columnDefinition.append(" ").append("NOT").append(" ").append("NULL");
            } else {
                columnDefinition.append(" ").append("NULL");
            }
        }
        if ((checkConstraint = aseColumn.getColumnCheck()) != null) {
            columnDefinition.append(" ").append(this.getAddCheckConstraintClause((CheckConstraint)checkConstraint, quoteIdentifiers)).append(" ");
        }
        return columnDefinition.toString();
    }

    protected String getIdentityString(IdentitySpecifier identitySpecifier) {
        String clause = "START WITH " + identitySpecifier.getStartValue() + " ,INCREMENT BY " + identitySpecifier.getIncrement();
        return clause;
    }

    protected String getParameterStyleOption(Routine routine) {
        StringBuffer sb = new StringBuffer();
        return sb.append("\t").append("PARAMETER STYLE").append(" ").append("JAVA").append(NEWLINE).toString();
    }

    protected String getLanguage(Routine routine) {
        StringBuffer sb = new StringBuffer();
        return sb.append("\t").append("LANGUAGE").append(" ").append("JAVA").append(NEWLINE).toString();
    }

    protected String getSQLAccess(Routine routine) {
        StringBuffer sb = new StringBuffer();
        return sb.append("\t").append("MODIFIES SQL DATA").append(NEWLINE).toString();
    }

    protected String getExternalName(Routine routine) {
        StringBuffer sb = new StringBuffer();
        return sb.append("\t").append("EXTERNAL NAME").append(" ").append(routine.getExternalName()).append(NEWLINE).toString();
    }

    protected String getFunctionReturnsClause(UserDefinedFunction function) {
        if (function.getReturnScalar() != null) {
            Parameter scaler = function.getReturnScalar();
            StringBuffer sb = new StringBuffer();
            sb.append("RETURNS").append(" ").append(this.getDataTypeString((TypedElement)scaler, function.getSchema())).append(NEWLINE);
            return sb.toString();
        }
        return "";
    }

    protected String getLockSchemaStatement(BaseTable table) {
        SybaseASEBaseTable aseTable = (SybaseASEBaseTable)table;
        LockingSchemaType schemaType = aseTable.getLockSchema();
        if (schemaType == null) {
            return null;
        }
        switch (schemaType.getValue()) {
            case 2: {
                return "LOCK allpages";
            }
            case 1: {
                return "LOCK datapages";
            }
            case 0: {
                return "LOCK datarows";
            }
        }
        return null;
    }

    protected String getWithClause(BaseTable table) {
        SybaseASEBaseTable aseTable = (SybaseASEBaseTable)table;
        int maxRowPerPage = aseTable.getMaxRowPerPage();
        int expRowSize = aseTable.getExpRowSize();
        int reservePageGap = aseTable.getReservePageGap();
        int identityGap = aseTable.getIdentityGap();
        if (maxRowPerPage < 0 && expRowSize < 0 && reservePageGap < 0 && identityGap < 0) {
            return null;
        }
        StringBuffer with = new StringBuffer();
        boolean start = true;
        if (maxRowPerPage >= 0) {
            with.append("WITH").append(" ").append("max_rows_per_page").append("=").append(maxRowPerPage);
            start = false;
        }
        if (expRowSize >= 0) {
            if (start) {
                with.append("WITH").append(" ").append("exp_row_size").append("=").append(expRowSize);
                start = false;
            } else {
                with.append(",").append(" ").append("exp_row_size").append("=").append(expRowSize);
            }
        }
        if (reservePageGap >= 0) {
            if (start) {
                with.append("WITH").append(" ").append("reservepagegap").append("=").append(reservePageGap);
                start = false;
            } else {
                with.append(",").append(" ").append("reservepagegap").append("=").append(reservePageGap);
            }
        }
        if (identityGap >= 0) {
            if (start) {
                with.append("WITH").append(" ").append("identity_gap").append("=").append(identityGap);
                start = false;
            } else {
                with.append(",").append(" ").append("identity_gap").append("=").append(identityGap);
            }
        }
        if (with.length() > 0) {
            return with.toString();
        }
        return null;
    }

    protected String getSegmentStatement(BaseTable table, boolean quoteIdentifiers) {
        SybaseASEBaseTable aseTable = (SybaseASEBaseTable)table;
        SybaseASESegment segment = aseTable.getSegment();
        if (segment == null) {
            return null;
        }
        String segmentName = segment.getName();
        segmentName = SQLUtil.quote((String)segmentName, (String)"'");
        return "ON " + segmentName;
    }

    protected String getPartitionStatement(BaseTable table, boolean quoteIdentifiers) {
        SybaseASERoundrobinPartition rPartition;
        SybaseASESegment segment;
        SybaseASEDatabase db = (SybaseASEDatabase)table.getSchema().getCatalog().getDatabase();
        if (!db.isPartitionsApplicable()) {
            return null;
        }
        SybaseASEBaseTable aseTable = (SybaseASEBaseTable)table;
        SybaseASEPartition partition = aseTable.getPartitionCondition();
        if (partition == null) {
            return null;
        }
        StringBuffer stmt = new StringBuffer();
        stmt.append("PARTITION").append(" ").append("BY").append(" ");
        if (partition instanceof SybaseASEHashPartition) {
            SybaseASEHashPartition hPartition = (SybaseASEHashPartition)partition;
            stmt.append("HASH").append(" ");
            boolean start = true;
            for (Column element : hPartition.getColumns()) {
                if (start) {
                    stmt.append("(").append(quoteIdentifiers ? this.getDoubleQuotedString(element.getName()) : element.getName());
                    start = false;
                    continue;
                }
                stmt.append(",").append(quoteIdentifiers ? this.getDoubleQuotedString(element.getName()) : element.getName());
            }
            if (!start) {
                stmt.append(")").append(NEWLINE);
            }
            PartitionNumInSegments partitionNumSeg = hPartition.getPartitionNumInSegments();
            start = true;
            if (partitionNumSeg != null) {
                stmt.append(partitionNumSeg.getPartitionNumb()).append(" ").append("ON").append(NEWLINE);
                stmt.append("(");
                for (PartitionSegmentPair element : partitionNumSeg.getSegment()) {
                    if (start) {
                        stmt.append(SQLUtil.quote((String)element.getName(), (String)"'"));
                        start = false;
                        continue;
                    }
                    stmt.append(",").append(SQLUtil.quote((String)element.getName(), (String)"'"));
                }
                stmt.append(")").append(NEWLINE);
            } else {
                start = true;
                for (PartitionSegmentPair element : hPartition.getPartitionSegmentPairs()) {
                    if (start) {
                        stmt.append("(").append(quoteIdentifiers ? this.getDoubleQuotedString(element.getPartitionName()) : element.getPartitionName());
                        start = false;
                    } else {
                        stmt.append(",").append(NEWLINE).append(quoteIdentifiers ? this.getDoubleQuotedString(element.getPartitionName()) : element.getPartitionName());
                    }
                    segment = element.getSegment();
                    if (segment == null || segment.getName() == null) continue;
                    stmt.append(" ").append("ON").append(" ").append(SQLUtil.quote((String)segment.getName(), (String)"'"));
                }
                if (!start) {
                    stmt.append(")").append(NEWLINE);
                }
            }
        }
        if (partition instanceof SybaseASERoundrobinPartition) {
            rPartition = (SybaseASERoundrobinPartition)partition;
            stmt.append("ROUNDROBIN").append(" ");
            PartitionNumInSegments partitionNumSeg = rPartition.getPartitionNumInSegments();
            boolean start = true;
            if (partitionNumSeg != null) {
                stmt.append(partitionNumSeg.getPartitionNumb()).append(" ").append("ON").append(NEWLINE);
                stmt.append("(");
                for (PartitionSegmentPair element : partitionNumSeg.getSegment()) {
                    if (start) {
                        stmt.append(SQLUtil.quote((String)element.getName(), (String)"'"));
                        start = false;
                        continue;
                    }
                    stmt.append(",").append(SQLUtil.quote((String)element.getName(), (String)"'"));
                }
                stmt.append(")").append(NEWLINE);
            } else {
                start = true;
                for (PartitionSegmentPair element : rPartition.getPartitionSegmentPairs()) {
                    if (start) {
                        stmt.append("(").append(quoteIdentifiers ? this.getDoubleQuotedString(element.getPartitionName()) : element.getPartitionName());
                        start = false;
                    } else {
                        stmt.append(",").append(NEWLINE).append(quoteIdentifiers ? this.getDoubleQuotedString(element.getPartitionName()) : element.getPartitionName());
                    }
                    segment = element.getSegment();
                    if (segment == null || segment.getName() == null) continue;
                    stmt.append(" ").append("ON").append(" ").append(SQLUtil.quote((String)segment.getName(), (String)"'"));
                }
                if (!start) {
                    stmt.append(")").append(NEWLINE);
                }
            }
        }
        if (partition instanceof SybaseASEListPartition) {
            SybaseASEListPartition lPartition = (SybaseASEListPartition)partition;
            stmt.append("LIST").append(" ");
            SybaseASEColumn column = lPartition.getColumn();
            stmt.append("(").append(quoteIdentifiers ? this.getDoubleQuotedString(column.getName()) : column.getName()).append(")").append(NEWLINE);
            boolean start = true;
            for (PartitionSegmentPair element : lPartition.getListPartitionItems()) {
                if (start) {
                    stmt.append("(").append(quoteIdentifiers ? this.getDoubleQuotedString(element.getPartitionName()) : element.getPartitionName());
                    start = false;
                } else {
                    stmt.append(",").append(NEWLINE).append(quoteIdentifiers ? this.getDoubleQuotedString(element.getPartitionName()) : element.getPartitionName());
                }
                stmt.append(" ").append("VALUES").append(" ").append("(");
                boolean valueStart = true;
                for (String value : element.getValues()) {
                    if (valueStart) {
                        stmt.append(value);
                        valueStart = false;
                        continue;
                    }
                    stmt.append(",").append(value);
                }
                stmt.append(")").append(" ");
                SybaseASESegment segment2 = element.getSegment();
                if (segment2 == null || segment2.getName() == null) continue;
                stmt.append("ON").append(" ").append(SQLUtil.quote((String)segment2.getName(), (String)"'"));
            }
            if (!start) {
                stmt.append(")").append(NEWLINE);
            }
        }
        if (partition instanceof SybaseASERangePartition) {
            rPartition = (SybaseASERangePartition)partition;
            stmt.append("RANGE").append(" ");
            boolean start = true;
            for (Column element : rPartition.getColumns()) {
                if (start) {
                    stmt.append("(").append(quoteIdentifiers ? this.getDoubleQuotedString(element.getName()) : element.getName());
                    start = false;
                    continue;
                }
                stmt.append(",").append(quoteIdentifiers ? this.getDoubleQuotedString(element.getName()) : element.getName());
            }
            if (!start) {
                stmt.append(")").append(NEWLINE);
            }
            start = true;
            for (Column element : rPartition.getRangePartitionItems()) {
                if (start) {
                    stmt.append("(").append(quoteIdentifiers ? this.getDoubleQuotedString(element.getPartitionName()) : element.getPartitionName());
                    start = false;
                } else {
                    stmt.append(",").append(NEWLINE).append(quoteIdentifiers ? this.getDoubleQuotedString(element.getPartitionName()) : element.getPartitionName());
                }
                stmt.append(" ").append("VALUES").append(" ").append("<=").append(" ").append("(");
                boolean valueStart = true;
                for (String value : element.getValues()) {
                    if (valueStart) {
                        stmt.append(value);
                        valueStart = false;
                        continue;
                    }
                    stmt.append(",").append(value);
                }
                stmt.append(")").append(" ");
                SybaseASESegment segment3 = element.getSegment();
                if (segment3 == null || segment3.getName() == null) continue;
                stmt.append("ON").append(" ").append(SQLUtil.quote((String)segment3.getName(), (String)"'"));
            }
            if (!start) {
                stmt.append(")").append(NEWLINE);
            }
        }
        if (stmt.length() > 0) {
            return stmt.toString();
        }
        return null;
    }

    protected String getAddUniqueConstraintClause(UniqueConstraint constraint, SybaseASEIndex index, boolean quoteIdentifiers) {
        SybaseASESegment segment;
        StringBuffer statement = new StringBuffer(128);
        String name = constraint.getName();
        if (name != null && name.trim().length() != 0) {
            if (quoteIdentifiers) {
                name = super.getDoubleQuotedString(name);
            }
            statement.append("CONSTRAINT").append(" ").append(name).append(" ");
        }
        statement.append(this.getUniqueConstraintType(constraint)).append(" ");
        if (index.isClustered()) {
            statement.append("CLUSTERED").append(" ");
        } else if (!index.isClustered()) {
            statement.append("NONCLUSTERED").append(" ");
        }
        statement.append("(").append(this.getKeyColumns(index, quoteIdentifiers)).append(")");
        if (index.getFillFactor() > 0 || index.getReversePageGap() > 0 || index.getMaxRowPerPage() > 0) {
            statement.append(NEWLINE).append("\t").append("WITH").append(" ").append(this.getIndexParameterClause(index));
        }
        if ((segment = index.getSegment()) != null) {
            String segmentName = segment.getName();
            segmentName = super.getSingleQuotedString(segmentName);
            statement.append(NEWLINE).append("\t").append("ON").append(" ").append(segmentName);
        }
        return statement.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getKeyColumns(SybaseASEIndex index, boolean quoteIdentifiers) {
        StringBuffer statement = new StringBuffer(128);
        Iterator it = index.getMembers().iterator();
        if (!it.hasNext()) {
            return null;
        }
        IndexMember idxMember = (IndexMember)it.next();
        Column c = idxMember.getColumn();
        if (quoteIdentifiers) {
            statement.append(this.getDoubleQuotedString(c.getName()));
        } else {
            statement.append(c.getName());
        }
        statement.append(this.getIncrementTypeOfColumn(idxMember));
        while (it.hasNext()) {
            idxMember = (IndexMember)it.next();
            c = idxMember.getColumn();
            if (quoteIdentifiers) {
                statement.append(",").append(" ").append(this.getDoubleQuotedString(c.getName()));
            } else {
                statement.append(",").append(" ").append(c.getName());
            }
            statement.append(" ").append(this.getIncrementTypeOfColumn(idxMember));
        }
        return statement.toString();
    }

    private String getIncrementTypeOfColumn(IndexMember idxMember) {
        if (idxMember.getIncrementType().getName().equals(IncrementType.DESC_LITERAL.getName())) {
            return " DESC";
        }
        return " ASC";
    }

    protected String getIndexParameterClause(SybaseASEIndex index) {
        StringBuffer statement = new StringBuffer(128);
        boolean startFlag = false;
        if (index.getFillFactor() > 0) {
            statement.append("fillfactor").append("=").append(index.getFillFactor());
            startFlag = true;
        }
        if (index.getMaxRowPerPage() > 0) {
            if (!startFlag) {
                statement.append("max_rows_per_page").append("=").append(index.getMaxRowPerPage());
            } else {
                statement.append(",").append("max_rows_per_page").append("=").append(index.getMaxRowPerPage());
            }
            startFlag = true;
        }
        if (index.getReversePageGap() > 0) {
            if (!startFlag) {
                statement.append("reservepagegap").append("=").append(index.getReversePageGap());
            } else {
                statement.append(",").append("reservepagegap").append("=").append(index.getReversePageGap());
            }
        }
        return statement.toString();
    }

    private String getFKMatchType(ForeignKey foreignKey) {
        if (foreignKey.getMatch().getName().equals(MatchType.MATCH_FULL_LITERAL.getName())) {
            return " match full";
        }
        return "";
    }

    private String[] createNonExistingTable(SybaseASEProxyTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyn) {
        String[] stmts = this.createBaseTable((BaseTable)table, quoteIdentifiers, qualifyNames, fullSyn);
        StringBuffer stmt = new StringBuffer(stmts[0]);
        String externalPath = this.getExternalPathClause(table);
        if (externalPath != null) {
            stmt.append(externalPath);
        }
        stmts[0] = stmt.toString();
        return stmts;
    }

    private String[] createExistingProxyTable(SybaseASEProxyTable table, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        List stmts = this.addObjectDef(table, quoteIdentifiers);
        StringBuffer tableNameClause = new StringBuffer("");
        tableNameClause.append("CREATE").append(" ").append("EXISTING").append(" ").append("TABLE").append(" ").append(this.getName((Table)table, quoteIdentifiers, qualifyNames)).append(NEWLINE);
        StringBuffer columnClause = new StringBuffer("");
        EList columns = table.getColumns();
        columnClause.append("(").append(NEWLINE);
        int i = 0;
        while (i < columns.size()) {
            columnClause.append("\t").append(this.getColumnString((Column)((SybaseASEColumn)columns.get(i)), quoteIdentifiers));
            if (i != columns.size() - 1) {
                columnClause.append(",");
            }
            columnClause.append(NEWLINE);
            ++i;
        }
        columnClause.append(")").append(NEWLINE);
        SybaseASESegment segment = table.getSegment();
        StringBuffer segmentClause = new StringBuffer("");
        if (segment != null) {
            segmentClause.append("ON").append(" ").append(SQLUtil.quote((String)segment.getName(), (String)"'")).append(NEWLINE);
        }
        StringBuffer externalTypeClause = new StringBuffer("");
        if (table.getExternalType() != null) {
            int type = table.getExternalType().getValue();
            switch (type) {
                case 2: {
                    externalTypeClause.append("EXTERNAL").append(" ").append("FILE");
                    break;
                }
                case 1: {
                    externalTypeClause.append("EXTERNAL").append(" ").append("PROCEDURE");
                    break;
                }
                default: {
                    externalTypeClause.append("EXTERNAL").append(" ").append("TABLE");
                }
            }
            externalTypeClause.append(NEWLINE);
        }
        String externalPathClause = this.getExternalPathClause(table);
        StringBuffer colDelimClause = new StringBuffer("");
        if (table.getColumnDelimiter() != null) {
            colDelimClause.append("COLUMN DELIMITER").append(" ").append("\"").append(table.getColumnDelimiter()).append("\"");
        }
        StringBuffer stmt = new StringBuffer();
        stmt.append(tableNameClause).append(columnClause).append(segmentClause).append(externalTypeClause).append(externalPathClause).append(colDelimClause);
        stmts.add(stmt.toString());
        String[] result = new String[stmts.size()];
        int i2 = 0;
        while (i2 < stmts.size()) {
            result[i2] = stmts.get(i2).toString();
            ++i2;
        }
        return result;
    }

    private String getExternalPathClause(SybaseASEProxyTable table) {
        if (table.getExternalPath() != null) {
            StringBuffer externalPathClause = new StringBuffer();
            externalPathClause.append("AT").append(" ").append(SQLUtil.quote((String)table.getExternalPath(), (String)"'")).append(NEWLINE);
            return externalPathClause.toString();
        }
        return null;
    }

    private List addObjectDef(SybaseASEProxyTable table, boolean quoteIdentifiers) {
        ArrayList<String> stmts = new ArrayList<String>();
        StringBuffer addObjectDef = new StringBuffer();
        String setUserStr = "";
        Schema creator = table.getSchema();
        if (creator != null) {
            setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
        }
        if (!setUserStr.equals("")) {
            stmts.add(setUserStr);
        }
        addObjectDef.append("sp_addobjectdef").append(" ").append(this.getName((Table)table, quoteIdentifiers, false)).append(",").append(" ").append(SQLUtil.quote((String)table.getExternalPath(), (String)"'")).append(NEWLINE);
        stmts.add(addObjectDef.toString());
        String setUserDbo = SybaseASESQLUtil.getSetUserDBOStatement(creator);
        if (!setUserDbo.equals("")) {
            stmts.add(setUserDbo);
        }
        return stmts;
    }

    private String getIndexWithClause(boolean needWithClause) {
        return needWithClause ? "\t" : String.valueOf(NEWLINE) + "\t" + "WITH" + " ";
    }

    private void addComma(boolean needComma, StringBuffer statement) {
        if (needComma) {
            statement.append("," + NEWLINE + "\t");
        }
    }

    public String createColumn(Column col, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer stmt = new StringBuffer();
        stmt.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName(col.getTable(), quoteIdentifiers, qualifyNames)).append(NEWLINE).append(" ").append("ADD").append(" ").append(this.getColumnString(col, quoteIdentifiers));
        return stmt.toString();
    }

    public String dropForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = this.dropTableConstraint((TableConstraint)foreignKey, quoteIdentifiers, qualifyNames);
        String setUserStr = "";
        Schema creator = foreignKey.getBaseTable().getSchema();
        setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
        dropStatement = String.valueOf(setUserStr) + NEWLINE + "\t" + dropStatement + NEWLINE + "\t" + SybaseASESQLUtil.getSetUserDBOStatement(creator);
        BaseTable table = foreignKey.getBaseTable();
        String tableName = this.getName((Table)table, quoteIdentifiers, true);
        String constrName = foreignKey.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_FOREIGNKEY, tableName, constrName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        if (!(constraint instanceof SybaseASECheckConstraint)) {
            return "";
        }
        String dropStatement = this.dropTableConstraint((TableConstraint)constraint, quoteIdentifiers, qualifyNames);
        String setUserStr = "";
        Schema creator = ((SybaseASECheckConstraint)constraint).getCreator();
        if (creator != null) {
            setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
        }
        dropStatement = String.valueOf(setUserStr) + NEWLINE + "\t" + dropStatement + NEWLINE + "\t" + SybaseASESQLUtil.getSetUserDBOStatement(creator);
        BaseTable table = constraint.getBaseTable();
        String tableName = this.getName((Table)table, quoteIdentifiers, true);
        String constrName = constraint.getName();
        String existingCheck = "";
        existingCheck = constraint instanceof SybaseASEColumnCheckConstraint ? MessageFormat.format(QueryObjectsSQL.QUERY_COLUMN_CHECK_CONSTRAINT, tableName, constrName) : MessageFormat.format(QueryObjectsSQL.QUERY_CHECK_CONSTRAINT, tableName, tableName, constrName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String dropUniqueConstraint(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String dropStatement = this.dropTableConstraint((TableConstraint)constraint, quoteIdentifiers, qualifyNames);
        BaseTable table = constraint.getBaseTable();
        String tableName = this.getName((Table)table, quoteIdentifiers, true);
        String constrName = constraint.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_PK_UNIQUE, tableName, constrName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String getName(ENamedElement element, boolean quoteIdentifiers, boolean qualifyNames) {
        if (element instanceof SybaseASEDefault) {
            return this.getName((SybaseASEDefault)element, quoteIdentifiers, qualifyNames);
        }
        if (element instanceof SybaseASERule) {
            return this.getName((SybaseASERule)element, quoteIdentifiers, qualifyNames);
        }
        return super.getName(element, quoteIdentifiers, qualifyNames);
    }

    public String getName(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        String tableName = table.getName();
        String schemaName = table.getSchema().getName();
        if (quoteIdentifiers) {
            tableName = SQLDevToolsUtil.quoteWhenNecessary((String)table.getName(), (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)table));
            schemaName = SQLDevToolsUtil.quoteWhenNecessary((String)table.getSchema().getName(), (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)table));
        }
        if (qualifyNames) {
            tableName = String.valueOf(schemaName) + "." + tableName;
        }
        return tableName;
    }

    protected String getName(SybaseASEDefault aseDefault, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = aseDefault.getName();
        String schemaName = aseDefault.getSchema().getName();
        if (quoteIdentifiers) {
            schemaName = SQLDevToolsUtil.quoteWhenNecessary((String)schemaName, (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)aseDefault));
            name = SQLDevToolsUtil.quoteWhenNecessary((String)name, (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)aseDefault));
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + "." + name;
        }
        return name;
    }

    protected String getName(SybaseASERule aseRule, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = aseRule.getName();
        String schemaName = aseRule.getSchema().getName();
        if (quoteIdentifiers) {
            schemaName = SQLDevToolsUtil.quoteWhenNecessary((String)schemaName, (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)aseRule));
            name = SQLDevToolsUtil.quoteWhenNecessary((String)name, (DatabaseIdentifier)this.getDatabaseIdentifier((EObject)aseRule));
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + "." + name;
        }
        return name;
    }

    public String[] createAuthorizationId(AuthorizationIdentifier authId, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String name = authId.getName();
        if (name.equals("dbo") || name.equals("public")) {
            return new String[0];
        }
        ArrayList<String> results = new ArrayList<String>();
        if (authId instanceof SybaseASEUser) {
            StringBuffer sb = new StringBuffer(128);
            SybaseASEUser aseUser = (SybaseASEUser)authId;
            if (!aseUser.getName().equals("guest")) {
                sb.append("sp_adduser").append(" ").append(SQLUtil.quote((String)aseUser.getLoginName(), (String)"'")).append(",").append(" ").append(SQLUtil.quote((String)authId.getName(), (String)"'"));
            } else {
                sb.append("sp_adduser").append(" ").append(SQLUtil.quote((String)authId.getName(), (String)"'"));
            }
            results.add(sb.toString());
        } else if (authId instanceof Group) {
            StringBuffer sb = new StringBuffer(128);
            sb.append("sp_addgroup").append(" ").append(SQLUtil.quote((String)authId.getName(), (String)"'"));
            results.add(sb.toString());
            EList users = ((Group)authId).getUser();
            int i = 0;
            while (i < users.size()) {
                User user = (User)users.get(i);
                StringBuffer sb1 = new StringBuffer(64);
                sb1.append("sp_changegroup").append(" ").append(SQLUtil.quote((String)authId.getName(), (String)"'")).append(",").append(" ").append(SQLUtil.quote((String)user.getName(), (String)"'"));
                results.add(sb1.toString());
                ++i;
            }
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] createColumn(Column col, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        String ruleBoundStmt;
        ArrayList<String> stmts = new ArrayList<String>();
        StringBuffer sb = new StringBuffer(128);
        String setUserStr = "";
        Schema creator = col.getTable().getSchema();
        if (creator != null) {
            setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
        }
        sb.append(setUserStr).append(NEWLINE);
        sb.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName(col.getTable(), quoteIdentifiers, qualifyNames)).append(" ").append("ADD").append(" ").append(this.getColumnString(col, quoteIdentifiers)).append(NEWLINE);
        stmts.add(sb.toString());
        String defaultBoundStmt = this.createBoundDefault(col, quoteIdentifiers, qualifyNames, fullSyntax);
        if (defaultBoundStmt != null) {
            stmts.add(defaultBoundStmt);
        }
        if ((ruleBoundStmt = this.creatBoundRule((SybaseASEColumn)col, quoteIdentifiers, qualifyNames, fullSyntax)) != null) {
            stmts.add(ruleBoundStmt);
        }
        String[] result = new String[stmts.size()];
        return stmts.toArray(result);
    }

    private String creatBoundRule(SybaseASEColumn col, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (col.getBoundRule() != null) {
            StringBuffer stmt = new StringBuffer();
            String setUserStr = "";
            Schema creator = col.getTable().getSchema();
            if (creator != null) {
                setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
            }
            stmt.append(setUserStr).append(NEWLINE);
            stmt.append("EXEC").append(" ").append("sp_bindrule").append(" ").append(SQLUtil.quote((String)this.getName(col.getBoundRule(), false, true), (String)"'")).append(",").append(SQLUtil.quote((String)(String.valueOf(col.getTable().getName()) + "." + col.getName()), (String)"'"));
            return stmt.toString();
        }
        return null;
    }

    public String createBoundDefault(Column col, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        if (((SybaseASEColumn)col).getBoundDefault() != null) {
            StringBuffer stmt = new StringBuffer();
            String setUserStr = "";
            Schema creator = col.getTable().getSchema();
            if (creator != null) {
                setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
            }
            stmt.append(setUserStr).append(NEWLINE);
            stmt.append("EXEC").append(" ").append("sp_bindefault").append(" ").append(SQLUtil.quote((String)this.getName(((SybaseASEColumn)col).getBoundDefault(), false, true), (String)"'")).append(",").append(SQLUtil.quote((String)(String.valueOf(col.getTable().getName()) + "." + col.getName()), (String)"'")).append(NEWLINE);
            stmt.append(SybaseASESQLUtil.getSetUserDBOStatement(creator)).append(NEWLINE);
            return stmt.toString();
        }
        return null;
    }

    public String dropAuthorizationId(AuthorizationIdentifier authId, boolean quoteIdentifiers, boolean qualifyNames) {
        StringBuffer sb = new StringBuffer(64);
        if (authId instanceof User) {
            sb.append("sp_dropuser").append(" ").append(SQLUtil.quote((String)authId.getName(), (String)"'"));
        } else if (authId instanceof Group) {
            sb.append("sp_dropgroup").append(" ").append(SQLUtil.quote((String)authId.getName(), (String)"'"));
        }
        String dropStatement = sb.toString();
        String authidName = authId.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_AUTHID, authidName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    public String[] createSegment(SybaseASESegment segment, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        ArrayList<String> results = new ArrayList<String>();
        String dbName = segment.getCatalog().getName();
        StringBuffer sb = new StringBuffer(128);
        EList devices = segment.getDeviceNames();
        sb.append("sp_addsegment").append(" ").append(SQLUtil.quote((String)segment.getName(), (String)"'")).append(",").append(" ").append(SQLUtil.quote((String)dbName, (String)"'")).append(",").append(" ").append(SQLUtil.quote((String)((String)devices.get(0)), (String)"'"));
        int i = 1;
        while (i < devices.size()) {
            StringBuffer sb1 = new StringBuffer(128);
            String devName = (String)devices.get(i);
            sb1.append("sp_extendsegment").append(" ").append(SQLUtil.quote((String)segment.getName(), (String)"'")).append(",").append(" ").append(SQLUtil.quote((String)dbName, (String)"'")).append(",").append(" ").append(SQLUtil.quote((String)devName, (String)"'"));
            results.add(sb1.toString());
            ++i;
        }
        return new String[]{sb.toString()};
    }

    public String dropSegment(SybaseASESegment segment, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = segment.getName();
        if (name.equals("default") || name.equals("system") || name.equals("logsegment")) {
            return "";
        }
        StringBuffer sb = new StringBuffer(128);
        sb.append("sp_dropsegment").append(" ").append(SQLUtil.quote((String)segment.getName(), (String)"'")).append(",").append(" ").append(SQLUtil.quote((String)segment.getCatalog().getName(), (String)"'"));
        String dropStatement = sb.toString();
        String segmentName = segment.getName();
        String existingCheck = MessageFormat.format(QueryObjectsSQL.QUERY_SEGMENT, segmentName);
        return MessageFormat.format(this.getDropPreconditionPattern(), existingCheck, dropStatement);
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema) {
        SQLDataType containedType = typedElement.getContainedType();
        if (containedType != null) {
            EObject root;
            if (containedType instanceof PredefinedDataType && (root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)typedElement)) instanceof Database) {
                DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
                return def.getPredefinedDataTypeFormattedName((PredefinedDataType)containedType);
            }
        } else {
            UserDefinedType referencedType = typedElement.getReferencedType();
            if (referencedType != null) {
                String udtName = referencedType.getSchema() != schema ? this.getName(referencedType, false, false) : referencedType.getName();
                udtName = SQLUtil.quote((String)udtName, (String)"\"");
                return udtName;
            }
        }
        return null;
    }

    public String getIndexKeyColumns(Index index, boolean quoteIdentifiers) {
        return ASEDdlUtils.getIndexMemberKeys(index.getMembers(), quoteIdentifiers);
    }

    protected String getDropPreconditionPattern() {
        StringBuffer sb = new StringBuffer();
        sb.append("IF").append(" ").append("EXISTS").append(" ").append("(").append(NEWLINE);
        sb.append("\t").append("{0}").append(")").append(NEWLINE).append("BEGIN").append(NEWLINE);
        sb.append("\t").append("{1}").append(NEWLINE).append("END");
        return sb.toString();
    }

    public String[] addCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax) {
        StringBuffer statement = new StringBuffer(128);
        statement.append("ALTER").append(" ").append("TABLE").append(" ").append(this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames)).append(" ");
        statement.append(NEWLINE).append("\t").append("ADD").append(" ");
        statement.append(this.getAddCheckConstraintClause(constraint, quoteIdentifiers));
        String setUserStr = "";
        Schema creator = constraint.getBaseTable().getSchema();
        if (constraint instanceof SybaseASECheckConstraint) {
            creator = ((SybaseASECheckConstraint)constraint).getCreator();
        }
        if (creator != null) {
            setUserStr = SybaseASESQLUtil.getSetNewUserStatement(creator);
        }
        String setUserDbo = SybaseASESQLUtil.getSetUserDBOStatement(creator);
        if (setUserStr.equals("")) {
            return new String[]{statement.toString()};
        }
        return new String[]{setUserStr, statement.toString(), setUserDbo};
    }
}

