/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogRole;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASERoleImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogLocalRole
extends SybaseASERoleImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 2894870535821570588L;
    private SybaseASECatalogRole serverRole;
    private SybaseASECatalog catalog;
    private Boolean recievedPrivilegeLoaded = Boolean.FALSE;

    public SybaseASECatalogLocalRole(SybaseASECatalogRole serverRole, SybaseASECatalog catalog) {
        this.serverRole = serverRole;
        this.catalog = catalog;
        this.setName(serverRole.getName());
    }

    public Database getCatalogDatabase() {
        return this.catalog.getCatalogDatabase();
    }

    public Connection getConnection() {
        return this.serverRole.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.recievedPrivilegeLoaded;
        synchronized (bl) {
            this.recievedPrivilegeLoaded = Boolean.FALSE;
            super.getReceivedPrivilege().clear();
            this.serverRole.clearReceivedPrivileges(this.catalog.getName());
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 12: {
                this.getReceivedPrivilege();
                break;
            }
            case 7: {
                this.getOwnedSchema();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getReceivedPrivilege() {
        Boolean bl = this.recievedPrivilegeLoaded;
        synchronized (bl) {
            if (!this.recievedPrivilegeLoaded.booleanValue()) {
                List receivedPrivileges = this.serverRole.getReceivedPrivileges(this.catalog.getName());
                super.getReceivedPrivilege().clear();
                super.getReceivedPrivilege().addAll((Collection)receivedPrivileges);
                this.recievedPrivilegeLoaded = Boolean.TRUE;
            }
        }
        return super.getReceivedPrivilege();
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

