/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASEGroupImpl;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.User;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogGroup
extends SybaseASEGroupImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 6956551574517156423L;
    private SybaseASECatalog catalog;
    private Boolean isPrivilegesLoaded = Boolean.FALSE;
    private Boolean isOwnedSchemaLoaded = Boolean.FALSE;
    private Boolean isUsersLoaded = Boolean.FALSE;

    public SybaseASECatalogGroup(SybaseASECatalog catalog) {
        this.catalog = catalog;
    }

    public Database getCatalogDatabase() {
        return this.catalog.getDatabase();
    }

    public Connection getConnection() {
        return this.catalog.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.isPrivilegesLoaded;
        synchronized (bl) {
            this.isPrivilegesLoaded = Boolean.FALSE;
        }
        bl = this.isUsersLoaded;
        synchronized (bl) {
            this.isUsersLoaded = Boolean.FALSE;
        }
        bl = this.isOwnedSchemaLoaded;
        synchronized (bl) {
            this.isOwnedSchemaLoaded = Boolean.FALSE;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 12) {
            this.getReceivedPrivilege();
        } else if (id == 13) {
            this.getUser();
        } else if (id == 7) {
            this.getOwnedSchema();
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getReceivedPrivilege() {
        Boolean bl = this.isPrivilegesLoaded;
        synchronized (bl) {
            if (!this.isPrivilegesLoaded.booleanValue()) {
                this.loadPrivileges();
            }
        }
        return super.getReceivedPrivilege();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getUser() {
        Boolean bl = this.isUsersLoaded;
        synchronized (bl) {
            if (!this.isUsersLoaded.booleanValue()) {
                this.loadUsers();
            }
        }
        return super.getUser();
    }

    private void loadUsers() {
        boolean deliver;
        block13: {
            if (this.isUsersLoaded.booleanValue()) {
                return;
            }
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            EList users = super.getUser();
            users.clear();
            if (this.getName().equals("public")) {
                EList authIds = this.catalog.getAuthorizationIds();
                int i = 0;
                while (i < authIds.size()) {
                    AuthorizationIdentifier authid = (AuthorizationIdentifier)authIds.get(i);
                    if (authid instanceof User) {
                        users.add((Object)authid);
                    }
                    ++i;
                }
            } else {
                Connection conn = this.getConnection();
                PreparedStatement stmt = null;
                ResultSet rs = null;
                String oldCatalog = null;
                try {
                    try {
                        oldCatalog = conn.getCatalog();
                        conn.setCatalog(this.catalog.getName());
                        stmt = this.getConnection().prepareStatement("select u1.name from sysusers u1, sysusers u2 where u2.name = ? and u1.gid = u2.gid and u1.name <> u2.name");
                        stmt.setString(1, this.getName());
                        rs = stmt.executeQuery();
                        block5: while (rs.next()) {
                            String userName = rs.getString(1);
                            EList authIds = this.catalog.getAuthorizationIds();
                            int i = 0;
                            while (i < authIds.size()) {
                                AuthorizationIdentifier authid = (AuthorizationIdentifier)authIds.get(i);
                                if (authid.getName().equals(userName)) {
                                    users.add((Object)authid);
                                    continue block5;
                                }
                                ++i;
                            }
                        }
                    }
                    catch (SQLException e) {
                        JDBCASEPlugin.getDefault().log(e);
                        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    throw throwable;
                }
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            }
        }
        this.eSetDeliver(deliver);
        this.isUsersLoaded = Boolean.TRUE;
    }

    private void loadPrivileges() {
        if (this.isPrivilegesLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList privileges = super.getReceivedPrivilege();
        privileges.clear();
        this.eSetDeliver(deliver);
        this.isPrivilegesLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getOwnedSchema() {
        Boolean bl = this.isOwnedSchemaLoaded;
        synchronized (bl) {
            if (!this.isOwnedSchemaLoaded.booleanValue()) {
                EList ownedSchemas = super.getOwnedSchema();
                ownedSchemas.clear();
                Schema schema = (Schema)ASEUtil.getSQLObject((Collection)this.catalog.getSchemas(), this.getName());
                if (schema != null) {
                    ownedSchemas.add((Object)schema);
                }
            }
        }
        return super.getOwnedSchema();
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }
}

