/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumArrayDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.JDTTools;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.ShortCircuitArrayAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.SimpleTypeStringExpressionConverter;
import org.eclipse.jpt.core.resource.java.CascadeType;
import org.eclipse.jpt.core.resource.java.FetchType;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.RelationshipMappingAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.Attribute;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.utility.internal.CollectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceRelationshipMappingAnnotation
extends SourceAnnotation<Attribute>
implements RelationshipMappingAnnotation {
    final DeclarationAnnotationElementAdapter<String> targetEntityDeclarationAdapter = this.getTargetEntityAdapter();
    final AnnotationElementAdapter<String> targetEntityAdapter = this.buildAnnotationElementAdapter(this.targetEntityDeclarationAdapter);
    String targetEntity;
    String fullyQualifiedTargetEntityClassName;
    final DeclarationAnnotationElementAdapter<String> fetchDeclarationAdapter = this.getFetchAdapter();
    final AnnotationElementAdapter<String> fetchAdapter = this.buildAnnotationElementAdapter(this.fetchDeclarationAdapter);
    FetchType fetch;
    final DeclarationAnnotationElementAdapter<String[]> cascadeDeclarationAdapter = this.getCascadeAdapter();
    final AnnotationElementAdapter<String[]> cascadeAdapter;
    boolean cascadeAll;
    boolean cascadePersist;
    boolean cascadeMerge;
    boolean cascadeRemove;
    boolean cascadeRefresh;

    SourceRelationshipMappingAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, DeclarationAnnotationAdapter daa) {
        super(parent, attribute, daa);
        this.cascadeAdapter = new ShortCircuitArrayAnnotationElementAdapter((Member)attribute, (DeclarationAnnotationElementAdapter<T[]>)this.cascadeDeclarationAdapter);
    }

    AnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>(this.member, daea);
    }

    AnnotationElementAdapter<Boolean> buildBooleanAnnotationElementAdapter(DeclarationAnnotationElementAdapter<Boolean> daea) {
        return new ShortCircuitAnnotationElementAdapter<Boolean>(this.member, daea);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.targetEntity = this.buildTargetEntity(astRoot);
        this.fullyQualifiedTargetEntityClassName = this.buildFullyQualifiedTargetEntityClassName(astRoot);
        this.fetch = this.buildFetch(astRoot);
        this.initializeCascadeTypes(astRoot);
    }

    private void initializeCascadeTypes(CompilationUnit astRoot) {
        CascadeType[] cascadeTypes = CascadeType.fromJavaAnnotationValues(this.cascadeAdapter.getValue(astRoot));
        this.cascadeAll = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.ALL));
        this.cascadeMerge = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.MERGE));
        this.cascadePersist = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.PERSIST));
        this.cascadeRefresh = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REFRESH));
        this.cascadeRemove = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REMOVE));
    }

    @Override
    public void update(CompilationUnit astRoot) {
        this.setFetch(this.buildFetch(astRoot));
        this.setTargetEntity(this.buildTargetEntity(astRoot));
        this.setFullyQualifiedTargetEntityClassName(this.buildFullyQualifiedTargetEntityClassName(astRoot));
        this.updateCascade(astRoot);
    }

    private void updateCascade(CompilationUnit astRoot) {
        CascadeType[] cascadeTypes = CascadeType.fromJavaAnnotationValues(this.cascadeAdapter.getValue(astRoot));
        this.setCascadeAll(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.ALL)));
        this.setCascadeMerge(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.MERGE)));
        this.setCascadePersist(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.PERSIST)));
        this.setCascadeRefresh(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REFRESH)));
        this.setCascadeRemove(CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)CascadeType.REMOVE)));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.targetEntity);
    }

    @Override
    public String getTargetEntity() {
        return this.targetEntity;
    }

    @Override
    public void setTargetEntity(String targetEntity) {
        if (this.attributeValueHasNotChanged(this.targetEntity, targetEntity)) {
            return;
        }
        String old = this.targetEntity;
        this.targetEntity = targetEntity;
        this.targetEntityAdapter.setValue(targetEntity);
        this.firePropertyChanged("targetEntity", old, targetEntity);
    }

    private String buildTargetEntity(CompilationUnit astRoot) {
        return this.targetEntityAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getTargetEntityTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.targetEntityDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<String> getTargetEntityAdapter();

    @Override
    public String getFullyQualifiedTargetEntityClassName() {
        return this.fullyQualifiedTargetEntityClassName;
    }

    private void setFullyQualifiedTargetEntityClassName(String name) {
        String old = this.fullyQualifiedTargetEntityClassName;
        this.fullyQualifiedTargetEntityClassName = name;
        this.firePropertyChanged("fullyQualifiedTargetEntityClassName", old, name);
    }

    private String buildFullyQualifiedTargetEntityClassName(CompilationUnit astRoot) {
        return this.targetEntity == null ? null : JDTTools.resolveFullyQualifiedName(this.targetEntityAdapter.getExpression(astRoot));
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType fetch) {
        if (this.attributeValueHasNotChanged((Object)this.fetch, (Object)fetch)) {
            return;
        }
        FetchType old = this.fetch;
        this.fetch = fetch;
        this.fetchAdapter.setValue(FetchType.toJavaAnnotationValue(fetch));
        this.firePropertyChanged("fetch", (Object)old, (Object)fetch);
    }

    private FetchType buildFetch(CompilationUnit astRoot) {
        return FetchType.fromJavaAnnotationValue(this.fetchAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getFetchTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.fetchDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<String> getFetchAdapter();

    private void setCascadeTypes(CascadeType[] cascadeTypes) {
        this.cascadeAdapter.setValue(CascadeType.toJavaAnnotationValues(cascadeTypes));
    }

    private void setCascade(CascadeType cascadeType, boolean set) {
        Object[] javaValues = this.cascadeAdapter.getValue();
        CascadeType[] cascadeTypes = CascadeType.fromJavaAnnotationValues(javaValues);
        boolean present = CollectionTools.contains((Object[])cascadeTypes, (Object)((Object)cascadeType));
        if (set) {
            if (!present) {
                this.setCascadeTypes((CascadeType[])CollectionTools.add((Object[])cascadeTypes, (Object)((Object)cascadeType)));
            }
        } else if (present) {
            this.setCascadeTypes((CascadeType[])CollectionTools.remove((Object[])cascadeTypes, (Object)((Object)cascadeType)));
        }
    }

    @Override
    public TextRange getCascadeTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.cascadeDeclarationAdapter, astRoot);
    }

    abstract DeclarationAnnotationElementAdapter<String[]> getCascadeAdapter();

    @Override
    public boolean isCascadeAll() {
        return this.cascadeAll;
    }

    @Override
    public void setCascadeAll(boolean cascadeAll) {
        if (this.cascadeAll == cascadeAll) {
            return;
        }
        boolean old = this.cascadeAll;
        this.cascadeAll = cascadeAll;
        this.setCascade(CascadeType.ALL, cascadeAll);
        this.firePropertyChanged("cascadeAll", old, cascadeAll);
    }

    @Override
    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    @Override
    public void setCascadePersist(boolean cascadePersist) {
        if (this.cascadePersist == cascadePersist) {
            return;
        }
        boolean old = this.cascadePersist;
        this.cascadePersist = cascadePersist;
        this.setCascade(CascadeType.PERSIST, cascadePersist);
        this.firePropertyChanged("cascadePersist", old, cascadePersist);
    }

    @Override
    public boolean isCascadeMerge() {
        return this.cascadeMerge;
    }

    @Override
    public void setCascadeMerge(boolean cascadeMerge) {
        if (this.cascadeMerge == cascadeMerge) {
            return;
        }
        boolean old = this.cascadeMerge;
        this.cascadeMerge = cascadeMerge;
        this.setCascade(CascadeType.MERGE, cascadeMerge);
        this.firePropertyChanged("cascadeMerge", old, cascadeMerge);
    }

    @Override
    public boolean isCascadeRemove() {
        return this.cascadeRemove;
    }

    @Override
    public void setCascadeRemove(boolean cascadeRemove) {
        if (this.cascadeRemove == cascadeRemove) {
            return;
        }
        boolean old = this.cascadeRemove;
        this.cascadeRemove = cascadeRemove;
        this.setCascade(CascadeType.REMOVE, cascadeRemove);
        this.firePropertyChanged("cascadeRemove", old, cascadeRemove);
    }

    @Override
    public boolean isCascadeRefresh() {
        return this.cascadeRefresh;
    }

    @Override
    public void setCascadeRefresh(boolean cascadeRefresh) {
        if (this.cascadeRefresh == cascadeRefresh) {
            return;
        }
        boolean old = this.cascadeRefresh;
        this.cascadeRefresh = cascadeRefresh;
        this.setCascade(CascadeType.REFRESH, cascadeRefresh);
        this.firePropertyChanged("cascadeRefresh", old, cascadeRefresh);
    }

    static DeclarationAnnotationElementAdapter<String> buildTargetEntityAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceRelationshipMappingAnnotation.buildAnnotationElementAdapter(annotationAdapter, elementName, SimpleTypeStringExpressionConverter.instance());
    }

    static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, false, converter);
    }

    static DeclarationAnnotationElementAdapter<String> buildFetchAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new EnumDeclarationAnnotationElementAdapter(annotationAdapter, elementName, false);
    }

    static DeclarationAnnotationElementAdapter<String[]> buildEnumArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new EnumArrayDeclarationAnnotationElementAdapter(annotationAdapter, elementName, false);
    }
}

