/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.binary;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryNode;
import org.eclipse.jpt.core.resource.java.Annotation;
import org.eclipse.jpt.core.resource.java.ContainerAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentMember;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterables.CloneIterable;
import org.eclipse.jpt.utility.internal.iterables.FixedCloneIterable;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BinaryPersistentMember
extends BinaryNode
implements JavaResourcePersistentMember {
    final Adapter adapter;
    final Vector<Annotation> mappingAnnotations = new Vector();
    final Vector<Annotation> supportingAnnotations = new Vector();
    boolean persistable;
    private static final IAnnotation[] EMPTY_JDT_ANNOTATION_ARRAY = new IAnnotation[0];

    public BinaryPersistentMember(JavaResourceNode parent, Adapter adapter) {
        super(parent);
        this.adapter = adapter;
        this.initializeAnnotations();
        this.persistable = this.buildPersistable();
    }

    private void initializeAnnotations() {
        IAnnotation[] iAnnotationArray = this.getJdtAnnotations();
        int n = iAnnotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            this.addAnnotation(annotation);
            ++n2;
        }
    }

    private void addAnnotation(IAnnotation jdtAnnotation) {
        if (this.annotationIsValidSupportingAnnotation(jdtAnnotation)) {
            this.supportingAnnotations.add(this.buildSupportingAnnotation(jdtAnnotation));
        } else if (this.annotationIsValidMappingAnnotation(jdtAnnotation)) {
            this.mappingAnnotations.add(this.buildMappingAnnotation(jdtAnnotation));
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateAnnotations();
        this.setPersistable(this.buildPersistable());
    }

    private void updateAnnotations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Annotation> mappingAnnotations() {
        return new CloneIterator(this.mappingAnnotations);
    }

    private Iterable<Annotation> getMappingAnnotations() {
        return new CloneIterable(this.mappingAnnotations);
    }

    @Override
    public int mappingAnnotationsSize() {
        return this.mappingAnnotations.size();
    }

    @Override
    public Annotation getMappingAnnotation() {
        FixedCloneIterable annotations = new FixedCloneIterable(this.mappingAnnotations);
        ListIterator<String> stream = this.validMappingAnnotationNames();
        while (stream.hasNext()) {
            Annotation annotation = this.selectAnnotationNamed((Iterable<Annotation>)annotations, stream.next());
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    @Override
    public Annotation getMappingAnnotation(String annotationName) {
        return this.selectAnnotationNamed(this.getMappingAnnotations(), annotationName);
    }

    private boolean annotationIsValidMappingAnnotation(IAnnotation jdtAnnotation) {
        return CollectionTools.contains(this.validMappingAnnotationNames(), (Object)jdtAnnotation.getElementName());
    }

    abstract ListIterator<String> validMappingAnnotationNames();

    abstract Annotation buildMappingAnnotation(IAnnotation var1);

    @Override
    public Iterator<Annotation> supportingAnnotations() {
        return new CloneIterator(this.supportingAnnotations);
    }

    private Iterable<Annotation> getSupportingAnnotations() {
        return new CloneIterable(this.supportingAnnotations);
    }

    @Override
    public int supportingAnnotationsSize() {
        return this.supportingAnnotations.size();
    }

    @Override
    public ListIterator<NestableAnnotation> supportingAnnotations(String nestableAnnotationName, String containerAnnotationName) {
        ContainerAnnotation<NestableAnnotation> containerAnnotation = this.getSupportingContainerAnnotation(containerAnnotationName);
        if (containerAnnotation != null) {
            return containerAnnotation.nestedAnnotations();
        }
        NestableAnnotation nestableAnnotation = this.getSupportingNestableAnnotation(nestableAnnotationName);
        return nestableAnnotation == null ? EmptyListIterator.instance() : new SingleElementListIterator((Object)nestableAnnotation);
    }

    private NestableAnnotation getSupportingNestableAnnotation(String annotationName) {
        return (NestableAnnotation)this.getSupportingAnnotation(annotationName);
    }

    @Override
    public Annotation getSupportingAnnotation(String annotationName) {
        return this.selectAnnotationNamed(this.getSupportingAnnotations(), annotationName);
    }

    @Override
    public Annotation getNonNullSupportingAnnotation(String annotationName) {
        Annotation annotation = this.getSupportingAnnotation(annotationName);
        return annotation != null ? annotation : this.buildNullSupportingAnnotation(annotationName);
    }

    abstract Annotation buildNullSupportingAnnotation(String var1);

    abstract Annotation buildSupportingAnnotation(IAnnotation var1);

    private boolean annotationIsValidSupportingAnnotation(IAnnotation jdtAnnotation) {
        return CollectionTools.contains(this.validSupportingAnnotationNames(), (Object)jdtAnnotation.getElementName());
    }

    abstract ListIterator<String> validSupportingAnnotationNames();

    private ContainerAnnotation<NestableAnnotation> getSupportingContainerAnnotation(String annotationName) {
        return (ContainerAnnotation)this.getSupportingAnnotation(annotationName);
    }

    @Override
    public boolean isPersistable() {
        return this.persistable;
    }

    private void setPersistable(boolean persistable) {
        boolean old = this.persistable;
        this.persistable = persistable;
        this.firePropertyChanged("persistable", old, persistable);
    }

    private boolean buildPersistable() {
        return this.adapter.isPersistable();
    }

    @Override
    public boolean isPersisted() {
        return this.getMappingAnnotation() != null;
    }

    IMember getMember() {
        return this.adapter.getMember();
    }

    private Annotation selectAnnotationNamed(Iterable<Annotation> annotations, String annotationName) {
        for (Annotation annotation : annotations) {
            if (!annotation.getAnnotationName().equals(annotationName)) continue;
            return annotation;
        }
        return null;
    }

    <T extends JavaResourcePersistentMember> Iterator<T> persistableMembers(Iterator<T> members) {
        return new FilteringIterator<T, T>(members){

            protected boolean accept(T m) {
                return m.isPersistable();
            }
        };
    }

    static String convertTypeSignatureToTypeName(String typeSignature) {
        return typeSignature == null ? null : BinaryPersistentMember.convertTypeSignatureToTypeName_(typeSignature);
    }

    static String convertTypeSignatureToTypeName_(String typeSignature) {
        return Signature.toString((String)Signature.getTypeErasure((String)typeSignature));
    }

    private IAnnotation[] getJdtAnnotations() {
        try {
            return this.adapter.getAnnotations();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log(ex);
            return EMPTY_JDT_ANNOTATION_ARRAY;
        }
    }

    @Override
    public Annotation setMappingAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Annotation addSupportingAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Annotation addSupportingAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveSupportingAnnotation(int targetIndex, int sourceIndex, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSupportingAnnotation(String annotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSupportingAnnotation(int index, String nestableAnnotationName, String containerAnnotationName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFor(String memberName, int occurrence) {
        throw new UnsupportedOperationException();
    }

    static interface Adapter {
        public IMember getMember();

        public boolean isPersistable();

        public IAnnotation[] getAnnotations() throws JavaModelException;
    }
}

