/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.binary;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryBaseTableAnnotation;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryJoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BinaryJoinTableAnnotation
extends BinaryBaseTableAnnotation
implements JoinTableAnnotation {
    private final Vector<JoinColumnAnnotation> joinColumns = this.buildJoinColumns();
    private final Vector<JoinColumnAnnotation> inverseJoinColumns = this.buildInverseJoinColumns();

    public BinaryJoinTableAnnotation(JavaResourceNode parent, IAnnotation jdtAnnotation) {
        super(parent, jdtAnnotation);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.JoinTable";
    }

    @Override
    public void update() {
        super.update();
        this.updateJoinColumns();
        this.updateInverseJoinColumns();
    }

    @Override
    String getNameElementName() {
        return "name";
    }

    @Override
    String getSchemaElementName() {
        return "schema";
    }

    @Override
    String getCatalogElementName() {
        return "catalog";
    }

    @Override
    String getUniqueConstraintElementName() {
        return "uniqueConstraints";
    }

    @Override
    public ListIterator<JoinColumnAnnotation> joinColumns() {
        return new CloneListIterator(this.joinColumns);
    }

    @Override
    public int joinColumnsSize() {
        return this.joinColumns.size();
    }

    @Override
    public JoinColumnAnnotation joinColumnAt(int index) {
        return this.joinColumns.get(index);
    }

    @Override
    public int indexOfJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.joinColumns.indexOf(joinColumn);
    }

    @Override
    public JoinColumnAnnotation addJoinColumn(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveJoinColumn(int targetIndex, int sourceIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeJoinColumn(int index) {
        throw new UnsupportedOperationException();
    }

    private Vector<JoinColumnAnnotation> buildJoinColumns() {
        Object[] jdtJoinColumns = this.getJdtMemberValues("joinColumns");
        Vector<JoinColumnAnnotation> result = new Vector<JoinColumnAnnotation>(jdtJoinColumns.length);
        Object[] objectArray = jdtJoinColumns;
        int n = jdtJoinColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Object jdtJoinColumn = objectArray[n2];
            result.add(new BinaryJoinColumnAnnotation(this, (IAnnotation)jdtJoinColumn));
            ++n2;
        }
        return result;
    }

    private void updateJoinColumns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<JoinColumnAnnotation> inverseJoinColumns() {
        return new CloneListIterator(this.inverseJoinColumns);
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.inverseJoinColumns.size();
    }

    @Override
    public JoinColumnAnnotation inverseJoinColumnAt(int index) {
        return this.inverseJoinColumns.get(index);
    }

    @Override
    public int indexOfInverseJoinColumn(JoinColumnAnnotation joinColumn) {
        return this.inverseJoinColumns.indexOf(joinColumn);
    }

    @Override
    public JoinColumnAnnotation addInverseJoinColumn(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveInverseJoinColumn(int targetIndex, int sourceIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeInverseJoinColumn(int index) {
        throw new UnsupportedOperationException();
    }

    private Vector<JoinColumnAnnotation> buildInverseJoinColumns() {
        Object[] jdtJoinColumns = this.getJdtMemberValues("inverseJoinColumns");
        Vector<JoinColumnAnnotation> result = new Vector<JoinColumnAnnotation>(jdtJoinColumns.length);
        Object[] objectArray = jdtJoinColumns;
        int n = jdtJoinColumns.length;
        int n2 = 0;
        while (n2 < n) {
            Object jdtJoinColumn = objectArray[n2];
            result.add(new BinaryJoinColumnAnnotation(this, (IAnnotation)jdtJoinColumn));
            ++n2;
        }
        return result;
    }

    private void updateInverseJoinColumns() {
        throw new UnsupportedOperationException();
    }
}

