/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmPersistentAttribute
extends AbstractXmlContextNode
implements OrmPersistentAttribute {
    protected final OrmPersistentAttribute.Owner owner;
    protected OrmAttributeMapping attributeMapping;
    protected JavaPersistentAttribute javaPersistentAttribute;

    protected AbstractOrmPersistentAttribute(OrmPersistentType parent, OrmPersistentAttribute.Owner owner, XmlAttributeMapping resourceMapping) {
        super(parent);
        this.owner = owner;
        this.attributeMapping = this.buildAttributeMapping(resourceMapping);
        this.javaPersistentAttribute = this.findJavaPersistentAttribute();
    }

    public XmlAttributeMapping getResourceAttributeMapping() {
        return this.attributeMapping.getResourceAttributeMapping();
    }

    @Override
    public JavaPersistentAttribute getJavaPersistentAttribute() {
        return this.javaPersistentAttribute;
    }

    protected void setJavaPersistentAttribute(JavaPersistentAttribute javaPersistentAttribute) {
        JavaPersistentAttribute old = this.javaPersistentAttribute;
        this.javaPersistentAttribute = javaPersistentAttribute;
        this.firePropertyChanged("javaPersistentAttribute", old, javaPersistentAttribute);
    }

    protected OrmAttributeMapping buildAttributeMapping(XmlAttributeMapping resourceMapping) {
        return this.getJpaPlatform().buildOrmAttributeMappingFromMappingKey(this, resourceMapping);
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.orm.persistentAttribute";
    }

    @Override
    public AccessType getAccess() {
        return this.getSpecifiedAccess() != null ? this.getSpecifiedAccess() : this.getDefaultAccess();
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.getPersistentType().getAccess();
    }

    @Override
    public String getName() {
        return this.attributeMapping.getName();
    }

    @Override
    public void nameChanged(String oldName, String newName) {
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public OrmAttributeMapping getSpecifiedMapping() {
        return this.attributeMapping;
    }

    @Override
    public OrmAttributeMapping getMapping() {
        return this.attributeMapping;
    }

    @Override
    public String getMappingKey() {
        return this.attributeMapping.getKey();
    }

    @Override
    public String getDefaultMappingKey() {
        return null;
    }

    @Override
    public void setSpecifiedMappingKey(String newMappingKey) {
        if (this.getMappingKey() == newMappingKey) {
            return;
        }
        OrmAttributeMapping oldMapping = this.attributeMapping;
        XmlAttributeMapping resourceAttributeMapping = this.getJpaPlatform().buildOrmResourceAttributeMapping(newMappingKey, this.getContentType());
        this.attributeMapping = this.buildAttributeMapping(resourceAttributeMapping);
        this.getPersistentType().changeMapping(this, oldMapping, this.attributeMapping);
        this.firePropertyChanged("specifiedMapping", oldMapping, this.attributeMapping);
    }

    @Override
    public OrmPersistentType getPersistentType() {
        return (OrmPersistentType)this.getParent();
    }

    @Override
    public OrmTypeMapping getTypeMapping() {
        return this.getPersistentType().getMapping();
    }

    @Override
    public boolean isVirtual() {
        return this.getPersistentType().containsVirtualPersistentAttribute(this);
    }

    @Override
    public void makeVirtual() {
        if (this.isVirtual()) {
            throw new IllegalStateException("Attribute is already virtual");
        }
        this.getPersistentType().makePersistentAttributeVirtual(this);
    }

    @Override
    public void makeSpecified() {
        if (!this.isVirtual()) {
            throw new IllegalStateException("Attribute is already specified");
        }
        if (this.getMappingKey() == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
            throw new IllegalStateException("Use makeSpecified(String) instead and specify a mapping type");
        }
        this.getPersistentType().makePersistentAttributeSpecified(this);
    }

    @Override
    public void makeSpecified(String mappingKey) {
        if (!this.isVirtual()) {
            throw new IllegalStateException("Attribute is already specified");
        }
        this.getPersistentType().makePersistentAttributeSpecified(this, mappingKey);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.attributeMapping.getPrimaryKeyColumnName();
    }

    @Override
    public boolean isOverridableAttribute() {
        return this.attributeMapping.isOverridableAttributeMapping();
    }

    @Override
    public boolean isOverridableAssociation() {
        return this.attributeMapping.isOverridableAssociationMapping();
    }

    @Override
    public boolean isIdAttribute() {
        return this.attributeMapping.isIdMapping();
    }

    @Override
    public void update() {
        this.attributeMapping.update();
        this.setJavaPersistentAttribute(this.findJavaPersistentAttribute());
        this.owner.updateJavaPersistentAttribute();
    }

    protected JavaPersistentAttribute findJavaPersistentAttribute() {
        return this.owner.findJavaPersistentAttribute(this);
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        return this;
    }

    @Override
    public IContentType getContentType() {
        return this.getPersistentType().getContentType();
    }

    @Override
    public boolean contains(int textOffset) {
        if (this.isVirtual()) {
            return false;
        }
        return this.attributeMapping.contains(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        if (this.isVirtual()) {
            return null;
        }
        return this.attributeMapping.getSelectionTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttribute(messages);
        this.validateModifiers(messages);
        this.attributeMapping.validate(messages, reporter);
    }

    protected void validateAttribute(List<IMessage> messages) {
        if (this.javaPersistentAttribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNRESOLVED_NAME", new String[]{this.getName(), this.getPersistentType().getMapping().getClass_()}, this.attributeMapping, this.attributeMapping.getNameTextRange()));
        }
    }

    protected void validateModifiers(List<IMessage> messages) {
        if (this.getMappingKey() == "transient") {
            return;
        }
        if (this.javaPersistentAttribute == null) {
            return;
        }
        if (this.javaPersistentAttribute.isField()) {
            if (this.javaPersistentAttribute.isFinal()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_FINAL_FIELD"));
            }
            if (this.javaPersistentAttribute.isPublic()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_PUBLIC_FIELD"));
            }
        }
    }

    protected IMessage buildAttributeMessage(String msgID) {
        return DefaultJpaValidationMessages.buildMessage(1, msgID, new String[]{this.getName()}, this, this.getValidationTextRange());
    }

    @Override
    public TextRange getValidationTextRange() {
        if (this.isVirtual()) {
            return this.getPersistentType().getMapping().getAttributesTextRange();
        }
        return this.attributeMapping.getValidationTextRange();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public void dispose() {
    }
}

