/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.context.JpaRootContextNode;
import org.eclipse.jpt.core.context.MappingFileRoot;
import org.eclipse.jpt.core.context.persistence.Persistence;
import org.eclipse.jpt.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.core.internal.context.AbstractJpaContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.xml.JpaXmlResource;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationCancelledException;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericRootContextNode
extends AbstractJpaContextNode
implements JpaRootContextNode {
    protected final JpaProject jpaProject;
    protected PersistenceXml persistenceXml;

    public GenericRootContextNode(JpaProject jpaProject) {
        super(null);
        if (jpaProject == null) {
            throw new NullPointerException();
        }
        this.jpaProject = jpaProject;
        JpaXmlResource resource = this.getPersistenceXmlResource();
        if (resource != null) {
            this.persistenceXml = this.buildPersistenceXml(resource);
        }
    }

    @Override
    protected boolean requiresParent() {
        return false;
    }

    @Override
    public JpaProject getJpaProject() {
        return this.jpaProject;
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    protected IProject getProject() {
        return this.jpaProject.getProject();
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return null;
    }

    @Override
    public MappingFileRoot getMappingFileRoot() {
        return null;
    }

    @Override
    public PersistenceXml getPersistenceXml() {
        return this.persistenceXml;
    }

    protected void setPersistenceXml(PersistenceXml persistenceXml) {
        PersistenceXml old = this.persistenceXml;
        this.persistenceXml = persistenceXml;
        this.firePropertyChanged("persistenceXml", old, persistenceXml);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        JpaXmlResource resource = this.getPersistenceXmlResource();
        if (resource != null) {
            if (this.persistenceXml == null) {
                this.setPersistenceXml(this.buildPersistenceXml(resource));
            } else {
                this.persistenceXml.update(resource);
            }
        } else {
            this.setPersistenceXml(null);
        }
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.persistenceXml != null) {
            this.persistenceXml.postUpdate();
        }
    }

    protected JpaXmlResource getPersistenceXmlResource() {
        return this.jpaProject.getPersistenceXmlResource();
    }

    protected PersistenceXml buildPersistenceXml(JpaXmlResource resource) {
        return this.getJpaFactory().buildPersistenceXml(this, resource);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        if (reporter.isCancelled()) {
            throw new ValidationCancelledException();
        }
        if (this.persistenceXml == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, this.buildMissingFileMessageID(), this));
            return;
        }
        if (!this.jpaProject.discoversAnnotatedClasses()) {
            this.validateOrphanClasses(messages);
        }
        this.persistenceXml.validate(messages, reporter);
    }

    protected String buildMissingFileMessageID() {
        return this.getPlatformFile().exists() ? "PERSISTENCE_XML_INVALID_CONTENT" : "PROJECT_NO_PERSISTENCE_XML";
    }

    protected IFile getPlatformFile() {
        return this.jpaProject.convertToPlatformFile("META-INF/persistence.xml");
    }

    protected void validateOrphanClasses(List<IMessage> messages) {
        Persistence persistence = this.persistenceXml.getPersistence();
        if (persistence == null) {
            return;
        }
        if (persistence.persistenceUnitsSize() != 1) {
            return;
        }
        PersistenceUnit persistenceUnit = persistence.persistenceUnits().next();
        HashBag annotatedClassNames = CollectionTools.bag(this.jpaProject.annotatedClassNames());
        HashBag orphans = annotatedClassNames.clone();
        for (String annotatedClassName : annotatedClassNames) {
            if (!persistenceUnit.specifiesPersistentType(annotatedClassName)) continue;
            orphans.remove((Object)annotatedClassName);
        }
        for (String orphan : orphans) {
            JavaResourcePersistentType jrpt = this.jpaProject.getJavaResourcePersistentType(orphan);
            JavaResourceCompilationUnit jrcu = jrpt.getJavaResourceCompilationUnit();
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNSPECIFIED_CONTEXT", new String[]{persistenceUnit.getName()}, jrcu.getFile(), jrpt.getMappingAnnotation().getTextRange(jrcu.buildASTRoot())));
        }
    }
}

