/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.eclipselink.ui.internal.mappings.details;

import org.eclipse.jpt.eclipselink.core.context.ReadOnly;
import org.eclipse.jpt.eclipselink.ui.internal.mappings.EclipseLinkUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyComposite
extends FormPane<ReadOnly> {
    public ReadOnlyComposite(FormPane<?> parentPane, PropertyValueModel<? extends ReadOnly> subjectHolder, Composite parent) {
        super(parentPane, subjectHolder, parent);
    }

    protected void initializeLayout(Composite container) {
        this.addTriStateCheckBoxWithDefault(container, EclipseLinkUiMappingsMessages.ReadOnlyComposite_readOnlyLabel, this.buildReadOnlyHolder(), this.buildReadOnlyStringHolder(), null);
    }

    private WritablePropertyValueModel<Boolean> buildReadOnlyHolder() {
        return new PropertyAspectAdapter<ReadOnly, Boolean>(this.getSubjectHolder(), new String[]{"defaultReadOnly", "specifiedReadOnly"}){

            protected Boolean buildValue_() {
                return ((ReadOnly)this.subject).getSpecifiedReadOnly();
            }

            protected void setValue_(Boolean value) {
                ((ReadOnly)this.subject).setSpecifiedReadOnly(value);
            }

            protected void subjectChanged() {
                Object oldValue = this.getValue();
                super.subjectChanged();
                Object newValue = this.getValue();
                if (oldValue == newValue && newValue == null) {
                    this.fireAspectChange(Boolean.TRUE, newValue);
                }
            }
        };
    }

    private PropertyValueModel<String> buildReadOnlyStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildReadOnlyHolder()){

            protected String transform(Boolean value) {
                if (ReadOnlyComposite.this.getSubject() != null && value == null) {
                    boolean defaultValue = ((ReadOnly)ReadOnlyComposite.this.getSubject()).isDefaultReadOnly();
                    String defaultStringValue = defaultValue ? JptUiMappingsMessages.Boolean_True : JptUiMappingsMessages.Boolean_False;
                    return NLS.bind((String)EclipseLinkUiMappingsMessages.ReadOnlyComposite_readOnlyWithDefault, (Object)defaultStringValue);
                }
                return EclipseLinkUiMappingsMessages.ReadOnlyComposite_readOnlyLabel;
            }
        };
    }
}

