/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.css.core.internal.document.CSSStructuredDocumentRegionContainer;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public class CSSModelCreationContext {
    private CSSNodeImpl fRootNode = null;
    private CSSNodeImpl fTargetNode = null;
    private CSSNodeImpl fNextNode = null;
    private int fReparseStart = -1;
    private int fReparseEnd = -1;

    CSSModelCreationContext(CSSNodeImpl rootNode) {
        this.fRootNode = rootNode;
    }

    void clear() {
        this.fNextNode = null;
        this.fTargetNode = null;
        this.resetReparseRange();
    }

    public CSSNodeImpl getNextNode() {
        return this.fNextNode;
    }

    int getReparseEnd() {
        return this.fReparseEnd;
    }

    int getReparseStart() {
        return this.fReparseStart;
    }

    CSSNodeImpl getRootNode() {
        return this.fRootNode;
    }

    public CSSNodeImpl getTargetNode() {
        return this.fTargetNode;
    }

    boolean isToReparse() {
        return this.getReparseStart() >= 0 && this.getReparseEnd() >= 0;
    }

    void resetReparseRange() {
        this.fReparseEnd = -1;
        this.fReparseStart = -1;
    }

    void setLast() {
        this.fNextNode = null;
        if (!(this.fRootNode instanceof CSSStructuredDocumentRegionContainer)) {
            this.fTargetNode = this.fRootNode;
        } else {
            IStructuredDocumentRegion lastStructuredDocumentRegion = ((CSSStructuredDocumentRegionContainer)this.fRootNode).getLastStructuredDocumentRegion();
            CSSNodeImpl node = this.fRootNode;
            while (node != null) {
                ICSSNode lastChild = node.getLastChild();
                if (!(lastChild instanceof CSSStructuredDocumentRegionContainer) || ((CSSStructuredDocumentRegionContainer)lastChild).getLastStructuredDocumentRegion() != lastStructuredDocumentRegion) break;
                node = (CSSNodeImpl)lastChild;
            }
            this.fTargetNode = node;
        }
    }

    void setNextNode(ICSSNode node) {
        this.fNextNode = (CSSNodeImpl)node;
        if (this.fNextNode != null) {
            this.fTargetNode = (CSSNodeImpl)this.fNextNode.getParentNode();
        }
    }

    void setReparseEnd(int end) {
        this.fReparseEnd = end;
    }

    void setReparseStart(int start) {
        this.fReparseStart = start;
    }

    void setTargetNode(ICSSNode node) {
        this.fTargetNode = (CSSNodeImpl)node;
        if (this.fNextNode != null && this.fNextNode.getParentNode() != this.fTargetNode) {
            this.fNextNode = null;
        }
    }
}

