/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.msft.internal.sqlserver.models;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.core.util.CatalogLoaderOverrideManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilterListener;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.DatabaseConnectionRegistry;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCRoutineLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableLoader;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCUserDefinedTypeLoader;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.loaders.SQL2005RoutineLoader;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.loaders.SQL2005TableLoader;
import org.eclipse.datatools.enablement.msft.internal.sqlserver.loaders.SQL2005UDTypeLoader;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataTypesPackage;
import org.eclipse.datatools.modelbase.sql.routines.SQLRoutinesPackage;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.impl.SchemaImpl;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SqlServerSchema
extends SchemaImpl
implements ICatalogObject {
    private Boolean tablesLoaded = Boolean.FALSE;
    private SoftReference tableLoaderRef;
    private Boolean routinesLoaded = Boolean.FALSE;
    private SoftReference routineLoaderRef;
    private Boolean udtsLoaded = Boolean.FALSE;
    private SoftReference udtLoaderRef;
    private transient ConnectionFilterListener filterListener = new ConnectionFilterListener(){

        public void connectionFilterAdded(String filterKey) {
            SqlServerSchema.this.handleFilterChanged(filterKey);
        }

        public void connectionFilterRemoved(String filterKey) {
            SqlServerSchema.this.handleFilterChanged(filterKey);
        }
    };

    public NotificationChain basicSetCatalog(Catalog newCatalog, NotificationChain msgs) {
        ConnectionInfo connectionInfo;
        if (this.catalog != null && this.catalog.getDatabase() != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.catalog.getDatabase());
            connectionInfo.removeFilterListener(this.filterListener);
        }
        if (newCatalog != null && newCatalog.getDatabase() != null) {
            connectionInfo = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(newCatalog.getDatabase());
            connectionInfo.addFilterListener(this.filterListener);
        }
        return super.basicSetCatalog(newCatalog, msgs);
    }

    protected JDBCRoutineLoader createRoutineLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLRoutinesPackage.eINSTANCE.getRoutine().getInstanceClassName());
        if (loader != null) {
            JDBCRoutineLoader routineLoader = (JDBCRoutineLoader)loader;
            routineLoader.setCatalogObject((ICatalogObject)this);
            return routineLoader;
        }
        return new SQL2005RoutineLoader(this);
    }

    protected JDBCTableLoader createTableLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLTablesPackage.eINSTANCE.getTable().getInstanceClassName());
        if (loader != null) {
            JDBCTableLoader tableLoader = (JDBCTableLoader)loader;
            tableLoader.setCatalogObject((ICatalogObject)this);
            return tableLoader;
        }
        return new SQL2005TableLoader(this);
    }

    protected JDBCUserDefinedTypeLoader createUDTLoader() {
        DatabaseDefinition databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getCatalogDatabase());
        JDBCBaseLoader loader = CatalogLoaderOverrideManager.INSTANCE.getLoaderForDatabase(databaseDefinition, SQLDataTypesPackage.eINSTANCE.getUserDefinedType().getInstanceClassName());
        if (loader != null) {
            JDBCUserDefinedTypeLoader udtLoader = (JDBCUserDefinedTypeLoader)loader;
            udtLoader.setCatalogObject((ICatalogObject)this);
            return udtLoader;
        }
        return new JDBCUserDefinedTypeLoader((ICatalogObject)this);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 9: {
                this.getTables();
                break;
            }
            case 16: {
                this.getRoutines();
                break;
            }
            case 14: {
                this.getUserDefinedTypes();
            }
        }
        return super.eIsSet(eFeature);
    }

    public Database getCatalogDatabase() {
        return this.getCatalog().getDatabase();
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    private String getRoutineFilterKey() {
        return String.valueOf(this.getCatalog().getName()) + "::" + this.getName() + "::" + "DatatoolsSPFilterPredicate";
    }

    protected final JDBCRoutineLoader getRoutineLoader() {
        if (this.routineLoaderRef == null || this.routineLoaderRef.get() == null) {
            this.routineLoaderRef = new SoftReference<JDBCRoutineLoader>(this.createRoutineLoader());
        }
        return (JDBCRoutineLoader)this.routineLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getRoutines() {
        Boolean bl = this.routinesLoaded;
        synchronized (bl) {
            if (!this.routinesLoaded.booleanValue()) {
                this.loadRoutines();
            }
        }
        return super.getRoutines();
    }

    private String getTableFilterKey() {
        return String.valueOf(this.getCatalog().getName()) + "::" + this.getName() + "::" + "DatatoolsTableFilterPredicate";
    }

    protected final JDBCTableLoader getTableLoader() {
        if (this.tableLoaderRef == null || this.tableLoaderRef.get() == null) {
            this.tableLoaderRef = new SoftReference<JDBCTableLoader>(this.createTableLoader());
        }
        return (JDBCTableLoader)this.tableLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getTables() {
        Boolean bl = this.tablesLoaded;
        synchronized (bl) {
            if (!this.tablesLoaded.booleanValue()) {
                this.loadTables();
            }
        }
        return super.getTables();
    }

    private String getUDTFilterKey() {
        return String.valueOf(this.getCatalog().getName()) + "::" + this.getName() + "::" + "DatatoolsUDTFilterPredicate";
    }

    protected final JDBCUserDefinedTypeLoader getUDTLoader() {
        if (this.udtLoaderRef == null || this.udtLoaderRef.get() == null) {
            this.udtLoaderRef = new SoftReference<SQL2005UDTypeLoader>(new SQL2005UDTypeLoader(this));
        }
        return (JDBCUserDefinedTypeLoader)this.udtLoaderRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getUserDefinedTypes() {
        Boolean bl = this.udtsLoaded;
        synchronized (bl) {
            if (!this.routinesLoaded.booleanValue()) {
                this.loadUDTs();
            }
        }
        return super.getUserDefinedTypes();
    }

    private void handleFilterChanged(String filterKey) {
        boolean refresh = false;
        if (this.catalog == null || this.catalog.getDatabase() == null) {
            return;
        }
        ConnectionInfo conInf = DatabaseConnectionRegistry.getInstance().getConnectionForDatabase(this.getCatalogDatabase());
        if (this.tablesLoaded.booleanValue() && filterKey.equals(this.getTableFilterKey()) || conInf != null && conInf.getFilter(this.getTableFilterKey()) == null && ("DatatoolsTableFilterPredicate".equals(filterKey) || filterKey.equals(String.valueOf(this.getCatalog().getName()) + "::" + "DatatoolsTableFilterPredicate"))) {
            this.tablesLoaded = Boolean.FALSE;
            this.getTableLoader().clearTables((List)super.getTables());
            refresh = true;
        }
        if (this.routinesLoaded.booleanValue() && filterKey.equals(this.getRoutineFilterKey()) || conInf != null && conInf.getFilter(this.getRoutineFilterKey()) == null && ("DatatoolsSPFilterPredicate".equals(filterKey) || filterKey.equals(String.valueOf(this.getCatalog().getName()) + "::" + "DatatoolsSPFilterPredicate"))) {
            this.routinesLoaded = Boolean.FALSE;
            this.getRoutineLoader().clearRoutines((List)super.getRoutines());
            refresh = true;
        }
        if (this.udtsLoaded.booleanValue() && filterKey.equals(this.getUDTFilterKey()) || conInf != null && conInf.getFilter(this.getUDTFilterKey()) == null && ("DatatoolsUDTFilterPredicate".equals(filterKey) || filterKey.equals(String.valueOf(this.getCatalog().getName()) + "::" + "DatatoolsUDTFilterPredicate"))) {
            this.udtsLoaded = Boolean.FALSE;
            this.getUDTLoader().clearUDTs((List)super.getUserDefinedTypes());
            refresh = true;
        }
        if (refresh) {
            RefreshManager.getInstance().referesh((ICatalogObject)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRoutines() {
        Boolean bl = this.routinesLoaded;
        synchronized (bl) {
            block8: {
                boolean deliver = this.eDeliver();
                try {
                    try {
                        EList container = super.getRoutines();
                        ArrayList existingRoutines = new ArrayList(container);
                        this.eSetDeliver(false);
                        container.clear();
                        this.getRoutineLoader().loadRoutines((List)container, existingRoutines);
                        this.getRoutineLoader().clearRoutines(existingRoutines);
                        this.routinesLoaded = Boolean.TRUE;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.eSetDeliver(deliver);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.eSetDeliver(deliver);
                    throw throwable;
                }
                this.eSetDeliver(deliver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTables() {
        Boolean bl = this.tablesLoaded;
        synchronized (bl) {
            block8: {
                boolean deliver = this.eDeliver();
                try {
                    try {
                        EList container = super.getTables();
                        ArrayList existingTables = new ArrayList(container);
                        this.eSetDeliver(false);
                        container.clear();
                        this.getTableLoader().loadTables((List)container, existingTables);
                        this.getTableLoader().clearTables(existingTables);
                        this.tablesLoaded = Boolean.TRUE;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.eSetDeliver(deliver);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.eSetDeliver(deliver);
                    throw throwable;
                }
                this.eSetDeliver(deliver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUDTs() {
        Boolean bl = this.routinesLoaded;
        synchronized (bl) {
            block8: {
                boolean deliver = this.eDeliver();
                try {
                    try {
                        EList container = super.getUserDefinedTypes();
                        ArrayList existingUDTs = new ArrayList(container);
                        this.eSetDeliver(false);
                        container.clear();
                        this.getUDTLoader().loadUDTs((List)container, existingUDTs);
                        this.getUDTLoader().clearUDTs(existingUDTs);
                        this.udtsLoaded = Boolean.TRUE;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.eSetDeliver(deliver);
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.eSetDeliver(deliver);
                    throw throwable;
                }
                this.eSetDeliver(deliver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.tablesLoaded;
        synchronized (bl) {
            if (this.tablesLoaded.booleanValue()) {
                this.tablesLoaded = Boolean.FALSE;
            }
        }
        bl = this.routinesLoaded;
        synchronized (bl) {
            if (this.routinesLoaded.booleanValue()) {
                this.routinesLoaded = Boolean.FALSE;
            }
        }
        bl = this.udtsLoaded;
        synchronized (bl) {
            if (this.udtsLoaded.booleanValue()) {
                this.udtsLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }
}

