/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.apache.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.eclipse.datatools.connectivity.apache.internal.derby.catalog.DerbySchemaLoader;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.impl.TriggerImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class DerbyCatalogTrigger
extends TriggerImpl
implements ICatalogObject {
    private static final long serialVersionUID = 3976740254881363508L;
    private boolean columnLoaded = false;

    public void refresh() {
        if (this.columnLoaded) {
            this.triggerColumn.clear();
            this.columnLoaded = false;
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public EList getTriggerColumn() {
        if (!this.columnLoaded) {
            this.loadColumn();
        }
        return this.triggerColumn;
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    public Database getCatalogDatabase() {
        if (this.getSchema().getDatabase() != null) {
            return this.getSchema().getDatabase();
        }
        return this.getSchema().getCatalog().getDatabase();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 10) {
            this.getTriggerColumn();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadColumn() {
        if (this.columnLoaded || !this.isUpdateType()) {
            return;
        }
        EList columnList = super.getTriggerColumn();
        Connection connection = this.getConnection();
        if (connection == null) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            String query = "SELECT REFERENCEDCOLUMNS FROM SYS.SYSTRIGGERS A, SYS.SYSTABLES B, SYS.SYSSCHEMAS C WHERE A.TABLEID=B.TABLEID AND B.TABLENAME='" + this.getSubjectTable() + "'" + " AND A.SCHEMAID=C.SCHEMAID";
            Statement s = connection.createStatement();
            String currentSchema = DerbySchemaLoader.setSchema(s, "SYS");
            ResultSet r = s.executeQuery(query);
            while (r.next()) {
                String colName = r.getString("REFERENCEDCOLUMNS");
                columnList.add((Object)this.getColumn(colName));
            }
            this.columnLoaded = true;
            r.close();
            DerbySchemaLoader.setSchema(s, currentSchema);
            s.close();
        }
        catch (Exception exception) {}
        this.eSetDeliver(deliver);
    }

    private Column getColumn(String columnName) {
        for (Column c : this.getSubjectTable().getColumns()) {
            if (!c.getName().equals(columnName)) continue;
            return c;
        }
        return null;
    }
}

