/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.ui.wizards.imports.BaseImportWizardSecondPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportOperation;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardDetailedPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardExpressPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class PluginImportWizard
extends Wizard
implements IImportWizard {
    private static final String STORE_SECTION = "PluginImportWizard";
    private IStructuredSelection selection;
    private PluginImportWizardFirstPage page1;
    private BaseImportWizardSecondPage page2;
    private BaseImportWizardSecondPage page3;

    public PluginImportWizard() {
        IDialogSettings masterSettings = PDEPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_PLUGIN_IMPORT_WIZ);
        this.setWindowTitle(PDEUIMessages.ImportWizard_title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.setNeedsProgressMonitor(true);
        this.page1 = new PluginImportWizardFirstPage("first");
        this.addPage((IWizardPage)this.page1);
        this.page2 = new PluginImportWizardExpressPage("express", this.page1, this.selection);
        this.addPage((IWizardPage)this.page2);
        this.page3 = new PluginImportWizardDetailedPage("detailed", this.page1);
        this.addPage((IWizardPage)this.page3);
    }

    private IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings setting = master.getSection(STORE_SECTION);
        if (setting == null) {
            setting = master.addNewSection(STORE_SECTION);
        }
        return setting;
    }

    private IPluginModelBase[] getModelsToImport() {
        if (this.page1.getNextPage().equals((Object)this.page2)) {
            return this.page2.getModelsToImport();
        }
        return this.page3.getModelsToImport();
    }

    public boolean performFinish() {
        this.page1.storeSettings();
        ((BaseImportWizardSecondPage)this.page1.getNextPage()).storeSettings();
        IPluginModelBase[] models = this.getModelsToImport();
        int launchedConfiguration = this.getConflictingConfigurationsCount(models);
        if (launchedConfiguration > 0) {
            String message = launchedConfiguration == 1 ? PDEUIMessages.PluginImportWizard_runningConfigDesc : PDEUIMessages.PluginImportWizard_runningConfigsDesc;
            MessageDialog dialog = new MessageDialog(this.getShell(), PDEUIMessages.PluginImportWizard_runningConfigsTitle, null, message, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            if (dialog.open() != 0) {
                return false;
            }
        }
        PluginImportWizard.doImportOperation(this.getShell(), this.page1.getImportType(), models, this.page2.forceAutoBuild(), launchedConfiguration > 0, this.page1.getAlternateSourceLocations());
        return true;
    }

    private int getConflictingConfigurationsCount(IPluginModelBase[] modelsToImport) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        int count = 0;
        ILaunch[] launches = launchManager.getLaunches();
        HashSet<String> imported = new HashSet<String>(4 * modelsToImport.length / 3 + 1);
        int j = 0;
        while (j < modelsToImport.length) {
            BundleDescription bd = modelsToImport[j].getBundleDescription();
            if (bd != null) {
                imported.add(bd.getSymbolicName());
            }
            ++j;
        }
        int i = 0;
        while (i < launches.length) {
            ILaunchConfiguration configuration;
            if (!launches[i].isTerminated() && (configuration = launches[i].getLaunchConfiguration()) != null) {
                try {
                    Map workspaceBundleMap = BundleLauncherHelper.getWorkspaceBundleMap(configuration);
                    Iterator iter = workspaceBundleMap.keySet().iterator();
                    while (iter.hasNext()) {
                        IPluginModelBase bm = (IPluginModelBase)iter.next();
                        BundleDescription description = bm.getBundleDescription();
                        if (description == null || !imported.contains(description.getSymbolicName())) continue;
                        ++count;
                        break;
                    }
                }
                catch (CoreException coreException) {
                    ++count;
                }
            }
            ++i;
        }
        return count;
    }

    public static void doImportOperation(Shell shell, int importType, IPluginModelBase[] models, boolean forceAutobuild) {
        PluginImportWizard.doImportOperation(shell, importType, models, forceAutobuild, false, null);
    }

    private static void doImportOperation(Shell shell, int importType, IPluginModelBase[] models, boolean forceAutobuild, boolean launchedConfiguration, SourceLocationManager alternateSource) {
        PluginImportOperation job = new PluginImportOperation(models, importType, forceAutobuild);
        job.setAlternateSource(alternateSource);
        job.setPluginsInUse(launchedConfiguration);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setUser(true);
        job.schedule();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.equals((Object)this.page1)) {
            if (this.page1.getScanAllPlugins()) {
                return this.page3;
            }
            return this.page2;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return page.equals((Object)this.page1) ? null : this.page1;
    }

    public boolean canFinish() {
        return !this.page1.isCurrentPage() && this.page1.getNextPage().isPageComplete();
    }
}

