/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.samples;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.samples.SampleWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;
import org.eclipse.ui.intro.config.IIntroURL;
import org.eclipse.ui.intro.config.IntroURLFactory;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.standalone.InstallCommand;
import org.osgi.framework.Version;

public class ShowSampleAction
extends Action
implements IIntroAction {
    private static final String SAMPLE_FEATURE_ID = "org.eclipse.sdk.samples";
    private static final String SAMPLE_FEATURE_VERSION = "3.3.0";
    private static final String UPDATE_SITE = "http://dev.eclipse.org/viewcvs/index.cgi/%7Echeckout%7E/pde-ui-home/samples/";
    private String sampleId;

    public void run(IIntroSite site, Properties params) {
        this.sampleId = params.getProperty("id");
        if (this.sampleId == null) {
            return;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (!ShowSampleAction.this.ensureSampleFeaturePresent()) {
                    return;
                }
                SampleWizard wizard = new SampleWizard();
                try {
                    wizard.setInitializationData(null, "class", ShowSampleAction.this.sampleId);
                    wizard.setSampleEditorNeeded(false);
                    wizard.setSwitchPerspective(false);
                    wizard.setSelectRevealEnabled(false);
                    wizard.setActivitiesEnabled(false);
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    if (dialog.open() == 0) {
                        ShowSampleAction.this.switchToSampleStandby(wizard);
                    }
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        };
        Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        currentShell.getDisplay().asyncExec(r);
    }

    private void switchToSampleStandby(SampleWizard wizard) {
        StringBuffer url = new StringBuffer();
        url.append("http://org.eclipse.ui.intro/showStandby?");
        url.append("pluginId=org.eclipse.pde.ui");
        url.append("&");
        url.append("partId=org.eclipse.pde.ui.sampleStandbyPart");
        url.append("&");
        url.append("input=");
        url.append(this.sampleId);
        IIntroURL introURL = IntroURLFactory.createIntroURL((String)url.toString());
        if (introURL != null) {
            introURL.execute();
            this.ensureProperContext(wizard);
        }
    }

    private void ensureProperContext(SampleWizard wizard) {
        IConfigurationElement sample = wizard.getSelection();
        String perspId = sample.getAttribute("perspectiveId");
        if (perspId != null) {
            try {
                wizard.enableActivities();
                PlatformUI.getWorkbench().showPerspective(perspId, PDEPlugin.getActiveWorkbenchWindow());
                wizard.selectReveal(PDEPlugin.getActiveWorkbenchShell());
            }
            catch (WorkbenchException e) {
                PDEPlugin.logException(e);
            }
        }
        this.enableActivities(sample);
    }

    private void enableActivities(IConfigurationElement sample) {
    }

    private boolean ensureSampleFeaturePresent() {
        if (this.checkFeature()) {
            return true;
        }
        if (MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.ShowSampleAction_msgTitle, (String)PDEUIMessages.ShowSampleAction_msgDesc)) {
            return this.downloadFeature();
        }
        return false;
    }

    private boolean checkFeature() {
        IPlatformConfiguration config = ConfiguratorUtils.getCurrentPlatformConfiguration();
        IPlatformConfiguration.IFeatureEntry[] features = config.getConfiguredFeatureEntries();
        Version sampleVersion = new Version(SAMPLE_FEATURE_VERSION);
        int i = 0;
        while (i < features.length) {
            String version;
            Version fversion;
            String id = features[i].getFeatureIdentifier();
            if (SAMPLE_FEATURE_ID.equals(id) && VersionUtil.isCompatibleWith((Version)(fversion = Version.parseVersion((String)(version = features[i].getFeatureVersion()))), (Version)sampleVersion)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean downloadFeature() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    InstallCommand command = new InstallCommand(ShowSampleAction.SAMPLE_FEATURE_ID, ShowSampleAction.SAMPLE_FEATURE_VERSION, ShowSampleAction.UPDATE_SITE, null, "false");
                    command.run(monitor);
                    command.applyChangesNow();
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
        }
        return true;
    }
}

