/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.BundleValidationOperation;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.launcher.VMHelper;

public abstract class LaunchValidationOperation
implements IWorkspaceRunnable {
    private BundleValidationOperation fOperation;
    protected ILaunchConfiguration fLaunchConfiguration;

    public LaunchValidationOperation(ILaunchConfiguration configuration) {
        this.fLaunchConfiguration = configuration;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        this.fOperation = new BundleValidationOperation(this.getModels(), this.getPlatformProperties());
        this.fOperation.run(monitor);
    }

    protected abstract IPluginModelBase[] getModels() throws CoreException;

    protected Dictionary[] getPlatformProperties() throws CoreException {
        IExecutionEnvironment[] envs = this.getMatchingEnvironments();
        if (envs.length == 0) {
            return new Dictionary[]{TargetPlatformHelper.getTargetEnvironment()};
        }
        ArrayList<Dictionary> result = new ArrayList<Dictionary>(envs.length);
        int i = 0;
        while (i < envs.length) {
            Properties profileProps = this.getJavaProfileProperties(envs[i].getId());
            if (profileProps != null) {
                String ee;
                Dictionary props = TargetPlatformHelper.getTargetEnvironment();
                String systemPackages = profileProps.getProperty("org.osgi.framework.system.packages");
                if (systemPackages != null) {
                    props.put("org.osgi.framework.system.packages", systemPackages);
                }
                if ((ee = profileProps.getProperty("org.osgi.framework.executionenvironment")) != null) {
                    props.put("org.osgi.framework.executionenvironment", ee);
                }
                result.add(props);
            }
            ++i;
        }
        if (result.size() > 0) {
            return result.toArray(new Dictionary[result.size()]);
        }
        return new Dictionary[]{TargetPlatformHelper.getTargetEnvironment()};
    }

    protected IExecutionEnvironment[] getMatchingEnvironments() throws CoreException {
        IVMInstall install = VMHelper.getVMInstall(this.fLaunchConfiguration);
        if (install == null) {
            return new IExecutionEnvironment[0];
        }
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment[] envs = manager.getExecutionEnvironments();
        ArrayList<IExecutionEnvironment> result = new ArrayList<IExecutionEnvironment>(envs.length);
        int i = 0;
        while (i < envs.length) {
            IExecutionEnvironment env = envs[i];
            IVMInstall[] compatible = env.getCompatibleVMs();
            int j = 0;
            while (j < compatible.length) {
                if (compatible[j].equals(install)) {
                    result.add(env);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new IExecutionEnvironment[result.size()]);
    }

    /*
     * Loose catch block
     */
    private Properties getJavaProfileProperties(String ee) {
        block36: {
            ZipFile zipFile;
            InputStream is;
            block33: {
                Properties properties;
                block34: {
                    IPluginModelBase model = PluginRegistry.findModel((String)"system.bundle");
                    if (model == null) {
                        return null;
                    }
                    File location = new File(model.getInstallLocation());
                    String filename = String.valueOf(ee.replace('/', '_')) + ".profile";
                    is = null;
                    zipFile = null;
                    if (location.isDirectory()) {
                        File file = new File(location, filename);
                        if (file.exists()) {
                            is = new FileInputStream(file);
                        }
                    } else {
                        zipFile = null;
                        try {
                            zipFile = new ZipFile(location, 1);
                            ZipEntry entry = zipFile.getEntry(filename);
                            if (entry != null) {
                                is = zipFile.getInputStream(entry);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    if (is == null) break block33;
                    Properties profile = new Properties();
                    profile.load(is);
                    properties = profile;
                    if (is == null) break block34;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return properties;
                catch (IOException iOException) {
                    block35: {
                        try {
                            if (is == null) break block35;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            if (zipFile != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException iOException3) {}
                            }
                            throw throwable;
                        }
                        try {
                            is.close();
                        }
                        catch (IOException iOException4) {}
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException5) {}
                    }
                    break block36;
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public boolean hasErrors() {
        return this.fOperation.hasErrors();
    }

    public Map getInput() {
        return this.fOperation.getResolverErrors();
    }

    public boolean isEmpty() {
        return this.fOperation.getState().getHighestBundleId() == -1L;
    }

    protected State getState() {
        return this.fOperation.getState();
    }
}

