/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.build;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.Version;
import org.eclipse.equinox.internal.provisional.p2.core.VersionRange;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.internal.provisional.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequirementChange;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.MatchQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.InstallAction;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.build.site.QualifierReplacer;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class RuntimeInstallJob
extends Job {
    private FeatureExportInfo fInfo;
    static /* synthetic */ Class class$0;

    public RuntimeInstallJob(String jobName, FeatureExportInfo info) {
        super(jobName);
        this.fInfo = info;
    }

    public static void modifyInfoForInstall(FeatureExportInfo info) {
        info.exportSource = false;
        info.useJarFormat = true;
        info.exportMetadata = true;
        info.qualifier = QualifierReplacer.getDateQualifier();
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(PDEUIMessages.RuntimeInstallJob_Job_name_installing, 12 + 2 * this.fInfo.items.length);
            URI destination = new File(this.fInfo.destinationDirectory).toURI();
            ProvisioningUtil.loadArtifactRepository((URI)destination, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IMetadataRepository metaRepo = ProvisioningUtil.loadMetadataRepository((URI)destination, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IProfile profile = ProvisioningUtil.getProfile((String)"_SELF_");
            if (profile == null) {
                Status status = new Status(4, PDEPlugin.getPluginId(), PDEUIMessages.RuntimeInstallJob_ErrorCouldntOpenProfile);
                return status;
            }
            ArrayList<Object> toInstall = new ArrayList<Object>();
            int i = 0;
            while (i < this.fInfo.items.length) {
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                monitor.subTask(NLS.bind((String)PDEUIMessages.RuntimeInstallJob_Creating_installable_unit, (Object)this.fInfo.items[i].toString()));
                String id = null;
                String version = null;
                if (this.fInfo.items[i] instanceof IPluginModelBase) {
                    id = ((IPluginModelBase)this.fInfo.items[i]).getPluginBase().getId();
                    version = ((IPluginModelBase)this.fInfo.items[i]).getPluginBase().getVersion();
                } else if (this.fInfo.items[i] instanceof IFeatureModel) {
                    id = String.valueOf(((IFeatureModel)this.fInfo.items[i]).getFeature().getId()) + ".feature.group";
                    version = ((IFeatureModel)this.fInfo.items[i]).getFeature().getVersion();
                }
                if (id == null && version == null) {
                    Status status = new Status(4, PDEPlugin.getPluginId(), NLS.bind((String)PDEUIMessages.RuntimeInstallJob_ErrorCouldNotGetIdOrVersion, (Object)this.fInfo.items[i].toString()));
                    return status;
                }
                Version newVersion = new Version(version = QualifierReplacer.replaceQualifierInVersion(version, (String)id, null, null));
                Collector queryMatches = metaRepo.query((Query)new InstallableUnitQuery(id, newVersion), new Collector(), monitor);
                if (queryMatches.size() == 0) {
                    Status status = new Status(4, PDEPlugin.getPluginId(), NLS.bind((String)PDEUIMessages.RuntimeInstallJob_ErrorCouldNotFindUnitInRepo, (Object[])new String[]{id, version}));
                    return status;
                }
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IInstallableUnit iuToInstall = (IInstallableUnit)queryMatches.toArray((Class)clazz)[0];
                queryMatches = profile.query((Query)new InstallableUnitQuery(id), new Collector(), (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                if (queryMatches.size() == 0) {
                    toInstall.add(iuToInstall);
                } else {
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Version existingVersion = ((IInstallableUnit)queryMatches.toArray((Class)clazz2)[0]).getVersion();
                    toInstall.add(this.createInstallableUnitPatch(id, newVersion, existingVersion, profile, monitor));
                }
                monitor.worked(2);
                ++i;
            }
            if (toInstall.size() > 0) {
                MultiStatus accumulatedStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, "", null);
                ProfileChangeRequest request = InstallAction.computeProfileChangeRequest((IInstallableUnit[])toInstall.toArray(new IInstallableUnit[toInstall.size()]), (String)"_SELF_", (MultiStatus)accumulatedStatus, (IProgressMonitor)monitor);
                if (request == null || accumulatedStatus.getSeverity() == 8 || !accumulatedStatus.isOK() && accumulatedStatus.getSeverity() != 1) {
                    MultiStatus multiStatus = accumulatedStatus;
                    return multiStatus;
                }
                ProvisioningPlan thePlan = ProvisioningUtil.getProvisioningPlan((ProfileChangeRequest)request, (ProvisioningContext)new ProvisioningContext(new URI[]{destination}), (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                IStatus status = thePlan.getStatus();
                if (status.getSeverity() == 8 || !status.isOK() && status.getSeverity() != 1) {
                    IStatus iStatus = status;
                    return iStatus;
                }
                IStatus iStatus = status = ProvisioningUtil.performProvisioningPlan((ProvisioningPlan)thePlan, (PhaseSet)new DefaultPhaseSet(), (IProfile)profile, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
                return iStatus;
            }
            if (monitor.isCanceled()) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (ProvisionException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private IInstallableUnitPatch createInstallableUnitPatch(final String id, Version version, final Version existingVersion, IProfile profile, IProgressMonitor monitor) {
        MetadataFactory.InstallableUnitPatchDescription iuPatchDescription = new MetadataFactory.InstallableUnitPatchDescription();
        iuPatchDescription.setId(String.valueOf(id) + ".patch");
        iuPatchDescription.setProperty("org.eclipse.equinox.p2.name", NLS.bind((String)PDEUIMessages.RuntimeInstallJob_installPatchName, (Object)id));
        iuPatchDescription.setProperty("org.eclipse.equinox.p2.description", PDEUIMessages.RuntimeInstallJob_installPatchDescription);
        Version patchVersion = new Version("1.0.0." + QualifierReplacer.getDateQualifier());
        iuPatchDescription.setVersion(patchVersion);
        iuPatchDescription.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)iuPatchDescription.getId(), (VersionRange)new VersionRange(new Version(0, 0, 0), true, patchVersion, false), (int)0, null));
        ArrayList<IProvidedCapability> list = new ArrayList<IProvidedCapability>(1);
        list.add(MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.iu", (String)iuPatchDescription.getId(), (Version)iuPatchDescription.getVersion()));
        iuPatchDescription.addProvidedCapabilities(list);
        IRequiredCapability applyTo = MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)id, null, null, (boolean)false, (boolean)false);
        IRequiredCapability newValue = MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)new VersionRange(version, true, version, true), null, (boolean)false, (boolean)false);
        iuPatchDescription.setRequirementChanges(new IRequirementChange[]{MetadataFactory.createRequirementChange((IRequiredCapability)applyTo, (IRequiredCapability)newValue)});
        iuPatchDescription.setApplicabilityScope(new IRequiredCapability[0][0]);
        Collector queryMatches = profile.query((Query)new MatchQuery(){

            public boolean isMatch(Object candidate) {
                if (candidate instanceof IInstallableUnit) {
                    IRequiredCapability[] reqs = ((IInstallableUnit)candidate).getRequiredCapabilities();
                    int i = 0;
                    while (i < reqs.length) {
                        if (reqs[i].getName().equals(id) && new VersionRange(existingVersion, true, existingVersion, true).equals((Object)reqs[i].getRange())) {
                            return true;
                        }
                        ++i;
                    }
                }
                return false;
            }
        }, new Collector(), monitor);
        if (!queryMatches.isEmpty()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IInstallableUnit lifecycleUnit = (IInstallableUnit)queryMatches.toArray((Class)clazz)[0];
            iuPatchDescription.setLifeCycle(MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)lifecycleUnit.getId(), (VersionRange)new VersionRange(lifecycleUnit.getVersion(), true, lifecycleUnit.getVersion(), true), null, (boolean)false, (boolean)false, (boolean)false));
        }
        iuPatchDescription.setProperty("org.eclipse.equinox.p2.type.patch", Boolean.TRUE.toString());
        return MetadataFactory.createInstallableUnitPatch((MetadataFactory.InstallableUnitPatchDescription)iuPatchDescription);
    }
}

