/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.model.listener.awt;

import java.awt.EventQueue;
import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;

public class AWTTreeChangeListenerWrapper
implements TreeChangeListener {
    private final TreeChangeListener listener;

    public AWTTreeChangeListenerWrapper(TreeChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void nodeAdded(TreeChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            this.nodeAdded_(event);
        } else {
            this.executeOnEventQueue(this.buildNodeAddedRunnable(event));
        }
    }

    public void nodeRemoved(TreeChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            this.nodeRemoved_(event);
        } else {
            this.executeOnEventQueue(this.buildNodeRemovedRunnable(event));
        }
    }

    public void treeCleared(TreeChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            this.treeCleared_(event);
        } else {
            this.executeOnEventQueue(this.buildTreeClearedRunnable(event));
        }
    }

    public void treeChanged(TreeChangeEvent event) {
        if (EventQueue.isDispatchThread()) {
            this.treeChanged_(event);
        } else {
            this.executeOnEventQueue(this.buildTreeChangedRunnable(event));
        }
    }

    private Runnable buildNodeAddedRunnable(final TreeChangeEvent event) {
        return new Runnable(){

            public void run() {
                AWTTreeChangeListenerWrapper.this.nodeAdded_(event);
            }

            public String toString() {
                return "node added";
            }
        };
    }

    private Runnable buildNodeRemovedRunnable(final TreeChangeEvent event) {
        return new Runnable(){

            public void run() {
                AWTTreeChangeListenerWrapper.this.nodeRemoved_(event);
            }

            public String toString() {
                return "node removed";
            }
        };
    }

    private Runnable buildTreeClearedRunnable(final TreeChangeEvent event) {
        return new Runnable(){

            public void run() {
                AWTTreeChangeListenerWrapper.this.treeCleared_(event);
            }

            public String toString() {
                return "tree cleared";
            }
        };
    }

    private Runnable buildTreeChangedRunnable(final TreeChangeEvent event) {
        return new Runnable(){

            public void run() {
                AWTTreeChangeListenerWrapper.this.treeChanged_(event);
            }

            public String toString() {
                return "tree changed";
            }
        };
    }

    private void executeOnEventQueue(Runnable r) {
        EventQueue.invokeLater(r);
    }

    void nodeAdded_(TreeChangeEvent event) {
        this.listener.nodeAdded(event);
    }

    void nodeRemoved_(TreeChangeEvent event) {
        this.listener.nodeRemoved(event);
    }

    void treeCleared_(TreeChangeEvent event) {
        this.listener.treeCleared(event);
    }

    void treeChanged_(TreeChangeEvent event) {
        this.listener.treeChanged(event);
    }

    public String toString() {
        return "AWT(" + this.listener.toString() + ")";
    }
}

