/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.Arrays;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.osgi.util.NLS;

public abstract class Explanation
implements Comparable {
    public static final int MISSING_REQUIREMENT = 1;
    public static final Explanation OPTIONAL_REQUIREMENT = new Explanation(){

        public int orderValue() {
            return 6;
        }

        public String toString() {
            return Messages.Explanation_optionalDependency;
        }
    };
    public static final int VIOLATED_SINGLETON_CONSTRAINT = 2;

    protected Explanation() {
    }

    public int compareTo(Object arg0) {
        Explanation exp = (Explanation)arg0;
        if (this.orderValue() == exp.orderValue()) {
            return this.toString().compareTo(exp.toString());
        }
        return this.orderValue() - exp.orderValue();
    }

    protected abstract int orderValue();

    public int shortAnswer() {
        throw new UnsupportedOperationException();
    }

    public IStatus toStatus() {
        return new Status(4, "org.eclipse.equinox.p2.director", this.toString());
    }

    protected String getUserReadableName(IInstallableUnit iu) {
        if (iu == null) {
            return "";
        }
        String result = this.getLocalized(iu);
        if (result == null) {
            return iu.toString();
        }
        return String.valueOf(result) + ' ' + iu.getVersion() + " (" + iu.toString() + ')';
    }

    private String getLocalized(IInstallableUnit iu) {
        String value = iu.getProperty("org.eclipse.equinox.p2.name");
        if (value == null || value.length() <= 1 || value.charAt(0) != '%') {
            return value;
        }
        String actualKey = value.substring(1);
        return iu.getProperty("df_LT." + actualKey);
    }

    public static class HardRequirement
    extends Explanation {
        public final IInstallableUnit iu;
        public final IRequiredCapability req;

        public HardRequirement(IInstallableUnit iu, IRequiredCapability req) {
            this.iu = iu;
            this.req = req;
        }

        public int orderValue() {
            return 5;
        }

        public IStatus toStatus() {
            MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.director", 1, Messages.Explanation_unsatisfied, null);
            result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_from, (Object)this.getUserReadableName(this.iu))));
            result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_to, (Object)this.req)));
            return result;
        }

        public String toString() {
            return NLS.bind((String)Messages.Explanation_hardDependency, (Object)this.iu, (Object)this.req);
        }
    }

    public static class IUInstalled
    extends Explanation {
        public final IInstallableUnit iu;

        public IUInstalled(IInstallableUnit iu) {
            this.iu = iu;
        }

        public int orderValue() {
            return 2;
        }

        public String toString() {
            return NLS.bind((String)Messages.Explanation_alreadyInstalled, (Object)this.iu);
        }

        public IStatus toStatus() {
            return new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_alreadyInstalled, (Object)this.getUserReadableName(this.iu)));
        }
    }

    public static class IUToInstall
    extends Explanation {
        public final IInstallableUnit iu;

        public IUToInstall(IInstallableUnit iu) {
            this.iu = iu;
        }

        public int orderValue() {
            return 1;
        }

        public String toString() {
            return NLS.bind((String)Messages.Explanation_toInstall, (Object)this.iu);
        }

        public IStatus toStatus() {
            return new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_toInstall, (Object)this.getUserReadableName(this.iu)));
        }
    }

    public static class MissingIU
    extends Explanation {
        public final IInstallableUnit iu;
        public final IRequiredCapability req;

        public MissingIU(IInstallableUnit iu, IRequiredCapability req) {
            this.iu = iu;
            this.req = req;
        }

        public int orderValue() {
            return 3;
        }

        public int shortAnswer() {
            return 1;
        }

        public String toString() {
            String filter = this.req.getFilter();
            if (filter == null) {
                return NLS.bind((String)Messages.Explanation_missingRequired, (Object)this.iu, (Object)this.req);
            }
            return NLS.bind((String)Messages.Explanation_missingRequiredFilter, (Object[])new Object[]{filter, this.iu, this.req});
        }

        public IStatus toStatus() {
            String filter = this.req.getFilter();
            if (filter == null) {
                return new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_missingRequired, (Object)this.getUserReadableName(this.iu), (Object)this.req));
            }
            return new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_missingRequiredFilter, (Object[])new Object[]{filter, this.getUserReadableName(this.iu), this.req}));
        }
    }

    public static class PatchedHardRequirement
    extends Explanation {
        public final IInstallableUnit iu;
        public final IInstallableUnitPatch patch;
        public final IRequiredCapability req;

        public PatchedHardRequirement(IInstallableUnit iu, IInstallableUnitPatch patch) {
            this.iu = iu;
            this.req = null;
            this.patch = patch;
        }

        public PatchedHardRequirement(IInstallableUnit iu, IRequiredCapability req, IInstallableUnitPatch patch) {
            this.iu = iu;
            this.req = req;
            this.patch = patch;
        }

        public int orderValue() {
            return 6;
        }

        public IStatus toStatus() {
            MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.director", 1, Messages.Explanation_unsatisfied, null);
            String fromString = String.valueOf(this.patch.toString()) + ' ' + this.getUserReadableName(this.iu);
            result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_fromPatch, (Object)fromString)));
            result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Explanation_to, (Object)this.req)));
            return result;
        }

        public String toString() {
            return NLS.bind((String)Messages.Explanation_patchedHardDependency, (Object[])new Object[]{this.patch, this.iu, this.req});
        }
    }

    public static class Singleton
    extends Explanation {
        public final IInstallableUnit[] ius;

        public Singleton(IInstallableUnit[] ius) {
            this.ius = ius;
        }

        public int orderValue() {
            return 4;
        }

        public int shortAnswer() {
            return 2;
        }

        public IStatus toStatus() {
            MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.director", 1, NLS.bind((String)Messages.Explanation_singleton, (Object)""), null);
            int i = 0;
            while (i < this.ius.length) {
                result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", this.getUserReadableName(this.ius[i])));
                ++i;
            }
            return result;
        }

        public String toString() {
            return NLS.bind((String)Messages.Explanation_singleton, Arrays.asList(this.ius));
        }
    }
}

