/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.patch;

import java.io.BufferedReader;
import java.io.IOException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.internal.ComparePreferencePage;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.PatchReader;
import org.eclipse.compare.internal.patch.FilePatch;
import org.eclipse.compare.internal.patch.PatchWizard;
import org.eclipse.compare.internal.patch.PatchWizardDialog;
import org.eclipse.compare.internal.patch.Utilities;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IDE;

public class ApplyPatchOperation
implements Runnable {
    private IWorkbenchPart part;
    private CompareConfiguration configuration;
    private IStorage patch;
    private IResource target;
    private ImageDescriptor patchWizardImage;
    private String patchWizardTitle;
    private boolean saveAllEditors = true;

    public static boolean isPatch(IStorage storage) throws CoreException {
        return ApplyPatchOperation.internalParsePatch(storage).length > 0;
    }

    public static IFilePatch[] parsePatch(IStorage storage) throws CoreException {
        return ApplyPatchOperation.internalParsePatch(storage);
    }

    public ApplyPatchOperation(IWorkbenchPart part, IStorage patch, IResource target, CompareConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.part = part;
        this.patch = patch;
        this.target = target;
        this.configuration = configuration;
    }

    public ApplyPatchOperation(IWorkbenchPart targetPart, IResource resource) {
        this(targetPart, null, resource, new CompareConfiguration());
    }

    public void openWizard() {
        this.saveAllEditors();
        if (this.saveAllEditors) {
            PatchWizard wizard = new PatchWizard(this.patch, this.target, this.configuration);
            if (this.patchWizardImage != null) {
                wizard.setDefaultPageImageDescriptor(this.patchWizardImage);
            }
            if (this.patchWizardTitle != null) {
                wizard.setWindowTitle(this.patchWizardTitle);
            }
            wizard.setNeedsProgressMonitor(true);
            PatchWizardDialog dialog = new PatchWizardDialog(this.getShell(), (IWizard)wizard);
            wizard.setDialog(dialog);
            dialog.open();
        }
    }

    protected Shell getShell() {
        if (this.part == null) {
            return CompareUIPlugin.getShell();
        }
        return this.part.getSite().getShell();
    }

    protected void saveAllEditors() {
        this.saveAllEditors = IDE.saveAllEditors((IResource[])new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, (!ComparePreferencePage.getSaveAllEditors() ? 1 : 0) != 0);
    }

    public void setPatchWizardTitle(String title) {
        this.patchWizardTitle = title;
    }

    public void setPatchWizardImageDescriptor(ImageDescriptor descriptor) {
        this.patchWizardImage = descriptor;
    }

    public void run() {
        this.openWizard();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IFilePatch[] internalParsePatch(IStorage storage) throws CoreException {
        IFilePatch[] iFilePatchArray;
        BufferedReader reader = Utilities.createReader(storage);
        try {
            PatchReader patchReader = new PatchReader(){

                protected FilePatch2 createFileDiff(IPath oldPath, long oldDate, IPath newPath, long newDate) {
                    return new FilePatch(oldPath, oldDate, newPath, newDate);
                }
            };
            patchReader.parse(reader);
            FilePatch2[] fileDiffs = patchReader.getAdjustedDiffs();
            IFilePatch[] filePatch = new IFilePatch[fileDiffs.length];
            int i = 0;
            while (true) {
                if (i >= fileDiffs.length) {
                    iFilePatchArray = filePatch;
                    break;
                }
                filePatch[i] = (FilePatch)fileDiffs[i];
                ++i;
            }
        }
        catch (IOException e) {
            try {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.compare", 0, e.getMessage(), (Throwable)e));
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            reader.close();
            return iFilePatchArray;
        }
        catch (IOException iOException) {}
        return iFilePatchArray;
    }
}

