/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.CompareContainer;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CompareDialog
extends TrayDialog
implements IPropertyChangeListener {
    private final CompareEditorInput fCompareEditorInput;
    private Button fCommitButton;
    private Label statusLabel;
    boolean hasSettings = true;
    private final DialogCompareContainer fContainer = new DialogCompareContainer();

    public CompareDialog(Shell shell, CompareEditorInput input) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        Assert.isNotNull((Object)input);
        this.fCompareEditorInput = input;
    }

    public boolean close() {
        if (super.close()) {
            if (this.fCompareEditorInput != null) {
                this.fCompareEditorInput.removePropertyChangeListener(this);
            }
            return true;
        }
        return false;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fCommitButton = this.createButton(parent, 0, this.getOKButtonLabel(), true);
        this.fCommitButton.setEnabled(this.isOKEnabled());
        if (this.isCancelable()) {
            this.createButton(parent, 1, this.getCancelButtonLabel(), false);
        }
    }

    private String getCancelButtonLabel() {
        return this.fCompareEditorInput.getCancelButtonLabel();
    }

    private boolean isCancelable() {
        return this.isInputEditable() || this.isElementSelectionDialog();
    }

    private String getOKButtonLabel() {
        return this.fCompareEditorInput.getOKButtonLabel();
    }

    private boolean isElementSelectionDialog() {
        return this.fCompareEditorInput.isEditionSelectionDialog();
    }

    protected boolean isInputEditable() {
        return this.fCompareEditorInput.getCompareConfiguration().isLeftEditable() || this.fCompareEditorInput.getCompareConfiguration().isRightEditable();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("DIRTY_STATE") || event.getProperty().equals(CompareEditorInput.PROP_SELECTED_EDITION)) {
            if (this.fCommitButton != null && this.fCompareEditorInput != null) {
                this.fCommitButton.setEnabled(this.isOKEnabled());
            }
        } else if (event.getProperty().equals(CompareEditorInput.PROP_TITLE)) {
            this.getShell().setText(this.fCompareEditorInput.getTitle());
        } else if (event.getProperty().equals(CompareEditorInput.PROP_TITLE_IMAGE)) {
            this.getShell().setImage(this.fCompareEditorInput.getTitleImage());
        }
    }

    private boolean isOKEnabled() {
        if (this.isInputEditable()) {
            return this.fCompareEditorInput.isDirty();
        }
        if (this.isElementSelectionDialog()) {
            return this.getSelectedElement() != null;
        }
        return true;
    }

    private Object getSelectedElement() {
        return this.fCompareEditorInput.getSelectedEdition();
    }

    protected Control createDialogArea(Composite parent2) {
        Composite parent = (Composite)super.createDialogArea(parent2);
        Control c = this.fCompareEditorInput.createContents(parent);
        c.setLayoutData((Object)new GridData(1808));
        IPreferenceStore store = this.fCompareEditorInput.getCompareConfiguration().getPreferenceStore();
        if (store != null && store.getBoolean("org.eclipse.compare.ShowMoreInfo")) {
            this.statusLabel = new Label(parent, 0);
            this.statusLabel.setLayoutData((Object)new GridData(768));
        }
        Shell shell = c.getShell();
        shell.setText(this.fCompareEditorInput.getTitle());
        shell.setImage(this.fCompareEditorInput.getTitleImage());
        CompareDialog.applyDialogFont((Control)parent);
        return parent;
    }

    public int open() {
        this.fCompareEditorInput.addPropertyChangeListener(this);
        this.fCompareEditorInput.setContainer(this.fContainer);
        return super.open();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (!this.fCompareEditorInput.okPressed()) {
                return;
            }
        } else if (buttonId == 1) {
            this.fCompareEditorInput.cancelPressed();
        }
        super.buttonPressed(buttonId);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName;
        IDialogSettings compareSettings = CompareUIPlugin.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = compareSettings.getSection(sectionName = ((Object)((Object)this)).getClass().getName());
        if (dialogSettings == null) {
            this.hasSettings = false;
            dialogSettings = compareSettings.addNewSection(sectionName);
        }
        return dialogSettings;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.getHelpContextId() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, this.getHelpContextId());
        }
    }

    public String getHelpContextId() {
        return "org.eclipse.compare.compare_dialog_context";
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        if (this.hasSettings) {
            return initialSize;
        }
        return this.getDefaultSize();
    }

    protected Point getDefaultSize() {
        int width = 0;
        int height = 0;
        Shell shell = this.getParentShell();
        if (shell != null) {
            Point parentSize = shell.getSize();
            width = parentSize.x - 100;
            height = parentSize.y - 100;
        }
        if (width < 700) {
            width = 700;
        }
        if (height < 500) {
            height = 500;
        }
        return new Point(width, height);
    }

    protected final CompareEditorInput getInput() {
        return this.fCompareEditorInput;
    }

    private class DialogCompareContainer
    extends CompareContainer {
        private DialogCompareContainer() {
        }

        public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(CompareDialog.this.getShell());
            dialog.run(fork, cancelable, runnable);
        }

        public void setStatusMessage(String message) {
            if (CompareDialog.this.statusLabel != null && !CompareDialog.this.statusLabel.isDisposed()) {
                if (message == null) {
                    CompareDialog.this.statusLabel.setText("");
                } else {
                    CompareDialog.this.statusLabel.setText(message);
                }
            }
        }
    }
}

