/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.internal.swing;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import javax.swing.Icon;
import org.eclipse.jpt.utility.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Displayable
extends Model,
Comparable<Displayable> {
    public static final String DISPLAY_STRING_PROPERTY = "displayString";
    public static final String ICON_PROPERTY = "icon";
    public static final Collator DEFAULT_COLLATOR = Collator.getInstance();
    public static final Comparator<Displayable> DEFAULT_COMPARATOR = new Comparator<Displayable>(){

        @Override
        public int compare(Displayable d1, Displayable d2) {
            if (d1 == d2) {
                return 0;
            }
            int result = DEFAULT_COLLATOR.compare(d1.displayString(), d2.displayString());
            if (result != 0) {
                return result;
            }
            result = System.identityHashCode(d1) - System.identityHashCode(d2);
            if (result != 0) {
                return result;
            }
            return -1;
        }

        public String toString() {
            return "Displayable.DEFAULT_COMPARATOR";
        }
    };

    public String displayString();

    public Icon icon();
}

