/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;

public abstract class NonEssentialElementsFilter
extends ViewerFilter {
    private static final String JAVA_EXTENSION_ID = "org.eclipse.jdt.java.ui.javaContent";
    private boolean isStateModelInitialized = false;
    private IExtensionStateModel fStateModel = null;
    private INavigatorContentService fContentService;
    private ViewerFilter fDelegateFilter;

    protected NonEssentialElementsFilter(ViewerFilter delegateFilter) {
        this.fDelegateFilter = delegateFilter;
    }

    public boolean select(Viewer viewer, Object parent, Object element) {
        if (!this.isStateModelInitialized) {
            this.initStateModel(viewer);
        }
        if (this.fContentService == null || this.fStateModel == null) {
            return true;
        }
        if (element instanceof IPackageFragment && this.isApplicable() && viewer instanceof StructuredViewer) {
            boolean isHierarchicalLayout = !this.fStateModel.getBooleanProperty("isLayoutFlat");
            try {
                IPackageFragment fragment = (IPackageFragment)element;
                if (isHierarchicalLayout && !fragment.isDefaultPackage() && fragment.hasSubpackages()) {
                    return this.hasFilteredChildren((StructuredViewer)viewer, fragment);
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return this.doSelect(viewer, parent, element);
    }

    private boolean hasFilteredChildren(StructuredViewer viewer, IPackageFragment fragment) {
        Object[] children = this.getRawChildren(viewer, fragment);
        ViewerFilter[] filters = viewer.getFilters();
        int i = 0;
        while (i < filters.length) {
            if ((children = filters[i].filter((Viewer)viewer, (Object)fragment, children)).length == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Object[] getRawChildren(StructuredViewer viewer, IPackageFragment fragment) {
        IStructuredContentProvider provider = (IStructuredContentProvider)viewer.getContentProvider();
        if (provider instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)provider).getChildren((Object)fragment);
        }
        return provider.getElements((Object)fragment);
    }

    protected boolean doSelect(Viewer viewer, Object parent, Object element) {
        return this.fDelegateFilter.select(viewer, parent, element);
    }

    private boolean isApplicable() {
        return this.fContentService != null && this.fContentService.isVisible(JAVA_EXTENSION_ID) && this.fContentService.isActive(JAVA_EXTENSION_ID);
    }

    private synchronized void initStateModel(Viewer viewer) {
        if (!this.isStateModelInitialized && viewer instanceof CommonViewer) {
            CommonViewer commonViewer = (CommonViewer)viewer;
            this.fContentService = commonViewer.getNavigatorContentService();
            this.fStateModel = this.fContentService.findStateModel(JAVA_EXTENSION_ID);
            this.isStateModelInitialized = true;
        }
    }
}

