/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite.artifact;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.p2.updatesite.artifact.UpdateSiteArtifactRepository;
import org.eclipse.equinox.internal.p2.updatesite.metadata.Messages;
import org.eclipse.equinox.internal.p2.updatesite.metadata.UpdateSiteMetadataRepositoryFactory;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.ArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactDescriptor;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStepDescriptor;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.ArtifactRepositoryFactory;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeatureEntry;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.osgi.util.NLS;

public class UpdateSiteArtifactRepositoryFactory
extends ArtifactRepositoryFactory {
    private static final String PROP_ARTIFACT_REFERENCE = "artifact.reference";
    private static final String PROP_FORCE_THREADING = "eclipse.p2.force.threading";
    private static final String PROP_FORMAT_PACKED = "packed";
    private static final String PROP_SITE_CHECKSUM = "site.checksum";
    private static final String PROTOCOL_FILE = "file";

    public IArtifactRepository create(URI location, String name, String type, Map properties) {
        return null;
    }

    public IArtifactRepository load(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        if ((flags & 1) > 0) {
            return null;
        }
        IArtifactRepository repository = this.loadRepository(location, monitor);
        try {
            this.initializeRepository(repository, location, monitor);
        }
        catch (Exception e) {
            this.resetCache(repository);
            if (e instanceof ProvisionException) {
                throw (ProvisionException)((Object)e);
            }
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            throw new ProvisionException((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.Unexpected_exception, (Object)location.toString()), (Throwable)e));
        }
        return new UpdateSiteArtifactRepository(location, repository);
    }

    private void resetCache(IArtifactRepository repository) {
        repository.setProperty(PROP_SITE_CHECKSUM, "0");
        repository.removeAll();
    }

    public IArtifactRepository loadRepository(URI location, IProgressMonitor monitor) {
        URI localRepositoryURL = UpdateSiteMetadataRepositoryFactory.getLocalRepositoryLocation(location);
        SimpleArtifactRepositoryFactory factory = new SimpleArtifactRepositoryFactory();
        try {
            return factory.load(localRepositoryURL, 0, monitor);
        }
        catch (ProvisionException provisionException) {
            String repositoryName = "update site: " + location;
            return factory.create(localRepositoryURL, repositoryName, null, null);
        }
    }

    public void initializeRepository(IArtifactRepository repository, URI location, IProgressMonitor monitor) throws ProvisionException {
        UpdateSite updateSite = UpdateSite.load(location, monitor);
        String savedChecksum = (String)repository.getProperties().get(PROP_SITE_CHECKSUM);
        if (savedChecksum != null && savedChecksum.equals(updateSite.getChecksum())) {
            return;
        }
        if (!location.getScheme().equals(PROTOCOL_FILE)) {
            repository.setProperty(PROP_FORCE_THREADING, "true");
        }
        repository.setProperty(PROP_SITE_CHECKSUM, updateSite.getChecksum());
        if (updateSite.getSite().getMirrorsURI() != null) {
            repository.setProperty("p2.mirrorsURL", updateSite.getSite().getMirrorsURI());
        }
        repository.removeAll();
        this.generateArtifactDescriptors(updateSite, repository, monitor);
    }

    private void generateArtifactDescriptors(UpdateSite updateSite, IArtifactRepository repository, IProgressMonitor monitor) throws ProvisionException {
        Feature[] features = updateSite.loadFeatures(monitor);
        HashSet<ArtifactDescriptor> allSiteArtifacts = new HashSet<ArtifactDescriptor>();
        boolean packSupported = updateSite.getSite().isPack200Supported();
        int i = 0;
        while (i < features.length) {
            Feature feature = features[i];
            IArtifactKey featureKey = FeaturesAction.createFeatureArtifactKey((String)feature.getId(), (String)feature.getVersion());
            ArtifactDescriptor featureArtifactDescriptor = new ArtifactDescriptor(featureKey);
            URI featureURL = updateSite.getFeatureURI(feature.getId(), feature.getVersion());
            featureArtifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, featureURL.toString());
            allSiteArtifacts.add(featureArtifactDescriptor);
            if (packSupported) {
                featureArtifactDescriptor = new ArtifactDescriptor(featureKey);
                featureURL = updateSite.getFeatureURI(feature.getId(), feature.getVersion());
                featureArtifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, String.valueOf(featureURL.toString()) + ".pack.gz");
                ProcessingStepDescriptor[] steps = new ProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
                featureArtifactDescriptor.setProcessingSteps(steps);
                featureArtifactDescriptor.setProperty("format", PROP_FORMAT_PACKED);
                allSiteArtifacts.add(featureArtifactDescriptor);
            }
            FeatureEntry[] featureEntries = feature.getEntries();
            int j = 0;
            while (j < featureEntries.length) {
                FeatureEntry entry = featureEntries[j];
                if (entry.isPlugin() && !entry.isRequires()) {
                    IArtifactKey key = BundlesAction.createBundleArtifactKey((String)entry.getId(), (String)entry.getVersion());
                    ArtifactDescriptor artifactDescriptor = new ArtifactDescriptor(key);
                    URI pluginURL = updateSite.getPluginURI(entry);
                    artifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, pluginURL.toString());
                    allSiteArtifacts.add(artifactDescriptor);
                    if (packSupported) {
                        key = BundlesAction.createBundleArtifactKey((String)entry.getId(), (String)entry.getVersion());
                        artifactDescriptor = new ArtifactDescriptor(key);
                        pluginURL = updateSite.getPluginURI(entry);
                        artifactDescriptor.setRepositoryProperty(PROP_ARTIFACT_REFERENCE, String.valueOf(pluginURL.toString()) + ".pack.gz");
                        ProcessingStepDescriptor[] steps = new ProcessingStepDescriptor[]{new ProcessingStepDescriptor("org.eclipse.equinox.p2.processing.Pack200Unpacker", null, true)};
                        artifactDescriptor.setProcessingSteps(steps);
                        artifactDescriptor.setProperty("format", PROP_FORMAT_PACKED);
                        allSiteArtifacts.add(artifactDescriptor);
                    }
                }
                ++j;
            }
            ++i;
        }
        IArtifactDescriptor[] descriptors = allSiteArtifacts.toArray(new IArtifactDescriptor[allSiteArtifacts.size()]);
        repository.addDescriptors(descriptors);
    }
}

