/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAccess;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.VisibilityModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiField;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMethod;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchReporter;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLApiSearchReporter
implements IApiSearchReporter {
    public static final String TYPE_REFERENCES = "type_references";
    public static final String METHOD_REFERENCES = "method_references";
    public static final String FIELD_REFERENCES = "field_references";
    private String fLocation = null;
    private HashMap fReferenceMap = null;
    private IApiDescription fDescription = null;
    private DocumentBuilder parser = null;
    private boolean debug = false;

    public XMLApiSearchReporter(String location, boolean debug) {
        this.fLocation = location;
        this.debug = debug;
        try {
            this.parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.parser.setErrorHandler(new DefaultHandler());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (ParserConfigurationException parserConfigurationException) {}
    }

    public void reportResults(IApiElement element, IReference[] references) {
        if (this.fLocation != null) {
            try {
                try {
                    File parent = new File(this.fLocation);
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    this.collateResults(references);
                    this.writeXML(parent);
                }
                catch (Exception e) {
                    ApiPlugin.log(e);
                    if (this.fReferenceMap != null) {
                        this.fReferenceMap.clear();
                        this.fReferenceMap = null;
                    }
                }
            }
            finally {
                if (this.fReferenceMap != null) {
                    this.fReferenceMap.clear();
                    this.fReferenceMap = null;
                }
            }
        }
    }

    private void collateResults(IReference[] references) throws CoreException {
        if (this.fReferenceMap == null) {
            this.fReferenceMap = new HashMap();
        }
        Integer type = null;
        Integer visibility = null;
        String id = null;
        String tname = null;
        HashMap rmap = null;
        HashMap mmap = null;
        HashMap vmap = null;
        HashMap<String, HashSet<IReference>> tmap = null;
        HashSet<IReference> reflist = null;
        IApiAnnotations annot = null;
        IApiComponent rcomponent = null;
        IApiComponent mcomponent = null;
        int i = 0;
        while (i < references.length) {
            rcomponent = references[i].getResolvedReference().getApiComponent();
            id = rcomponent.getId();
            rmap = (HashMap)this.fReferenceMap.get(id);
            if (rmap == null) {
                rmap = new HashMap();
                this.fReferenceMap.put(id, rmap);
            }
            if ((mmap = (HashMap)rmap.get(id = (mcomponent = references[i].getMember().getApiComponent()).getId())) == null) {
                mmap = new HashMap();
                rmap.put(id, mmap);
            }
            this.fDescription = rcomponent.getApiDescription();
            annot = this.fDescription.resolveAnnotations(references[i].getResolvedReference().getHandle());
            if (annot != null) {
                visibility = new Integer(annot.getVisibility());
                if (annot.getVisibility() == 2) {
                    IApiComponent host = mcomponent.getHost();
                    if (host != null && host.getId().equals(rcomponent.getId())) {
                        visibility = new Integer(5);
                    } else {
                        IApiAccess access = this.fDescription.resolveAccessLevel(mcomponent.getHandle(), this.getPackageDescriptor(references[i].getResolvedReference()));
                        if (access != null && access.getAccessLevel() == 1) {
                            visibility = new Integer(8);
                        }
                    }
                }
            } else {
                visibility = new Integer(65535);
            }
            if ((vmap = (HashMap)mmap.get(visibility)) == null) {
                vmap = new HashMap();
                mmap.put(visibility, vmap);
            }
            if ((tmap = (HashMap<String, HashSet<IReference>>)vmap.get(type = new Integer(references[i].getReferenceType()))) == null) {
                tmap = new HashMap<String, HashSet<IReference>>();
                vmap.put(type, tmap);
            }
            if ((reflist = (HashSet<IReference>)tmap.get(tname = this.getText(references[i].getResolvedReference()))) == null) {
                reflist = new HashSet<IReference>();
                tmap.put(tname, reflist);
            }
            reflist.add(references[i]);
            ++i;
        }
    }

    private IPackageDescriptor getPackageDescriptor(IApiMember member) throws CoreException {
        IApiType type = null;
        type = member.getType() != 2 ? member.getEnclosingType() : (IApiType)member;
        return Factory.packageDescriptor(type.getPackageName());
    }

    private String getFormattedTypeName(String groupname) {
        if (TYPE_REFERENCES.equals(groupname)) {
            return "Types";
        }
        if (METHOD_REFERENCES.equals(groupname)) {
            return "Methods";
        }
        if (FIELD_REFERENCES.equals(groupname)) {
            return "Fields";
        }
        return "unknown references";
    }

    private String getRefTypeName(int type) {
        switch (type) {
            case 1: {
                return TYPE_REFERENCES;
            }
            case 3: {
                return METHOD_REFERENCES;
            }
            case 2: {
                return FIELD_REFERENCES;
            }
        }
        return "unknown_reference_kinds";
    }

    private void writeXML(File parent) throws CoreException, FileNotFoundException, IOException {
        HashMap vismap = null;
        HashMap typemap = null;
        HashMap rmap = null;
        HashMap mmap = null;
        Integer type = null;
        Integer vis = null;
        String id = null;
        String referee = null;
        File root = null;
        File location = null;
        Iterator iter = this.fReferenceMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            referee = id = (String)entry.getKey();
            location = new File(parent, id);
            if (!location.exists()) {
                location.mkdir();
            }
            rmap = (HashMap)entry.getValue();
            Iterator iter2 = rmap.entrySet().iterator();
            while (iter2.hasNext()) {
                Map.Entry entry2 = iter2.next();
                id = (String)entry2.getKey();
                root = new File(location, id);
                if (!root.exists()) {
                    root.mkdir();
                }
                mmap = (HashMap)entry2.getValue();
                Iterator iter4 = mmap.entrySet().iterator();
                while (iter4.hasNext()) {
                    Map.Entry entry3 = iter4.next();
                    vis = (Integer)entry3.getKey();
                    location = new File(root, VisibilityModifiers.getVisibilityName(vis));
                    if (!location.exists()) {
                        location.mkdir();
                    }
                    vismap = (HashMap)entry3.getValue();
                    Iterator iter3 = vismap.entrySet().iterator();
                    while (iter3.hasNext()) {
                        Map.Entry entry4 = iter3.next();
                        type = (Integer)entry4.getKey();
                        typemap = (HashMap)entry4.getValue();
                        this.writeGroup(id, referee, location, this.getRefTypeName(type), typemap, vis);
                    }
                }
            }
        }
    }

    private void writeGroup(String origin, String referee, File parent, String name, HashMap map, int visibility) throws CoreException, FileNotFoundException, IOException {
        if (parent.exists()) {
            BufferedWriter writer = null;
            try {
                Document doc = null;
                Element root = null;
                int count = 0;
                File out = new File(parent, String.valueOf(name) + ".xml");
                if (out.exists()) {
                    block20: {
                        try {
                            block19: {
                                FileInputStream inputStream = null;
                                try {
                                    try {
                                        inputStream = new FileInputStream(out);
                                        doc = this.parser.parse(inputStream);
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                        if (inputStream != null) {
                                            inputStream.close();
                                        }
                                        break block19;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                    throw throwable;
                                }
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            if (doc != null) break block20;
                            return;
                        }
                        catch (SAXException se) {
                            se.printStackTrace();
                        }
                    }
                    root = doc.getDocumentElement();
                    String value = root.getAttribute("reference_count");
                    count = Integer.parseInt(value);
                }
                doc = Util.newDocument();
                root = doc.createElement("references");
                doc.appendChild(root);
                root.setAttribute("reference_visibility", Integer.toString(visibility));
                root.setAttribute("origin", origin);
                root.setAttribute("referee", referee);
                root.setAttribute("name", this.getFormattedTypeName(name));
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
    }

    private Element findTypeElement(Element root, String tname) {
        if (tname == null) {
            return null;
        }
        Element kelement = null;
        NodeList nodes = root.getElementsByTagName("type_name");
        int i = 0;
        while (i < nodes.getLength()) {
            kelement = (Element)nodes.item(i);
            if (tname.equals(kelement.getAttribute("name"))) {
                return kelement;
            }
            ++i;
        }
        return null;
    }

    private Element findKindElement(Element root, Integer kind) {
        Element kelement = null;
        NodeList nodes = root.getElementsByTagName("reference_kind");
        int i = 0;
        while (i < nodes.getLength()) {
            kelement = (Element)nodes.item(i);
            if (kind.toString().equals(kelement.getAttribute("kind"))) {
                return kelement;
            }
            ++i;
        }
        return null;
    }

    private void writeReference(Document document, Element parent, IReference reference) throws CoreException {
        Element kelement = null;
        Integer kind = new Integer(reference.getReferenceKind());
        kelement = this.findKindElement(parent, kind);
        if (kelement == null) {
            kelement = document.createElement("reference_kind");
            kelement.setAttribute("reference_kind_name", Reference.getReferenceText(kind));
            kelement.setAttribute("kind", kind.toString());
            parent.appendChild(kelement);
        }
        Element relement = document.createElement("reference");
        IApiMember member = reference.getMember();
        relement.setAttribute("origin", this.getText(member));
        member = reference.getResolvedReference();
        if (member != null) {
            relement.setAttribute("referee", this.getText(member));
            relement.setAttribute("linenumber", Integer.toString(reference.getLineNumber()));
            String sig = reference.getReferencedSignature();
            if (sig != null) {
                relement.setAttribute("signature", sig);
            }
            kelement.appendChild(relement);
        }
    }

    private String getText(IApiMember member) throws CoreException {
        switch (member.getType()) {
            case 2: {
                return Signatures.getQualifiedTypeSignature((IApiType)member);
            }
            case 6: {
                return Signatures.getQualifiedMethodSignature((IApiMethod)member);
            }
            case 5: {
                return Signatures.getQualifiedFieldSignature((IApiField)member);
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public void reportNotSearched(IApiElement[] elements) {
        block23: {
            if (elements == null) {
                return;
            }
            writer = null;
            try {
                if (this.debug) {
                    System.out.println("Writing file for projects that were not searched...");
                }
                if (!(rootfile = new File(this.fLocation)).exists()) {
                    rootfile.mkdirs();
                }
                if (!(file = new File(rootfile, "not_searched.xml")).exists()) {
                    file.createNewFile();
                }
                doc = Util.newDocument();
                root = doc.createElement("components");
                doc.appendChild(root);
                comp = null;
                component = null;
                i = 0;
                while (i < elements.length) {
                    component = (SkippedComponent)elements[i];
                    comp = doc.createElement("component");
                    comp.setAttribute("id", component.getComponentId());
                    comp.setAttribute("no_description", Boolean.toString(component.hasNoApiDescription()));
                    comp.setAttribute("excluded", Boolean.toString(component.wasExcluded()));
                    comp.setAttribute("resolution_errors", Boolean.toString(component.hasResolutionErrors()));
                    root.appendChild(comp);
                    ++i;
                }
                writer = new BufferedWriter(new FileWriter(file));
                writer.write(Util.serializeDocument(doc));
                writer.flush();
            }
            catch (FileNotFoundException v0) {
                try {
                    writer.close();
                }
                catch (IOException v1) {}
                break block23;
            }
            catch (IOException v2) {
                ** try [egrp 3[TRYBLOCK] [7 : 268->269)] { 
lbl44:
                // 1 sources

                try {
                    writer.close();
                }
                catch (IOException v3) {}
                break block23;
            }
            catch (CoreException v4) {
                ** try [egrp 5[TRYBLOCK] [8 : 280->281)] { 
lbl-1000:
                // 3 sources

                {
                    catch (Throwable var10_10) {
                        try {
                            writer.close();
                        }
                        catch (IOException v5) {}
                        throw var10_10;
                    }
                }
lbl57:
                // 1 sources

                try {
                    writer.close();
                }
                catch (IOException v6) {}
                break block23;
            }
            try {
                writer.close();
            }
            catch (IOException v7) {}
        }
    }
}

